/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.beacons.mixin;

import dev.sapphic.beacons.MutableTieredBeacon;
import dev.sapphic.beacons.PotencyTier;
import dev.sapphic.beacons.TieredBeacon;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_2580.class})
abstract class BeaconBlockEntityMixin
extends class_2586
implements class_3908,
MutableTieredBeacon {
    @Shadow
    int field_11803;
    @Unique
    private PotencyTier tier = PotencyTier.NONE;

    BeaconBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Inject(method={"tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BeaconBlockEntity;)V"}, require=1, allow=1, at={@At(shift=At.Shift.BY, by=2, value="INVOKE", opcode=184, target="Lnet/minecraft/world/level/block/entity/BeaconBlockEntity;updateBase(Lnet/minecraft/world/level/Level;III)I")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void updateTier(class_1937 level, class_2338 pos, class_2680 state, class_2580 beacon, CallbackInfo ci, int x, int y, int z) {
        PotencyTier tier = PotencyTier.HIGH;
        block0: for (int layerOffset = 1; layerOffset <= 4; ++layerOffset) {
            int yOffset = y - layerOffset;
            if (yOffset < level.method_31607()) {
                tier = PotencyTier.NONE;
                break;
            }
            for (int xOffset = x - layerOffset; xOffset <= x + layerOffset; ++xOffset) {
                for (int zOffset = z - layerOffset; zOffset <= z + layerOffset; ++zOffset) {
                    class_2680 stateAt = level.method_8320(new class_2338(xOffset, yOffset, zOffset));
                    if (!stateAt.method_26164(class_3481.field_22275)) {
                        if (layerOffset != 1) break block0;
                        tier = PotencyTier.NONE;
                        break block0;
                    }
                    PotencyTier tierAt = stateAt.method_26164(PotencyTier.HIGH_POTENCY_BLOCKS) ? PotencyTier.HIGH : (stateAt.method_26164(PotencyTier.LOW_POTENCY_BLOCKS) ? PotencyTier.LOW : PotencyTier.NONE);
                    if (tierAt.ordinal() >= tier.ordinal()) continue;
                    tier = tierAt;
                }
            }
        }
        ((MutableTieredBeacon)beacon).setTier(tier);
    }

    @ModifyVariable(method={"applyEffects(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/effect/MobEffect;Lnet/minecraft/world/effect/MobEffect;)V"}, require=1, allow=1, at=@At(value="STORE", opcode=57, ordinal=0), index=5)
    private static double modifyEffectRadius(double radius, class_1937 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TieredBeacon) {
            TieredBeacon beacon = (TieredBeacon)class_25862;
            return radius + 10.0 * (double)beacon.getTier().ordinal();
        }
        return radius;
    }

    @ModifyVariable(method={"applyEffects(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/effect/MobEffect;Lnet/minecraft/world/effect/MobEffect;)V"}, require=1, allow=1, at=@At(value="STORE", opcode=54, ordinal=0), index=7)
    private static int modifyPrimaryAmplifier(int primaryAmplifier, class_1937 level, class_2338 pos, int levels, @Nullable class_1291 primaryEffect) {
        class_2586 class_25862;
        if (primaryEffect != class_1294.field_5925 && (class_25862 = level.method_8321(pos)) instanceof TieredBeacon) {
            TieredBeacon beacon = (TieredBeacon)class_25862;
            return beacon.getTier().ordinal();
        }
        return primaryAmplifier;
    }

    @ModifyVariable(method={"applyEffects(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/effect/MobEffect;Lnet/minecraft/world/effect/MobEffect;)V"}, require=1, allow=1, at=@At(value="STORE", opcode=54, ordinal=1), index=7)
    private static int modifyPotentPrimaryAmplifier(int primaryAmplifier, class_1937 level, class_2338 pos, int levels, @Nullable class_1291 primaryEffect, @Nullable class_1291 secondaryEffect) {
        class_2586 class_25862;
        if (primaryEffect != class_1294.field_5925 && secondaryEffect != class_1294.field_5906 && secondaryEffect != class_1294.field_5918 && (class_25862 = level.method_8321(pos)) instanceof TieredBeacon) {
            TieredBeacon beacon = (TieredBeacon)class_25862;
            return primaryAmplifier + 1 + Math.min(primaryAmplifier, beacon.getTier().ordinal());
        }
        return primaryAmplifier;
    }

    @ModifyVariable(method={"applyEffects(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/effect/MobEffect;Lnet/minecraft/world/effect/MobEffect;)V"}, require=1, allow=1, at=@At(value="STORE", opcode=54, ordinal=0), index=8)
    private static int modifyDuration(int duration, class_1937 level, class_2338 pos, int levels) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TieredBeacon) {
            TieredBeacon beacon = (TieredBeacon)class_25862;
            return (9 * (beacon.getTier().ordinal() + 1) + levels * 2) * 20;
        }
        return duration;
    }

    @ModifyConstant(method={"applyEffects(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;ILnet/minecraft/world/effect/MobEffect;Lnet/minecraft/world/effect/MobEffect;)V"}, require=1, allow=1, constant={@Constant(intValue=0, ordinal=1)})
    private static int modifySecondaryAmplifier(int secondaryAmplifier, class_1937 level, class_2338 pos, int levels, @Nullable class_1291 primaryEffect, @Nullable class_1291 secondaryEffect) {
        class_2586 class_25862;
        if (secondaryEffect != class_1294.field_5906 && secondaryEffect != class_1294.field_5918 && (class_25862 = level.method_8321(pos)) instanceof TieredBeacon) {
            TieredBeacon beacon = (TieredBeacon)class_25862;
            return beacon.getTier().ordinal();
        }
        return secondaryAmplifier;
    }

    @Override
    @Unique
    public final PotencyTier getTier() {
        return this.tier;
    }

    @Override
    @Unique
    public final void setTier(PotencyTier tier) {
        this.tier = Objects.requireNonNull(tier);
    }

    @Mixin(targets={"net.minecraft.world.level.block.entity.BeaconBlockEntity$1"})
    private static abstract class DataAccessMixin
    implements class_3913 {
        @Final
        @Shadow(aliases={"this$0"})
        class_2580 field_17379;

        private DataAccessMixin() {
        }

        @Inject(method={"get(I)I"}, require=1, at={@At(value="HEAD")}, cancellable=true)
        private void tryGetTier(int index, CallbackInfoReturnable<Integer> cir) {
            if (index == 3) {
                cir.setReturnValue((Object)((TieredBeacon)this.field_17379).getTier().ordinal());
            }
        }

        @Inject(method={"set(II)V"}, require=1, at={@At(value="HEAD")}, cancellable=true)
        private void trySetTier(int index, int value, CallbackInfo ci) {
            if (index == 3) {
                ((MutableTieredBeacon)this.field_17379).setTier(PotencyTier.values()[value]);
                ci.cancel();
            }
        }

        @ModifyConstant(method={"getCount()I"}, require=1, allow=1, constant={@Constant(intValue=3)})
        private int expandDataCount(int count) {
            return 4;
        }
    }
}

