/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.enhancedworkbenches.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import me.luligabi.enhancedworkbenches.client.compat.modmenu.ClothConfiguration;
import me.luligabi.enhancedworkbenches.client.compat.modmenu.ConfigManager;
import me.luligabi.enhancedworkbenches.client.renderer.CraftingStationBlockEntityRenderer;
import me.luligabi.enhancedworkbenches.client.renderer.ProjectTableBlockEntityRenderer;
import me.luligabi.enhancedworkbenches.client.screen.CraftingStationScreen;
import me.luligabi.enhancedworkbenches.client.screen.ProjectTableScreen;
import me.luligabi.enhancedworkbenches.common.block.BlockRegistry;
import me.luligabi.enhancedworkbenches.common.screenhandler.ScreenHandlingRegistry;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3929;
import net.minecraft.class_5616;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedWorkbenchesClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Enhanced Workbenches");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(String.format("%s%senhancedworkbenches-client.json", FabricLoader.getInstance().getConfigDir(), File.separator));
    public static final ClothConfiguration CLIENT_CONFIG = EnhancedWorkbenchesClient.createConfig();

    public void onInitializeClient() {
        class_3929.method_17542(ScreenHandlingRegistry.PROJECT_TABLE_SCREEN_HANDLER, ProjectTableScreen::new);
        class_3929.method_17542(ScreenHandlingRegistry.CRAFTING_STATION_SCREEN_HANDLER, CraftingStationScreen::new);
        class_5616.method_32144(BlockRegistry.CRAFTING_STATION_ENTITY_TYPE, CraftingStationBlockEntityRenderer::new);
        class_5616.method_32144(BlockRegistry.PROJECT_TABLE_ENTITY_TYPE, ProjectTableBlockEntityRenderer::new);
        if (FabricLoader.getInstance().isModLoaded("cloth-config") && FabricLoader.getInstance().isModLoaded("modmenu")) {
            ConfigManager.registerAutoConfig();
            ClothConfiguration config = (ClothConfiguration)AutoConfig.getConfigHolder(ClothConfiguration.class).getConfig();
            try {
                config.validatePostLoad();
            }
            catch (ConfigData.ValidationException e) {
                e.printStackTrace();
            }
        }
    }

    private static ClothConfiguration createConfig() {
        ClothConfiguration finalConfig;
        LOGGER.info("Trying to read config file...");
        try {
            if (CONFIG_FILE.createNewFile()) {
                LOGGER.info("No config file found, creating a new one...");
                EnhancedWorkbenchesClient.writeConfig(GSON.toJson(JsonParser.parseString((String)GSON.toJson((Object)new ClothConfiguration()))));
                finalConfig = new ClothConfiguration();
                LOGGER.info("Successfully created default config file.");
            } else {
                LOGGER.info("A config file was found, loading it..");
                finalConfig = (ClothConfiguration)GSON.fromJson(new String(Files.readAllBytes(CONFIG_FILE.toPath())), ClothConfiguration.class);
                if (finalConfig == null) {
                    throw new NullPointerException("The config file was empty.");
                }
                LOGGER.info("Successfully loaded config file.");
            }
        }
        catch (Exception e) {
            LOGGER.error("There was an error creating/loading the config file!", (Throwable)e);
            finalConfig = new ClothConfiguration();
            LOGGER.warn("Defaulting to original config.");
        }
        return finalConfig;
    }

    public static void saveConfig(ClothConfiguration modConfig) {
        try {
            EnhancedWorkbenchesClient.writeConfig(GSON.toJson(JsonParser.parseString((String)GSON.toJson((Object)modConfig))));
            LOGGER.info("Saved new config file.");
        }
        catch (Exception e) {
            LOGGER.error("There was an error saving the config file!", (Throwable)e);
        }
    }

    private static void writeConfig(String json) {
        try (PrintWriter printWriter = new PrintWriter(CONFIG_FILE);){
            printWriter.write(json);
            printWriter.flush();
        }
        catch (IOException e) {
            LOGGER.error("Failed to write config file", (Throwable)e);
        }
    }
}

