/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.enhancedworkbenches.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import me.luligabi.enhancedworkbenches.client.EnhancedWorkbenchesClient;
import me.luligabi.enhancedworkbenches.common.block.CraftingBlock;
import me.luligabi.enhancedworkbenches.common.block.CraftingBlockEntity;
import net.minecraft.class_1160;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_827;

public abstract class CraftingBlockEntityRenderer<T extends CraftingBlockEntity>
implements class_827<T> {
    private static final HashMap<Integer, class_3545<Double, Double>> NORTH_POSITIONS = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)0, (Object)new class_3545((Object)0.6875, (Object)0.6875)).put((Object)1, (Object)new class_3545((Object)0.5, (Object)0.6875)).put((Object)2, (Object)new class_3545((Object)0.3125, (Object)0.6875)).put((Object)3, (Object)new class_3545((Object)0.6875, (Object)0.5)).put((Object)4, (Object)new class_3545((Object)0.5, (Object)0.5)).put((Object)5, (Object)new class_3545((Object)0.3125, (Object)0.5)).put((Object)6, (Object)new class_3545((Object)0.6875, (Object)0.3125)).put((Object)7, (Object)new class_3545((Object)0.5, (Object)0.3125)).put((Object)8, (Object)new class_3545((Object)0.3125, (Object)0.3125)).build());
    private static final HashMap<Integer, class_3545<Double, Double>> SOUTH_POSITIONS = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)0, (Object)new class_3545((Object)0.3125, (Object)0.3125)).put((Object)1, (Object)new class_3545((Object)0.5, (Object)0.3125)).put((Object)2, (Object)new class_3545((Object)0.6875, (Object)0.3125)).put((Object)3, (Object)new class_3545((Object)0.3125, (Object)0.5)).put((Object)4, (Object)new class_3545((Object)0.5, (Object)0.5)).put((Object)5, (Object)new class_3545((Object)0.6875, (Object)0.5)).put((Object)6, (Object)new class_3545((Object)0.3125, (Object)0.6875)).put((Object)7, (Object)new class_3545((Object)0.5, (Object)0.6875)).put((Object)8, (Object)new class_3545((Object)0.6875, (Object)0.6875)).build());
    private static final HashMap<Integer, class_3545<Double, Double>> WEST_POSITIONS = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)0, (Object)new class_3545((Object)0.6875, (Object)0.3125)).put((Object)1, (Object)new class_3545((Object)0.6875, (Object)0.5)).put((Object)2, (Object)new class_3545((Object)0.6875, (Object)0.6875)).put((Object)3, (Object)new class_3545((Object)0.5, (Object)0.3125)).put((Object)4, (Object)new class_3545((Object)0.5, (Object)0.5)).put((Object)5, (Object)new class_3545((Object)0.5, (Object)0.6875)).put((Object)6, (Object)new class_3545((Object)0.3125, (Object)0.3125)).put((Object)7, (Object)new class_3545((Object)0.3125, (Object)0.5)).put((Object)8, (Object)new class_3545((Object)0.3125, (Object)0.6875)).build());
    private static final HashMap<Integer, class_3545<Double, Double>> EAST_POSITIONS = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)0, (Object)new class_3545((Object)0.3125, (Object)0.6875)).put((Object)1, (Object)new class_3545((Object)0.3125, (Object)0.5)).put((Object)2, (Object)new class_3545((Object)0.3125, (Object)0.3125)).put((Object)3, (Object)new class_3545((Object)0.5, (Object)0.6875)).put((Object)4, (Object)new class_3545((Object)0.5, (Object)0.5)).put((Object)5, (Object)new class_3545((Object)0.5, (Object)0.3125)).put((Object)6, (Object)new class_3545((Object)0.6875, (Object)0.6875)).put((Object)7, (Object)new class_3545((Object)0.6875, (Object)0.5)).put((Object)8, (Object)new class_3545((Object)0.6875, (Object)0.3125)).build());

    public CraftingBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (!this.shouldRender()) {
            return;
        }
        class_1715 inventory = ((CraftingBlockEntity)((Object)entity)).getInput();
        if (inventory.method_5442() || !(entity.method_10997().method_8320(entity.method_11016()).method_26204() instanceof CraftingBlock)) {
            return;
        }
        class_2350 direction = (class_2350)entity.method_10997().method_8320(entity.method_11016()).method_11654((class_2769)class_2741.field_12481);
        int light2 = this.requiresLightmapLighting() ? class_761.method_23794((class_1920)entity.method_10997(), (class_2338)entity.method_11016().method_10084()) : light;
        for (int i = 0; i < 9; ++i) {
            this.renderItem(entity, (class_1263)inventory, i, direction, matrices, vertexConsumers, light2);
        }
    }

    private void renderItem(T entity, class_1263 inventory, int index, class_2350 direction, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (inventory.method_5438(index).method_7960()) {
            return;
        }
        matrices.method_22903();
        class_3545<Double, Double> pos = this.getDirectionPositionMap(direction).get(index);
        class_1799 stack = inventory.method_5438(index);
        class_809 transformation = class_310.method_1551().method_1480().method_4019(stack, null, null, 0).method_4709();
        boolean isBlock = transformation.field_4306.equals((Object)new class_804(new class_1160(0.0f, 0.0f, 0.0f), new class_1160(0.0f, 0.0f, 0.0f), new class_1160(0.5f, 0.5f, 0.5f)));
        matrices.method_22904(((Double)pos.method_15442()).doubleValue(), isBlock ? 1.05 : 1.001, ((Double)pos.method_15441()).doubleValue());
        matrices.method_22905(0.1f, 0.1f, 0.1f);
        matrices.method_22907(class_1160.field_20703.method_23214(90.0f));
        matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
        matrices.method_22907(class_1160.field_20707.method_23214(this.getItemAngle(direction)));
        class_310.method_1551().method_1480().method_23178(stack, isBlock ? class_809.class_811.field_4315 : class_809.class_811.field_4317, light, class_4608.field_21444, matrices, vertexConsumers, (int)entity.method_11016().method_10063());
        matrices.method_22909();
    }

    private HashMap<Integer, class_3545<Double, Double>> getDirectionPositionMap(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> NORTH_POSITIONS;
            case class_2350.field_11035 -> SOUTH_POSITIONS;
            case class_2350.field_11039 -> WEST_POSITIONS;
            case class_2350.field_11034 -> EAST_POSITIONS;
            default -> throw new IllegalStateException("Unexpected direction: " + direction);
        };
    }

    private float getItemAngle(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> 0.0f;
            case class_2350.field_11035 -> 180.0f;
            case class_2350.field_11039, class_2350.field_11034 -> direction.method_10161() * 90;
            default -> throw new IllegalStateException("Unexpected direction: " + direction);
        };
    }

    private boolean shouldRender() {
        if (!EnhancedWorkbenchesClient.CLIENT_CONFIG.renderInput || !this.canRender()) {
            return false;
        }
        return !EnhancedWorkbenchesClient.CLIENT_CONFIG.renderInputRequireFancy || class_310.method_1517();
    }

    protected abstract boolean canRender();

    protected abstract boolean requiresLightmapLighting();

    public int method_33893() {
        return EnhancedWorkbenchesClient.CLIENT_CONFIG.renderInputDistance * 16;
    }

    public boolean rendersOutsideBoundingBox(T blockEntity) {
        return true;
    }
}

