/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.workers;

import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.chaosthedude.explorerscompass.workers.ConcentricRingsSearchWorker;
import com.chaosthedude.explorerscompass.workers.GenericSearchWorker;
import com.chaosthedude.explorerscompass.workers.RandomSpreadSearchWorker;
import com.chaosthedude.explorerscompass.workers.StructureSearchWorker;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_6871;
import net.minecraft.class_6872;
import net.minecraft.class_6874;
import org.apache.commons.lang3.RandomStringUtils;

public class SearchWorkerManager {
    private final String id = RandomStringUtils.random((int)8, (String)"0123456789abcdef");
    private List<StructureSearchWorker<?>> workers = new ArrayList();

    public void createWorkers(class_3218 world, class_1657 player, class_1799 stack, List<class_3195> structures, class_2338 startPos) {
        this.workers.clear();
        Object2ObjectArrayMap placementToStructuresMap = new Object2ObjectArrayMap();
        for (class_3195 class_31952 : structures) {
            for (class_6874 structureplacement : world.method_14178().method_12129().method_41055(StructureUtils.getEntryForStructure(world, class_31952), world.method_14178().method_41248())) {
                placementToStructuresMap.computeIfAbsent(structureplacement, holderSet -> new ObjectArrayList()).add(class_31952);
            }
        }
        for (Map.Entry entry : placementToStructuresMap.entrySet()) {
            class_6874 placement = (class_6874)entry.getKey();
            if (placement instanceof class_6871) {
                this.workers.add(new ConcentricRingsSearchWorker(world, player, stack, startPos, (class_6871)placement, (List<class_3195>)((List)entry.getValue()), this.id));
                continue;
            }
            if (placement instanceof class_6872) {
                this.workers.add(new RandomSpreadSearchWorker(world, player, stack, startPos, (class_6872)placement, (List<class_3195>)((List)entry.getValue()), this.id));
                continue;
            }
            this.workers.add(new GenericSearchWorker(world, player, stack, startPos, placement, (List<class_3195>)((List)entry.getValue()), this.id));
        }
    }

    public boolean start() {
        if (!this.workers.isEmpty()) {
            this.workers.get(0).start();
            return true;
        }
        return false;
    }

    public void pop() {
        if (!this.workers.isEmpty()) {
            this.workers.remove(0);
        }
    }

    public void stop() {
        for (StructureSearchWorker<?> worker : this.workers) {
            worker.stop();
        }
    }

    public void clear() {
        this.workers.clear();
    }
}

