/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.client.renderer;

import io.github.mattidragon.extendeddrawers.config.ClientConfig;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_809;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDrawerBlockEntityRenderer<T extends class_2586>
implements class_827<T> {
    private static final class_1158 ITEM_LIGHT_ROTATION_3D = class_1160.field_20703.method_23214(-15.0f);
    private static final class_1158 ITEM_LIGHT_ROTATION_FLAT;
    private final class_918 itemRenderer;
    private final class_327 textRenderer;

    public AbstractDrawerBlockEntityRenderer(class_5614.class_5615 context) {
        this.itemRenderer = context.method_43335();
        this.textRenderer = context.method_32143();
    }

    public void renderSlot(ItemVariant item, @Nullable Long amount, boolean small, List<class_1058> icons, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, int seed, class_2338 pos) {
        ClientConfig config;
        class_746 player = class_310.method_1551().field_1724;
        class_243 playerPos = player == null ? class_243.method_24953((class_2382)pos) : player.method_19538();
        if (pos.method_19769((class_2374)playerPos, (double)(config = (ClientConfig)ClientConfig.HANDLE.get()).textRenderDistance()) && amount != null) {
            this.renderText(amount, small, light, matrices, vertexConsumers);
        }
        if (pos.method_19769((class_2374)playerPos, (double)config.iconRenderDistance())) {
            this.renderIcons(icons, small, light, matrices, vertexConsumers, overlay);
        }
        if (pos.method_19769((class_2374)playerPos, (double)config.itemRenderDistance())) {
            this.renderItem(item, small, light, matrices, vertexConsumers, seed);
        }
    }

    protected final boolean shouldRender(T drawer, class_2350 facing) {
        class_1937 world = drawer.method_10997();
        if (world == null) {
            return false;
        }
        class_2338 pos = drawer.method_11016();
        class_2680 state = drawer.method_11010();
        return class_2248.method_9607((class_2680)state, (class_1922)world, (class_2338)pos, (class_2350)facing, (class_2338)pos.method_10093(facing));
    }

    protected void renderIcons(List<class_1058> icons, boolean small, int light, class_4587 matrices, class_4597 vertexConsumers, int overlay) {
        double increment = 1.0 / ((double)icons.size() + 1.0);
        matrices.method_22903();
        if (small) {
            matrices.method_22905(0.5f, 0.5f, 1.0f);
        }
        matrices.method_22904(-0.5, 0.0, 0.0);
        for (class_1058 icon : icons) {
            matrices.method_22904(increment, 0.0, 0.0);
            this.renderIcon(icon, light, matrices, vertexConsumers, overlay);
        }
        matrices.method_22909();
    }

    private void renderIcon(class_1058 sprite, int light, class_4587 matrices, class_4597 vertexConsumers, int overlay) {
        matrices.method_22903();
        matrices.method_22907(class_1160.field_20703.method_23214(90.0f));
        matrices.method_22904(-0.125, -0.24, -0.5);
        matrices.method_22905(0.25f, 0.25f, 0.25f);
        QuadEmitter emitter = Objects.requireNonNull(RendererAccess.INSTANCE.getRenderer()).meshBuilder().getEmitter();
        emitter.square(class_2350.field_11036, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        emitter.spriteBake(0, sprite, 4);
        vertexConsumers.getBuffer(class_1921.method_23581()).method_22919(matrices.method_23760(), emitter.toBakedQuad(0, sprite, false), 1.0f, 1.0f, 1.0f, light, overlay);
        matrices.method_22909();
    }

    protected void renderItem(ItemVariant item, boolean small, int light, class_4587 matrices, class_4597 vertexConsumers, int seed) {
        if (item.isBlank()) {
            return;
        }
        float itemScale = ((ClientConfig)ClientConfig.HANDLE.get()).itemScale(small);
        matrices.method_22903();
        matrices.method_22905(itemScale, itemScale, 1.0f);
        matrices.method_22905(0.75f, 0.75f, 1.0f);
        matrices.method_34425(class_1159.method_24019((float)1.0f, (float)1.0f, (float)0.01f));
        class_1799 stack = item.toStack();
        class_1087 model = this.itemRenderer.method_4019(stack, null, null, seed);
        if (model.method_24304()) {
            matrices.method_23760().method_23762().method_23274(ITEM_LIGHT_ROTATION_3D);
        } else {
            matrices.method_23760().method_23762().method_23274(ITEM_LIGHT_ROTATION_FLAT);
        }
        this.itemRenderer.method_23179(stack, class_809.class_811.field_4317, false, matrices, vertexConsumers, light, class_4608.field_21444, model);
        matrices.method_22909();
    }

    protected void renderText(long amount, boolean small, int light, class_4587 matrices, class_4597 vertexConsumers) {
        ClientConfig config = (ClientConfig)ClientConfig.HANDLE.get();
        matrices.method_22903();
        matrices.method_22907(class_1160.field_20703.method_23214(180.0f));
        if (small) {
            matrices.method_22904(0.0, 0.25, -0.01);
        } else {
            matrices.method_22904(0.0, 0.5, -0.01);
        }
        matrices.method_22905(config.textScale(small), config.textScale(small), 1.0f);
        matrices.method_22904(0.0, (double)(-config.textOffset()), -0.01);
        matrices.method_22905(0.02f, 0.02f, 0.02f);
        String text = Long.toString(amount);
        this.textRenderer.method_27521(text, (float)(-this.textRenderer.method_1727(text)) / 2.0f, 0.0f, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
        matrices.method_22909();
    }

    protected void alignMatrices(class_4587 matrices, class_2350 dir) {
        class_1160 pos = dir.method_23955();
        matrices.method_22904((double)(pos.method_4943() / 2.0f) + 0.5, (double)(pos.method_4945() / 2.0f) + 0.5, (double)(pos.method_4947() / 2.0f) + 0.5);
        matrices.method_22907(dir.method_23224());
        matrices.method_22907(class_1160.field_20703.method_23214(-90.0f));
        matrices.method_22904(0.0, 0.0, 0.01);
    }

    static {
        ITEM_LIGHT_ROTATION_3D.method_4925(class_1160.field_20705.method_23214(15.0f));
        ITEM_LIGHT_ROTATION_FLAT = class_1160.field_20703.method_23214(-45.0f);
    }
}

