/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.networking;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.compacting.CompressionLadder;
import io.github.mattidragon.extendeddrawers.compacting.CompressionRecipeManager;
import java.util.List;
import java.util.NoSuchElementException;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2960;

public class CompressionOverrideSyncPacket {
    public static final class_2960 ID = ExtendedDrawers.id("compression_override_sync");

    private CompressionOverrideSyncPacket() {
    }

    public static void register() {
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> player.field_13987.method_14364(CompressionOverrideSyncPacket.write(CompressionRecipeManager.of(player.field_13995.method_3772()).getOverrides())));
    }

    public static class_2596<class_2602> write(List<CompressionLadder> overrides) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_34062(overrides, (buf1, ladder) -> buf1.method_34062(ladder.steps(), (buf2, step) -> {
            buf2.method_42065((class_2359)class_2378.field_11142, (Object)step.item().getItem());
            buf2.method_10794(step.item().getNbt());
            buf2.method_10804(step.size());
        }));
        return ServerPlayNetworking.createS2CPacket((class_2960)ID, (class_2540)buf);
    }

    public static List<CompressionLadder> read(class_2540 buf) {
        return buf.method_34066(buf1 -> {
            CompressionLadder ladder = new CompressionLadder(buf1.method_34066(buf2 -> {
                class_1792 item = (class_1792)buf2.method_42064((class_2359)class_2378.field_11142);
                if (item == null) {
                    throw new NoSuchElementException("Invalid item in compression ladder deserialization");
                }
                class_2487 nbt = buf2.method_10798();
                int size = buf2.method_10816();
                return new CompressionLadder.Step(ItemVariant.of((class_1935)item, (class_2487)nbt), size);
            }));
            if (ladder.steps().isEmpty()) {
                throw new IllegalStateException("No steps in ladder");
            }
            int compression = 0;
            for (CompressionLadder.Step step : ladder.steps()) {
                if (compression >= step.size()) {
                    throw new IllegalStateException("Illegal ladder order");
                }
                compression = step.size();
            }
            return ladder;
        });
    }
}

