/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.storage;

import com.google.common.collect.Iterators;
import io.github.mattidragon.extendeddrawers.storage.DrawerSlot;
import java.util.Arrays;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class CombinedDrawerStorage
implements Storage<ItemVariant> {
    private DrawerSlot[] slots;

    public CombinedDrawerStorage(DrawerSlot[] slots) {
        this.slots = Arrays.copyOf(slots, slots.length);
    }

    public void sort() {
        this.slots = Arrays.copyOf(this.slots, this.slots.length);
        Arrays.sort(this.slots);
    }

    public boolean supportsInsertion() {
        for (DrawerSlot part : this.slots) {
            if (!part.supportsInsertion()) continue;
            return true;
        }
        return false;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long amount = 0L;
        for (DrawerSlot part : this.slots) {
            if ((amount += part.insert(resource, maxAmount - amount, transaction)) == maxAmount) break;
        }
        return amount;
    }

    public boolean supportsExtraction() {
        for (DrawerSlot part : this.slots) {
            if (!part.supportsExtraction()) continue;
            return true;
        }
        return false;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long amount = 0L;
        for (DrawerSlot part : this.slots) {
            if ((amount += part.extract(resource, maxAmount - amount, transaction)) == maxAmount) break;
        }
        return amount;
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return Iterators.forArray((Object[])this.slots);
    }
}

