/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.storage;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.entity.DrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.config.CommonConfig;
import io.github.mattidragon.extendeddrawers.item.UpgradeItem;
import io.github.mattidragon.extendeddrawers.misc.ItemUtils;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public final class DrawerSlot
extends SnapshotParticipant<Snapshot>
implements SingleSlotStorage<ItemVariant>,
DrawerStorage {
    private final DrawerBlockEntity owner;
    private final DrawerStorage.Settings settings;
    private final double capacityMultiplier;
    private ItemVariant item = ItemVariant.blank();
    private long amount;

    public DrawerSlot(DrawerBlockEntity owner, double capacityMultiplier) {
        this.owner = owner;
        this.capacityMultiplier = capacityMultiplier;
        this.settings = new DrawerStorage.Settings();
    }

    @Override
    public boolean changeUpgrade(@Nullable UpgradeItem newUpgrade, class_1937 world, class_2338 pos, class_2350 side, @Nullable class_1657 player) {
        UpgradeItem oldUpgrade = this.settings.upgrade;
        this.settings.upgrade = newUpgrade;
        if (this.getAmount() > this.getCapacity() && ((CommonConfig)CommonConfig.HANDLE.get()).blockUpgradeRemovalsWithOverflow()) {
            this.settings.upgrade = oldUpgrade;
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"extended_drawer.drawer.upgrade_fail"), true);
            }
            return false;
        }
        ItemUtils.offerOrDrop(world, pos, side, player, new class_1799((class_1935)oldUpgrade));
        this.dumpExcess(world, pos, side, player);
        return true;
    }

    @Override
    public DrawerBlockEntity getOwner() {
        return this.owner;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!resource.equals(this.item) && !this.item.isBlank()) {
            return 0L;
        }
        if (!((CommonConfig)CommonConfig.HANDLE.get()).allowRecursion() && !resource.getItem().method_31568()) {
            return 0L;
        }
        if (this.item.isBlank() && this.settings.locked && !this.settings.lockOverridden) {
            return 0L;
        }
        long inserted = Math.min(this.getCapacity() - this.amount, maxAmount);
        if (inserted > 0L) {
            this.updateSnapshots(transaction);
            this.amount += inserted;
            if (this.item.isBlank()) {
                this.item = resource;
                this.settings.sortingDirty = true;
            }
        } else if (inserted < 0L) {
            ExtendedDrawers.LOGGER.warn("Somehow inserted negative amount of items ({}) into drawer, aborting. Arguments: item={} maxAmount={}. Status: item={} capacity={} amount={}", new Object[]{inserted, this.item, maxAmount, this.item, this.getCapacity(), this.amount});
            return 0L;
        }
        return this.settings.voiding ? maxAmount : inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!resource.equals(this.item)) {
            return 0L;
        }
        long extracted = Math.min(this.amount, maxAmount);
        if (extracted > 0L) {
            this.updateSnapshots(transaction);
            this.amount -= extracted;
            if (this.amount == 0L && !this.settings.locked) {
                this.item = ItemVariant.blank();
                this.settings.sortingDirty = true;
            }
        } else if (extracted < 0L) {
            ExtendedDrawers.LOGGER.warn("Somehow extract negative amount of items ({}) from drawer, aborting. Arguments: item={} maxAmount={}. Status: item={} capacity={} amount={}", new Object[]{extracted, this.item, maxAmount, this.item, this.getCapacity(), this.amount});
            return 0L;
        }
        return extracted;
    }

    public boolean isResourceBlank() {
        return this.item.isBlank();
    }

    public ItemVariant getResource() {
        return this.item;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getCapacity() {
        CommonConfig config = (CommonConfig)CommonConfig.HANDLE.get();
        long capacity = (long)((double)config.defaultCapacity() * this.capacityMultiplier);
        if (config.stackSizeAffectsCapacity()) {
            capacity = (long)((double)capacity / (64.0 / (double)this.item.getItem().method_7882()));
        }
        if (this.settings.upgrade != null) {
            capacity = this.settings.upgrade.modifier.applyAsLong(capacity);
        }
        return capacity;
    }

    protected Snapshot createSnapshot() {
        return new Snapshot((ResourceAmount<ItemVariant>)new ResourceAmount((Object)this.item, this.amount), this.settings.sortingDirty);
    }

    protected void readSnapshot(Snapshot snapshot) {
        this.item = (ItemVariant)snapshot.contents.resource();
        this.amount = snapshot.contents.amount();
        this.settings.sortingDirty = snapshot.itemChanged;
    }

    protected void onFinalCommit() {
        this.update();
    }

    @Override
    public void dumpExcess(class_1937 world, class_2338 pos, @Nullable class_2350 side, @Nullable class_1657 player) {
        if (this.amount > this.getCapacity()) {
            ItemUtils.offerOrDropStacks(world, pos, side, player, this.item, this.amount - this.getCapacity());
            this.amount = this.getCapacity();
        }
        this.update();
    }

    @Override
    public void readNbt(class_2487 nbt) {
        DrawerStorage.super.readNbt(nbt);
        this.item = ItemVariant.fromNbt((class_2487)nbt.method_10562("item"));
        this.amount = nbt.method_10537("amount");
        if (this.item.isBlank()) {
            this.amount = 0L;
        }
    }

    @Override
    public void writeNbt(class_2487 nbt) {
        DrawerStorage.super.writeNbt(nbt);
        nbt.method_10566("item", (class_2520)this.item.toNbt());
        nbt.method_10544("amount", this.amount);
    }

    public ItemVariant getItem() {
        return this.item;
    }

    @Override
    public void setLocked(boolean locked) {
        if (!locked && this.amount == 0L) {
            this.item = ItemVariant.blank();
        }
        DrawerStorage.super.setLocked(locked);
    }

    @Override
    public DrawerStorage.Settings settings() {
        return this.settings;
    }

    @Override
    public boolean isBlank() {
        return this.isResourceBlank();
    }

    record Snapshot(ResourceAmount<ItemVariant> contents, boolean itemChanged) {
    }
}

