/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.attached;

import dev.technici4n.moderndynamics.attachment.settings.FilterDamageMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterInversionMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterModMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterNbtMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public final class ItemCachedFilter {
    private final Set<ItemVariant> listedVariants;
    private final Set<class_1792> listedItems;
    private final FilterInversionMode filterInversion;
    private final FilterDamageMode filterDamage;
    private final FilterNbtMode filterNbt;
    private final FilterModMode filterMod;
    @Nullable
    private Set<String> listedMods;

    public ItemCachedFilter(List<ItemVariant> filterConfig, FilterInversionMode filterInversion, FilterDamageMode filterDamage, FilterNbtMode filterNbt, FilterModMode filterMod) {
        this.filterInversion = filterInversion;
        this.filterDamage = filterDamage;
        this.filterNbt = filterNbt;
        this.filterMod = filterMod;
        this.listedVariants = new HashSet<ItemVariant>(filterConfig.size());
        this.listedItems = Collections.newSetFromMap(new IdentityHashMap());
        for (ItemVariant variant : filterConfig) {
            if (variant.isBlank()) continue;
            this.listedVariants.add(variant);
            this.listedItems.add(variant.getItem());
        }
    }

    private boolean isItemListed(ItemVariant variant) {
        boolean itemIsListed = false;
        if (this.filterMod == FilterModMode.INCLUDE_ALL_OF_MOD) {
            if (this.getListedMods().contains(ItemCachedFilter.getModId(variant))) {
                itemIsListed = true;
            }
        } else {
            itemIsListed = this.filterNbt == FilterNbtMode.RESPECT_NBT ? this.listedVariants.contains(variant) : this.listedItems.contains(variant.getItem());
        }
        if (!itemIsListed) {
            // empty if block
        }
        return itemIsListed;
    }

    public boolean matchesItem(ItemVariant variant) {
        return this.isItemListed(variant) == (this.filterInversion == FilterInversionMode.WHITELIST);
    }

    private Set<String> getListedMods() {
        if (this.listedMods == null) {
            this.listedMods = new HashSet<String>();
            for (ItemVariant variant : this.listedVariants) {
                this.listedMods.add(ItemCachedFilter.getModId(variant));
            }
        }
        return this.listedMods;
    }

    public boolean matchesFluid(FluidVariant variant) {
        return false;
    }

    private static String getModId(ItemVariant variant) {
        return class_2378.field_11142.method_10221((Object)variant.getItem()).method_12836();
    }

    private static String getModId(FluidVariant variant) {
        return class_2378.field_11154.method_10221((Object)variant.getFluid()).method_12836();
    }

    private static boolean matchDamageIgnoreRest(@Nullable class_2487 a, @Nullable class_2487 b) {
        return ItemCachedFilter.getDamage(a) == ItemCachedFilter.getDamage(b);
    }

    private static boolean matchIgnoringDamage(@Nullable class_2487 a, @Nullable class_2487 b) {
        if (a == b) {
            return true;
        }
        throw new NotImplementedException();
    }

    private static int getDamage(class_2487 tag) {
        return tag == null ? 0 : tag.method_10550("Damage");
    }

    @FunctionalInterface
    static interface NbtMatcher {
        public boolean matches(@Nullable class_2487 var1, @Nullable class_2487 var2);
    }
}

