/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.upgrade;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.technici4n.moderndynamics.ModernDynamics;
import dev.technici4n.moderndynamics.attachment.upgrade.LoadedUpgrades;
import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import dev.technici4n.moderndynamics.util.MdId;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class AttachmentUpgradesLoader
extends class_4080<List<JsonObject>>
implements IdentifiableResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<class_3300, LoadedUpgrades> LOADED_UPGRADES = new WeakHashMap<class_3300, LoadedUpgrades>();

    private AttachmentUpgradesLoader() {
    }

    public class_2960 getFabricId() {
        return MdId.of("attachment_upgrades_loader");
    }

    protected List<JsonObject> prepare(class_3300 resourceManager, class_3695 profiler) {
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        for (Map.Entry entry : resourceManager.method_14488("attachment_upgrades", s -> s.method_12832().endsWith(".json")).entrySet()) {
            class_3298 resource = (class_3298)entry.getValue();
            try {
                InputStream inputStream = resource.method_14482();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    result.add(JsonParser.parseReader((Reader)reader).getAsJsonObject());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (JsonParseException | IOException | IllegalStateException exception) {
                ModernDynamics.LOGGER.error("Error when loading Modern Dynamics attachment upgrade with path %s".formatted(entry.getKey()), exception);
            }
        }
        return result;
    }

    protected void apply(List<JsonObject> array, class_3300 resourceManager, class_3695 profiler) {
        IdentityHashMap<class_1792, UpgradeType> map = new IdentityHashMap<class_1792, UpgradeType>();
        ArrayList<class_1792> list = new ArrayList<class_1792>();
        for (JsonObject obj : array) {
            if (!ResourceConditions.objectMatchesConditions((JsonObject)obj)) continue;
            try {
                class_1792 item = class_3518.method_15288((JsonObject)obj, (String)"item");
                UpgradeType deserialized = (UpgradeType)GSON.fromJson((JsonElement)obj, UpgradeType.class);
                if (!map.containsKey(item)) {
                    list.add(item);
                }
                map.put(item, deserialized);
            }
            catch (Exception exception) {
                ModernDynamics.LOGGER.error("Failed to read attachment upgrade entry " + obj, (Throwable)exception);
            }
        }
        LOADED_UPGRADES.put(resourceManager, new LoadedUpgrades(map, list));
    }

    public static void setup() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new AttachmentUpgradesLoader());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> LoadedUpgrades.trySet(LOADED_UPGRADES.remove(server.method_34864())));
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> {
            if (success) {
                LoadedUpgrades.trySet(LOADED_UPGRADES.remove(resourceManager));
            }
        });
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> {
            LoadedUpgrades.trySet(LOADED_UPGRADES.remove(player.field_13995.method_34864()));
            LoadedUpgrades.syncToClient(player);
        });
    }
}

