/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
record UpgradeRecipe(class_1792 item, UpgradeType upgradeInfo) implements EmiRecipe
{
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(MdId.of("upgrades"), (EmiRenderable)EmiStack.of((class_1935)MdItems.EXTRACTOR)){

        public class_2561 getName() {
            return class_2561.method_43471((String)"gui.moderndynamics.rei.upgrade_category");
        }
    };

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        class_2960 itemId = class_2378.field_11142.method_10221((Object)this.item);
        return MdId.of("upgrades/" + itemId.method_12836() + "/" + itemId.method_12832());
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of((class_1935)this.item));
    }

    public List<EmiStack> getOutputs() {
        return List.of();
    }

    public int getDisplayWidth() {
        return 134;
    }

    public int getDisplayHeight() {
        return 59;
    }

    public void addWidgets(WidgetHolder widgets) {
        UpgradeType type = this.upgradeInfo;
        class_2960 texture = MdId.of("textures/gui/icons.png");
        int baseY = 37;
        int countXOffset = 17;
        int countY = 50;
        int effectWidth = 23;
        int effectSpacing = 5;
        widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)this.item), 2, 2);
        widgets.addText(class_2561.method_43469((String)"gui.moderndynamics.tooltip.upgrades_max", (Object[])new Object[]{type.getSlotLimit()}).method_30937(), 25, 7, -12566464, false);
        widgets.addText(class_2561.method_43471((String)"gui.moderndynamics.tooltip.upgrades_effects").method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true))).method_30937(), this.getDisplayWidth() / 2, 23, -12566464, false).horizontalAlign(TextWidget.Alignment.CENTER);
        ArrayList<UpgradeEffect> effects = new ArrayList<UpgradeEffect>();
        effects.add(new UpgradeEffect(0, type.isEnableAdvancedBehavior() ? -1 : 0, "enableAdvancedBehavior", class_1074.method_4662((String)"gui.moderndynamics.tooltip.advanced_behavior_available", (Object[])new Object[0])));
        effects.add(new UpgradeEffect(16, type.getAddFilterSlots(), "addFilterSlots", "+" + type.getAddFilterSlots()));
        effects.add(new UpgradeEffect(32, type.getAddItemCount(), "addItemCount", "+" + type.getAddItemCount()));
        effects.add(new UpgradeEffect(48, type.getAddItemSpeed(), "addItemSpeed", "+" + type.getAddItemSpeed() * 100 + "%"));
        effects.add(new UpgradeEffect(64, type.getAddItemTransferFrequency(), "addItemTransferFrequency", "+" + type.getAddItemTransferFrequency() * 100 + "%"));
        effects.add(new UpgradeEffect(80, type.getAddFluidTransfer(), "addFluidTransfer", "+" + type.getAddFluidTransfer() * 100 + "%"));
        effects.add(new UpgradeEffect(96, type.getMultiplyFluidTransfer(), "multiplyFluidTransfer", "+" + type.getMultiplyFluidTransfer() * 100 + "%"));
        effects.removeIf(e -> e.count() == 0);
        if (effects.size() > 0) {
            int totalWidth = effects.size() * effectWidth + (effects.size() - 1) * effectSpacing;
            int baseX = (this.getDisplayWidth() - totalWidth) / 2;
            for (UpgradeEffect e2 : effects) {
                class_2583 greenStyle = class_2583.field_24360.method_27706(class_124.field_1060);
                class_5250 tooltip = class_2561.method_43469((String)("gui.moderndynamics.tooltip.upgrade_" + e2.upgradeName()), (Object[])new Object[]{class_2561.method_43470((String)e2.greenText).method_10862(greenStyle)});
                widgets.addTexture(texture, baseX, baseY, 16, 16, e2.textureU(), 0);
                String renderedString = e2.count() > 0 ? "" + e2.count() : "";
                widgets.addText(class_2561.method_43470((String)renderedString).method_30937(), baseX + countXOffset, countY, -12566464, false).horizontalAlign(TextWidget.Alignment.CENTER);
                widgets.addDrawable(baseX, baseY, 20, 20, (matrices, mouseX, mouseY, delta) -> {}).tooltip((mouseX, mouseY) -> List.of(class_5684.method_32662((class_5481)tooltip.method_30937())));
                baseX += effectWidth + effectSpacing;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record UpgradeEffect(int textureU, int count, String upgradeName, String greenText) {
    }
}

