/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.compat.jei;

import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import dev.technici4n.moderndynamics.client.compat.jei.UpgradeDisplay;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;

@Environment(value=EnvType.CLIENT)
public class UpgradeCategory
implements IRecipeCategory<UpgradeDisplay> {
    public static final RecipeType<UpgradeDisplay> TYPE = RecipeType.create((String)"moderndynamics", (String)"upgrades", UpgradeDisplay.class);
    public static final int EFFECT_WIDTH = 23;
    public static final int EFFECT_SPACING = 5;
    public static final int EFFECT_BASE_Y = 37;
    public static final class_2960 ICON_TEXTURE = MdId.of("textures/gui/icons.png");
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable slotDrawable;
    private final IDrawable[] icons;

    public UpgradeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(142, 59);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)MdItems.EXTRACTOR));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.icons = new IDrawable[]{guiHelper.createDrawable(ICON_TEXTURE, 0, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 16, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 32, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 48, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 64, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 80, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 96, 0, 16, 16)};
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"gui.moderndynamics.rei.upgrade_category");
    }

    public RecipeType<UpgradeDisplay> getRecipeType() {
        return TYPE;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, UpgradeDisplay recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 3).addItemStack(new class_1799((class_1935)recipe.item()));
    }

    private EffectsInfo computeEffects(UpgradeDisplay recipe) {
        UpgradeType type = recipe.upgradeInfo();
        ArrayList<UpgradeEffect> effects = new ArrayList<UpgradeEffect>();
        effects.add(new UpgradeEffect(0, type.isEnableAdvancedBehavior() ? -1 : 0, "enableAdvancedBehavior", class_1074.method_4662((String)"gui.moderndynamics.tooltip.advanced_behavior_available", (Object[])new Object[0])));
        effects.add(new UpgradeEffect(1, type.getAddFilterSlots(), "addFilterSlots", "+" + type.getAddFilterSlots()));
        effects.add(new UpgradeEffect(2, type.getAddItemCount(), "addItemCount", "+" + type.getAddItemCount()));
        effects.add(new UpgradeEffect(3, type.getAddItemSpeed(), "addItemSpeed", "+" + type.getAddItemSpeed() * 100 + "%"));
        effects.add(new UpgradeEffect(4, type.getAddItemTransferFrequency(), "addItemTransferFrequency", "+" + type.getAddItemTransferFrequency() * 100 + "%"));
        effects.add(new UpgradeEffect(5, type.getAddFluidTransfer(), "addFluidTransfer", "+" + type.getAddFluidTransfer() * 100 + "%"));
        effects.add(new UpgradeEffect(6, type.getMultiplyFluidTransfer(), "multiplyFluidTransfer", "+" + type.getMultiplyFluidTransfer() * 100 + "%"));
        effects.removeIf(e -> e.count() == 0);
        int totalWidth = effects.size() * 23 + (effects.size() - 1) * 5;
        int effectsBaseX = (this.background.getWidth() - totalWidth) / 2;
        return new EffectsInfo(effects, effectsBaseX);
    }

    public void draw(UpgradeDisplay recipe, IRecipeSlotsView recipeSlotsView, class_4587 stack, double mouseX, double mouseY) {
        this.slotDrawable.draw(stack, 2, 2);
        UpgradeType type = recipe.upgradeInfo();
        int countXOffset = 17;
        int countY = 50;
        class_310 minecraft = class_310.method_1551();
        class_327 fontRenderer = minecraft.field_1772;
        class_5250 maxUpgrades = class_2561.method_43469((String)"gui.moderndynamics.tooltip.upgrades_max", (Object[])new Object[]{type.getSlotLimit()});
        fontRenderer.method_30883(stack, (class_2561)maxUpgrades, 25.0f, 7.0f, -12566464);
        class_5250 effectsText = class_2561.method_43471((String)"gui.moderndynamics.tooltip.upgrades_effects").method_27692(class_124.field_1073);
        int effectsTextX = (this.background.getWidth() - fontRenderer.method_27525((class_5348)effectsText)) / 2;
        fontRenderer.method_30883(stack, (class_2561)effectsText, (float)effectsTextX, 23.0f, -12566464);
        EffectsInfo effects = this.computeEffects(recipe);
        int baseX = effects.effectsBaseX();
        for (UpgradeEffect e : effects.effects()) {
            this.icons[e.iconIndex].draw(stack, baseX, 37);
            if (e.count >= 0) {
                fontRenderer.method_1729(stack, String.valueOf(e.count), (float)(baseX + countXOffset), (float)countY, -12566464);
            }
            baseX += 28;
        }
    }

    public List<class_2561> getTooltipStrings(UpgradeDisplay recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        EffectsInfo effects = this.computeEffects(recipe);
        int x = effects.effectsBaseX();
        for (UpgradeEffect e : effects.effects()) {
            class_768 tooltipRect = new class_768(x, 37, 20, 20);
            if (tooltipRect.method_3318((int)mouseX, (int)mouseY)) {
                class_2583 greenStyle = class_2583.field_24360.method_27706(class_124.field_1060);
                class_5250 tooltip = class_2561.method_43469((String)("gui.moderndynamics.tooltip.upgrade_" + e.upgradeName()), (Object[])new Object[]{class_2561.method_43470((String)e.greenText).method_10862(greenStyle)});
                return List.of(tooltip);
            }
            x += 28;
        }
        return List.of();
    }

    @Environment(value=EnvType.CLIENT)
    private record UpgradeEffect(int iconIndex, int count, String upgradeName, String greenText) {
    }

    @Environment(value=EnvType.CLIENT)
    private record EffectsInfo(List<UpgradeEffect> effects, int effectsBaseX) {
    }
}

