/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.model;

import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.client.GeometryHelper;
import dev.technici4n.moderndynamics.client.model.AttachmentsBakedModel;
import dev.technici4n.moderndynamics.model.AttachmentModelData;
import dev.technici4n.moderndynamics.model.PipeModelData;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PipeBakedModel
implements class_1087,
FabricBakedModel {
    private final class_1058 baseSprite;
    private final Mesh[] baseMeshes;
    private final class_1087[] connectorModels;
    private final class_1087[] straightLineModels;
    private final AttachmentsBakedModel attachments;
    private final boolean transparent;
    private static final PipeModelData ITEM_DATA = new PipeModelData(12, 12, new AttachedAttachment[6]);

    public PipeBakedModel(class_1058 baseSprite, class_1087[] connectorModels, class_1087[] straightLineModels, AttachmentsBakedModel attachments, boolean transparent) {
        this.baseSprite = baseSprite;
        this.connectorModels = connectorModels;
        this.straightLineModels = straightLineModels;
        this.attachments = attachments;
        this.transparent = transparent;
        this.baseMeshes = new Mesh[64];
        MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        for (int connections = 0; connections < this.baseMeshes.length; ++connections) {
            QuadEmitter qe = meshBuilder.getEmitter();
            for (int i = 0; i < 6; ++i) {
                class_2350 dir = class_2350.method_10143((int)i);
                if ((connections & 1 << i) == 0) {
                    this.baseQuad(qe, dir, 0.3125f, 0.3125f, 0.6875f, 0.6875f, 0.3125f);
                }
                if ((connections & 1 << GeometryHelper.FACE_RIGHT[i].method_10153().method_10146()) > 0) {
                    this.baseQuad(qe, dir, 0.0f, 0.3125f, 0.3125f, 0.6875f, 0.3125f);
                }
                if ((connections & 1 << GeometryHelper.FACE_RIGHT[i].method_10146()) > 0) {
                    this.baseQuad(qe, dir, 0.6875f, 0.3125f, 1.0f, 0.6875f, 0.3125f);
                }
                if ((connections & 1 << GeometryHelper.FACE_UP[i].method_10153().method_10146()) > 0) {
                    this.baseQuad(qe, dir, 0.3125f, 0.0f, 0.6875f, 0.3125f, 0.3125f);
                }
                if ((connections & 1 << GeometryHelper.FACE_UP[i].method_10146()) <= 0) continue;
                this.baseQuad(qe, dir, 0.3125f, 0.6875f, 0.6875f, 1.0f, 0.3125f);
            }
            this.baseMeshes[connections] = meshBuilder.build();
        }
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
        return List.of();
    }

    public boolean method_4708() {
        return false;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.baseSprite;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public class_809 method_4709() {
        return ModelHelper.MODEL_TRANSFORM_BLOCK;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    private void appendBitmasked(Consumer<class_1087> consumer, int mask, class_1087[] models) {
        for (int i = 0; i < 6; ++i) {
            if ((mask & 1 << i) <= 0) continue;
            consumer.accept(models[i]);
        }
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        RenderAttachedBlockView attachmentView = (RenderAttachedBlockView)blockView;
        PipeModelData pipeData = Objects.requireNonNullElse((PipeModelData)attachmentView.getBlockEntityRenderAttachment(pos), PipeModelData.DEFAULT);
        this.drawPipe(pipeData, context);
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.drawPipe(ITEM_DATA, context);
    }

    private void baseQuad(QuadEmitter qe, class_2350 side, float left, float bottom, float right, float top, float depth) {
        qe.square(side, left, bottom, right, top, depth);
        qe.spriteBake(0, this.baseSprite, 4);
        qe.spriteColor(0, -1, -1, -1, -1);
        qe.emit();
        if (this.transparent) {
            switch (side) {
                case field_11036: 
                case field_11033: {
                    qe.square(side.method_10153(), left, 1.0f - top, right, 1.0f - bottom, 1.0f - depth);
                    break;
                }
                default: {
                    qe.square(side.method_10153(), 1.0f - right, bottom, 1.0f - left, top, 1.0f - depth);
                }
            }
            qe.spriteBake(0, this.baseSprite, 4);
            qe.spriteColor(0, -1, -1, -1, -1);
            qe.emit();
        }
    }

    private void drawPipe(PipeModelData data, RenderContext context) {
        AttachmentModelData attachment;
        int i;
        byte connectionsPipe = data.pipeConnections();
        byte connectionsInventory = data.inventoryConnections();
        int connections = connectionsInventory | connectionsPipe;
        for (i = 0; i < 6; ++i) {
            attachment = data.attachments()[i];
            if (attachment == null) continue;
            connections |= 1 << i;
        }
        if (connections == 3 || connections == 12 || connections == 48) {
            if (connections == 3) {
                context.fallbackConsumer().accept(this.straightLineModels[0]);
            } else if (connections == 12) {
                context.fallbackConsumer().accept(this.straightLineModels[2]);
            } else {
                context.fallbackConsumer().accept(this.straightLineModels[4]);
            }
        } else {
            context.meshConsumer().accept(this.baseMeshes[connections]);
        }
        this.appendBitmasked(context.fallbackConsumer(), connectionsInventory, this.connectorModels);
        for (i = 0; i < 6; ++i) {
            attachment = data.attachments()[i];
            if (attachment == null) continue;
            context.fallbackConsumer().accept(this.attachments.attachmentModels.get(attachment.modelId())[i]);
        }
    }
}

