/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.technici4n.moderndynamics.attachment.RenderedAttachment;
import dev.technici4n.moderndynamics.init.MdBlocks;
import dev.technici4n.moderndynamics.pipe.PipeBlock;
import dev.technici4n.moderndynamics.util.MdId;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2405;
import net.minecraft.class_7403;

public class PipeModelsProvider
implements class_2405 {
    private final FabricDataGenerator gen;

    public PipeModelsProvider(FabricDataGenerator gen) {
        this.gen = gen;
    }

    public void method_10319(class_7403 cache) throws IOException {
        this.registerPipeModels(cache);
        this.registerAttachments(cache);
    }

    private void registerPipeModels(class_7403 cache) throws IOException {
        for (PipeBlock pipe : MdBlocks.ALL_PIPES) {
            this.registerPipeModel(cache, pipe);
        }
    }

    private void registerPipeModel(class_7403 cache, PipeBlock pipe) throws IOException {
        Path baseFolder = this.gen.method_10313().resolve("assets/%s/models/pipe/%s".formatted(this.gen.getModId(), pipe.id));
        this.registerPipePart(cache, baseFolder, pipe, "connector");
        this.registerPipePart(cache, baseFolder, pipe, "straight");
    }

    private void registerPipePart(class_7403 cache, Path baseFolder, PipeBlock pipe, String kind) throws IOException {
        JsonObject obj = new JsonObject();
        obj.addProperty("parent", MdId.of("base/%s%s".formatted(kind, pipe.isTransparent() ? "_transparent" : "")).toString());
        JsonObject textures = new JsonObject();
        obj.add("textures", (JsonElement)textures);
        textures.addProperty("0", MdId.of("pipe/%s/%s".formatted(pipe.id, kind)).toString());
        class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)baseFolder.resolve(kind + ".json"));
    }

    private void registerAttachments(class_7403 cache) throws IOException {
        for (RenderedAttachment attachment : RenderedAttachment.getAllAttachments()) {
            this.registerAttachment(cache, attachment, "attachment/" + attachment.id.toLowerCase(Locale.ROOT));
        }
    }

    private void registerAttachment(class_7403 cache, RenderedAttachment attachment, String texture) throws IOException {
        JsonObject obj = new JsonObject();
        obj.addProperty("parent", MdId.of("base/connector_transparent").toString());
        JsonObject textures = new JsonObject();
        obj.add("textures", (JsonElement)textures);
        textures.addProperty("0", MdId.of(texture).toString());
        class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)this.gen.method_10313().resolve("assets/%s/models/attachment/%s.json".formatted(this.gen.getModId(), attachment.id)));
    }

    public String method_10321() {
        return "Pipe Models";
    }
}

