/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.energy;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.network.NetworkManager;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.energy.EnergyCache;
import dev.technici4n.moderndynamics.network.energy.EnergyPipeTier;
import dev.technici4n.moderndynamics.network.shared.TransferLimits;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.DelegatingEnergyStorage;

public class EnergyHost
extends NodeHost {
    private static final NetworkManager<EnergyHost, EnergyCache> MANAGER = NetworkManager.get(EnergyCache.class, EnergyCache::new);
    private final EnergyPipeTier tier;
    private long energy;
    private final TransferLimits insertLimit = new TransferLimits(this::getTransferLimit, 0L);
    private final TransferLimits extractLimit = new TransferLimits(this::getTransferLimit, 0L);
    private final EnergyStorage[] caps = new EnergyStorage[6];

    public EnergyHost(PipeBlockEntity pipe, EnergyPipeTier tier) {
        super(pipe);
        this.tier = tier;
        for (int i = 0; i < 6; ++i) {
            this.caps[i] = new NetworkEnergyStorage(i);
        }
    }

    @Override
    public NetworkManager<EnergyHost, EnergyCache> getManager() {
        return MANAGER;
    }

    @Override
    public Object getApiInstance(BlockApiLookup<?, class_2350> lookup, class_2350 side) {
        if (lookup == EnergyStorage.SIDED && (this.pipe.connectionBlacklist & 1 << side.method_10146()) == 0) {
            return this.caps[side.method_10146()];
        }
        return null;
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getMaxEnergy() {
        return this.tier.getCapacity();
    }

    public void setEnergy(long energy) {
        if (energy < 0L || energy > this.getMaxEnergy()) {
            throw new IllegalArgumentException("Invalid energy value " + energy);
        }
        this.energy = energy;
        this.pipe.method_5431();
    }

    @Override
    protected void doUpdate() {
        this.updateConnections();
    }

    @Override
    public boolean acceptsAttachment(AttachmentItem attachment, class_1799 stack) {
        return false;
    }

    @Override
    public boolean canConnectTo(class_2350 connectionDirection, NodeHost adjacentHost) {
        return super.canConnectTo(connectionDirection, adjacentHost) && ((EnergyHost)adjacentHost).tier == this.tier;
    }

    protected void addEnergyStorages(List<EnergyStorage> out) {
        this.gatherCapabilities(out);
    }

    public void gatherCapabilities(@Nullable List<EnergyStorage> out) {
        int oldConnections = this.inventoryConnections;
        for (int i = 0; i < 6; ++i) {
            if ((this.inventoryConnections & 1 << i) <= 0 || (this.pipeConnections & 1 << i) != 0) continue;
            class_2350 dir = class_2350.method_10143((int)i);
            EnergyStorage adjacentCap = (EnergyStorage)EnergyStorage.SIDED.find(this.pipe.method_10997(), this.pipe.method_11016().method_10093(dir), (Object)dir.method_10153());
            if (adjacentCap != null) {
                if (out == null) continue;
                out.add((EnergyStorage)new ExternalEnergyStorage(adjacentCap, i));
                continue;
            }
            this.inventoryConnections ^= 1 << i;
        }
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    public void updateConnections() {
        int oldConnections = this.inventoryConnections;
        this.inventoryConnections = 63 - (this.pipeConnections | this.pipe.connectionBlacklist);
        this.gatherCapabilities(null);
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    @Override
    public void writeNbt(class_2487 tag) {
        super.writeNbt(tag);
        tag.method_10544("energy", this.energy);
    }

    @Override
    public void readNbt(class_2487 tag) {
        super.readNbt(tag);
        this.energy = Math.max(0L, Math.min(tag.method_10537("energy"), this.getMaxEnergy()));
    }

    private long getTransferLimit(class_2350 side) {
        return this.tier.getMaxConnectionTransfer();
    }

    private class NetworkEnergyStorage
    implements EnergyStorage {
        private final int directionId;

        private NetworkEnergyStorage(int directionId) {
            this.directionId = directionId;
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            @Nullable NetworkNode node = EnergyHost.this.findNode();
            if (node != null && node.getHost() == EnergyHost.this) {
                if ((maxAmount = EnergyHost.this.extractLimit.limit(this.directionId, maxAmount)) <= 0L) {
                    return 0L;
                }
                long transferred = ((EnergyCache)node.getNetworkCache()).insert(maxAmount, transaction);
                EnergyHost.this.extractLimit.use(this.directionId, transferred, transaction);
                return transferred;
            }
            return 0L;
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            @Nullable NetworkNode node = EnergyHost.this.findNode();
            if (node != null && node.getHost() == EnergyHost.this) {
                if ((maxAmount = EnergyHost.this.insertLimit.limit(this.directionId, maxAmount)) <= 0L) {
                    return 0L;
                }
                long transferred = ((EnergyCache)node.getNetworkCache()).extract(maxAmount, transaction);
                EnergyHost.this.insertLimit.use(this.directionId, transferred, transaction);
                return transferred;
            }
            return 0L;
        }

        public long getAmount() {
            @Nullable NetworkNode node = EnergyHost.this.findNode();
            if (node != null && node.getHost() == EnergyHost.this) {
                return ((EnergyCache)node.getNetworkCache()).getAmount();
            }
            return 0L;
        }

        public long getCapacity() {
            @Nullable NetworkNode node = EnergyHost.this.findNode();
            if (node != null && node.getHost() == EnergyHost.this) {
                return ((EnergyCache)node.getNetworkCache()).getCapacity();
            }
            return 0L;
        }
    }

    private class ExternalEnergyStorage
    extends DelegatingEnergyStorage {
        private final int directionId;

        private ExternalEnergyStorage(EnergyStorage delegate, int directionId) {
            super(delegate, null);
            this.directionId = directionId;
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            if ((maxAmount = EnergyHost.this.insertLimit.limit(this.directionId, maxAmount)) <= 0L) {
                return 0L;
            }
            long transferred = ((EnergyStorage)this.backingStorage.get()).insert(maxAmount, transaction);
            EnergyHost.this.insertLimit.use(this.directionId, transferred, transaction);
            return transferred;
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            if ((maxAmount = EnergyHost.this.extractLimit.limit(this.directionId, maxAmount)) <= 0L) {
                return 0L;
            }
            long transferred = ((EnergyStorage)this.backingStorage.get()).extract(maxAmount, transaction);
            EnergyHost.this.extractLimit.use(this.directionId, transferred, transaction);
            return transferred;
        }
    }
}

