/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentType;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.ItemAttachedIo;
import dev.technici4n.moderndynamics.attachment.settings.RoutingMode;
import dev.technici4n.moderndynamics.network.NetworkManager;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.TickHelper;
import dev.technici4n.moderndynamics.network.item.FailedInsertStrategy;
import dev.technici4n.moderndynamics.network.item.ItemCache;
import dev.technici4n.moderndynamics.network.item.ItemPath;
import dev.technici4n.moderndynamics.network.item.ItemPathCache;
import dev.technici4n.moderndynamics.network.item.MaxParticipant;
import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTarget;
import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTargets;
import dev.technici4n.moderndynamics.network.item.TravelingItem;
import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItem;
import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItemSmoothing;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.DropHelper;
import dev.technici4n.moderndynamics.util.SerializationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class ItemHost
extends NodeHost {
    public static final NetworkManager<ItemHost, ItemCache> MANAGER = NetworkManager.get(ItemCache.class, ItemCache::new);
    private final List<TravelingItem> travelingItems = new ArrayList<TravelingItem>();
    private final List<ClientTravelingItem> clientTravelingItems = new ArrayList<ClientTravelingItem>();
    private final long[] lastOperationTick = new long[6];

    public ItemHost(PipeBlockEntity pipe) {
        super(pipe);
    }

    @Override
    public boolean acceptsAttachment(AttachmentItem attachment, class_1799 stack) {
        return true;
    }

    @Override
    public NetworkManager<ItemHost, ItemCache> getManager() {
        return MANAGER;
    }

    @Override
    public boolean canConnectTo(class_2350 connectionDirection, NodeHost adjacentHost) {
        AttachedAttachment attachment = this.getAttachment(connectionDirection);
        if (attachment instanceof ItemAttachedIo) {
            return false;
        }
        return super.canConnectTo(connectionDirection, adjacentHost);
    }

    @Override
    @Nullable
    public Object getApiInstance(BlockApiLookup<?, class_2350> lookup, class_2350 side) {
        if (lookup == ItemStorage.SIDED && this.allowItemConnection(side)) {
            return this.buildExternalNetworkInjectStorage(side);
        }
        return null;
    }

    private boolean allowItemConnection(class_2350 side) {
        AttachedAttachment attachment = this.getAttachment(side);
        return attachment == null || attachment.allowsItemConnection();
    }

    private InsertionOnlyStorage<ItemVariant> buildExternalNetworkInjectStorage(class_2350 side) {
        double d;
        AttachedAttachment attachedAttachment = this.getAttachment(side);
        if (attachedAttachment instanceof ItemAttachedIo) {
            ItemAttachedIo io = (ItemAttachedIo)attachedAttachment;
            d = io.getItemSpeedupFactor();
        } else {
            d = 1.0;
        }
        double speedupFactor = d;
        return (resource, maxAmount, transaction) -> {
            NetworkNode<ItemHost, ItemCache> node = this.findNode();
            if (node != null) {
                ItemCache cache = (ItemCache)node.getNetworkCache();
                List<ItemPath> paths = cache.pathCache.getPaths(node, side.method_10153());
                return cache.insertList(node, (Iterable<ItemPath>)paths, (ItemVariant)resource, maxAmount, transaction, speedupFactor, null);
            }
            return 0L;
        };
    }

    private InsertionOnlyStorage<ItemVariant> buildExtractorNetworkInjectStorage(class_2350 side, ItemAttachedIo extractor, @Nullable MaxParticipant maxIndexParticipant) {
        double speedupFactor = extractor.getItemSpeedupFactor();
        NetworkNode<ItemHost, ItemCache> node = this.findNode();
        ItemCache cache = (ItemCache)node.getNetworkCache();
        Iterable<ItemPath> paths = this.rearrangePaths(cache.pathCache.getPaths(node, side.method_10153()), extractor);
        return (resource, maxAmount, transaction) -> cache.insertList(node, paths, (ItemVariant)resource, maxAmount, transaction, speedupFactor, maxIndexParticipant);
    }

    protected EnumSet<class_2350> getInventoryConnections() {
        return SerializationHelper.directionsFromMask((byte)this.inventoryConnections);
    }

    @Nullable
    protected Storage<ItemVariant> getAdjacentStorage(class_2350 side, boolean checkAttachments) {
        if ((this.inventoryConnections & 1 << side.method_10146()) > 0 && (this.pipeConnections & 1 << side.method_10146()) == 0 && (!checkAttachments || this.allowItemConnection(side))) {
            return (Storage)ItemStorage.SIDED.find(this.pipe.method_10997(), this.pipe.method_11016().method_10093(side), (Object)side.method_10153());
        }
        return null;
    }

    private Iterable<ItemPath> rearrangePaths(List<ItemPath> path, ItemAttachedIo io) {
        if (path.size() <= 1) {
            return path;
        }
        return switch (io.getRoutingMode()) {
            default -> throw new IncompatibleClassChangeError();
            case RoutingMode.CLOSEST -> path;
            case RoutingMode.FURTHEST -> Lists.reverse(path);
            case RoutingMode.RANDOM -> {
                ArrayList pathCopy = new ArrayList(path);
                Collections.shuffle(pathCopy);
                yield pathCopy;
            }
            case RoutingMode.ROUND_ROBIN -> {
                int startIndex = io.getRoundRobinIndex(path.size());
                yield Iterables.concat(path.subList(startIndex, path.size()), path.subList(0, startIndex));
            }
        };
    }

    public void tickAttachments() {
        long currentTick = TickHelper.getTickCounter();
        for (class_2350 side : class_2350.values()) {
            ItemAttachedIo itemAttachedIo;
            AttachedAttachment attachment = this.getAttachment(side);
            if (!(attachment instanceof ItemAttachedIo) || !(itemAttachedIo = (ItemAttachedIo)attachment).isEnabledViaRedstone(this.pipe) || currentTick - this.lastOperationTick[side.method_10146()] < (long)itemAttachedIo.getItemOperationTickDelay()) continue;
            this.lastOperationTick[side.method_10146()] = currentTick;
            if (itemAttachedIo.getType() == IoAttachmentType.EXTRACTOR) {
                this.tickExtractor(side, itemAttachedIo);
                continue;
            }
            if (itemAttachedIo.getType() != IoAttachmentType.ATTRACTOR) continue;
            this.tickAttractor(side, itemAttachedIo);
        }
    }

    private void tickExtractor(class_2350 side, ItemAttachedIo extractor) {
        if (extractor.isStuffed()) {
            MaxParticipant maxParticipant = new MaxParticipant();
            if (extractor.moveStuffedToStorage((Storage<ItemVariant>)this.buildExtractorNetworkInjectStorage(side, extractor, maxParticipant), extractor.getMaxItemsExtracted()) > 0L) {
                extractor.incrementRoundRobin(maxParticipant.getMax());
                this.pipe.method_5431();
                if (!extractor.isStuffed()) {
                    this.pipe.sync();
                }
            }
        } else {
            Storage<ItemVariant> adjStorage = this.getAdjacentStorage(side, false);
            if (adjStorage == null) {
                return;
            }
            MaxParticipant maxParticipant = new MaxParticipant();
            if (StorageUtil.move(adjStorage, this.buildExtractorNetworkInjectStorage(side, extractor, maxParticipant), extractor::matchesItemFilter, (long)extractor.getMaxItemsExtracted(), null) > 0L) {
                extractor.incrementRoundRobin(maxParticipant.getMax());
            }
        }
    }

    public void tickAttractor(class_2350 side, ItemAttachedIo attractor) {
        if (attractor.isStuffed()) {
            Storage<ItemVariant> adjStorage = this.getAdjacentStorage(side, false);
            if (adjStorage == null) {
                return;
            }
            if (attractor.moveStuffedToStorage(adjStorage, attractor.getMaxItemsExtracted()) > 0L) {
                this.pipe.method_5431();
                if (!attractor.isStuffed()) {
                    this.pipe.sync();
                }
            }
        } else {
            long maxTransfer;
            SimulatedInsertionTarget insertTarget = SimulatedInsertionTargets.getTarget(this.pipe.method_10997(), this.pipe.method_11016().method_10093(side), side.method_10153());
            if (!insertTarget.hasStorage()) {
                return;
            }
            NetworkNode<ItemHost, ItemCache> thisNode = this.findNode();
            ItemCache cache = (ItemCache)thisNode.getNetworkCache();
            ItemPathCache pathCache = cache.pathCache;
            Iterable<ItemPath> paths = this.rearrangePaths(pathCache.getPaths(thisNode, side.method_10153()), attractor);
            long toTransfer = maxTransfer = (long)attractor.getMaxItemsExtracted();
            int nextPathIndex = 0;
            for (ItemPath path : paths) {
                Predicate<ItemVariant> endpointFilter;
                InsertionOnlyStorage insertStorage;
                Storage extractTarget;
                ItemAttachedIo io;
                ++nextPathIndex;
                AttachedAttachment attachedAttachment = path.getEndAttachment(cache.level);
                if (attachedAttachment instanceof ItemAttachedIo && (io = (ItemAttachedIo)attachedAttachment).getType() == IoAttachmentType.ATTRACTOR || (extractTarget = (Storage)ItemStorage.SIDED.find(this.pipe.method_10997(), path.targetPos, (Object)path.getTargetBlockSide())) == null || (toTransfer -= StorageUtil.move((Storage)extractTarget, (Storage)(insertStorage = (variant, maxAmount, tx) -> insertTarget.insert((ItemVariant)variant, maxAmount, tx, (v, a) -> {
                    ItemPath reversedPath = path.reversed();
                    TravelingItem travelingItem = reversedPath.makeTravelingItem(v, a, attractor.getItemSpeedupFactor());
                    reversedPath.getStartingPoint(cache.level).getHost().addTravelingItem(travelingItem);
                })), arg_0 -> ItemHost.lambda$tickAttractor$4(attractor, endpointFilter = path.getEndFilter(cache.level), arg_0), (long)toTransfer, null)) != 0L) continue;
                break;
            }
            if (toTransfer < maxTransfer) {
                attractor.incrementRoundRobin(nextPathIndex);
            }
        }
    }

    public void tickMovingItems() {
        TravelingItem travelingItem;
        if (this.travelingItems.size() == 0) {
            return;
        }
        ArrayList<TravelingItem> movedOut = new ArrayList<TravelingItem>();
        Iterator<TravelingItem> iterator = this.travelingItems.iterator();
        while (iterator.hasNext()) {
            travelingItem = iterator.next();
            int currentIndex = (int)travelingItem.traveledDistance;
            travelingItem.traveledDistance += travelingItem.getSpeed();
            int newIndex = (int)travelingItem.traveledDistance;
            if (newIndex == currentIndex) continue;
            movedOut.add(travelingItem);
            iterator.remove();
        }
        Iterator iterator2 = movedOut.iterator();
        while (iterator2.hasNext()) {
            int newIndex = (int)travelingItem.traveledDistance;
            travelingItem = (TravelingItem)iterator2.next();
            if (newIndex >= travelingItem.getPathLength() - 1) {
                ItemAttachedIo io;
                AttachedAttachment attachedAttachment;
                class_2350 side = travelingItem.path.path[newIndex];
                boolean checkAttachments = travelingItem.strategy != FailedInsertStrategy.DROP;
                Storage storage = this.getAdjacentStorage(side, checkAttachments);
                if (storage == null) {
                    storage = Storage.empty();
                }
                long inserted = 0L;
                if (!checkAttachments || !((attachedAttachment = this.getAttachment(side)) instanceof ItemAttachedIo) || (io = (ItemAttachedIo)attachedAttachment).matchesItemFilter(travelingItem.variant) && io.isEnabledViaRedstone(this.pipe)) {
                    try (Transaction transaction = Transaction.openOuter();){
                        inserted = storage.insert((Object)travelingItem.variant, travelingItem.amount, (TransactionContext)transaction);
                        transaction.commit();
                    }
                }
                this.finishTravel(travelingItem, inserted);
                continue;
            }
            class_2350 adjPipeDirection = travelingItem.path.path[newIndex];
            ItemHost adjacentItemHost = null;
            NetworkNode ownNode = this.findNode();
            for (NetworkNode.Connection connection : ownNode.getConnections()) {
                if (connection.direction() != adjPipeDirection) continue;
                adjacentItemHost = (ItemHost)connection.target().getHost();
            }
            if (adjacentItemHost != null) {
                adjacentItemHost.travelingItems.add(travelingItem);
                adjacentItemHost.pipe.method_5431();
                adjacentItemHost.pipe.sync(false);
                continue;
            }
            this.finishTravel(travelingItem, 0L);
        }
        this.pipe.method_5431();
        this.pipe.sync(false);
    }

    private void finishTravel(TravelingItem item, long inserted) {
        ItemAttachedIo io;
        item.path.getInsertionTarget(this.pipe.method_10997()).stopAwaiting(item.variant, item.amount);
        long leftover = item.amount - inserted;
        AttachedAttachment attachment = this.getAttachment(item.path.path[item.getPathLength() - 1]);
        if (leftover > 0L && attachment instanceof ItemAttachedIo && (io = (ItemAttachedIo)attachment).getType() != IoAttachmentType.FILTER) {
            boolean wasStuffed = io.isStuffed();
            io.getStuffedItems().merge(item.variant, item.amount, Long::sum);
            this.pipe.method_5431();
            if (wasStuffed != io.isStuffed()) {
                this.pipe.sync();
            }
        } else if (leftover > 0L) {
            if (item.strategy == FailedInsertStrategy.SEND_BACK_TO_SOURCE) {
                this.addTravelingItem(new TravelingItem(item.variant, leftover, item.path.reversed(), FailedInsertStrategy.DROP, item.speedMultiplier, (double)(item.getPathLength() - 1) - Math.floor(item.traveledDistance)));
            } else {
                DropHelper.dropStack(this.pipe, item.variant, item.amount - inserted);
            }
        }
    }

    @Override
    public void writeNbt(class_2487 tag) {
        super.writeNbt(tag);
        if (this.travelingItems.size() > 0) {
            class_2499 list = new class_2499();
            for (TravelingItem travelingItem : this.travelingItems) {
                list.add((Object)travelingItem.toNbt());
            }
            tag.method_10566("travelingItems", (class_2520)list);
        }
    }

    @Override
    public void readNbt(class_2487 tag) {
        super.readNbt(tag);
        class_2499 list = tag.method_10554("travelingItems", 10);
        for (int i = 0; i < list.size(); ++i) {
            TravelingItem item = TravelingItem.fromNbt(list.method_10602(i));
            if (item.variant.isBlank()) continue;
            this.travelingItems.add(item);
        }
    }

    @Override
    public void addSelf() {
        super.addSelf();
        for (TravelingItem travelingItem : this.travelingItems) {
            travelingItem.path.getInsertionTarget(this.pipe.method_10997()).startAwaiting(travelingItem.variant, travelingItem.amount);
        }
    }

    @Override
    public void removeSelf() {
        super.removeSelf();
        for (TravelingItem travelingItem : this.travelingItems) {
            travelingItem.path.getInsertionTarget(this.pipe.method_10997()).stopAwaiting(travelingItem.variant, travelingItem.amount);
        }
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        for (TravelingItem travelingItem : this.travelingItems) {
            travelingItem.path.getInsertionTarget(this.pipe.method_10997()).stopAwaiting(travelingItem.variant, travelingItem.amount);
            DropHelper.dropStack(this.pipe, travelingItem.variant, travelingItem.amount);
        }
        this.travelingItems.clear();
    }

    public void addTravelingItem(TravelingItem travelingItem) {
        this.travelingItems.add(travelingItem);
        this.pipe.method_5431();
    }

    @Override
    protected void doUpdate() {
        this.updateConnections();
    }

    public void gatherCapabilities() {
        int oldConnections = this.inventoryConnections;
        for (int i = 0; i < 6; ++i) {
            if ((this.inventoryConnections & 1 << i) <= 0 || (this.pipeConnections & 1 << i) != 0) continue;
            class_2350 dir = class_2350.method_10143((int)i);
            Storage adjacentCap = (Storage)ItemStorage.SIDED.find(this.pipe.method_10997(), this.pipe.method_11016().method_10093(dir), (Object)dir.method_10153());
            if (adjacentCap != null) continue;
            this.inventoryConnections ^= 1 << i;
        }
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
            NetworkNode node = this.findNode();
            ((ItemCache)node.getNetworkCache()).pathCache.invalidate();
        }
    }

    public void updateConnections() {
        int oldConnections = this.inventoryConnections;
        this.inventoryConnections = 63 - (this.pipeConnections | this.pipe.connectionBlacklist);
        this.gatherCapabilities();
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    @Override
    public void writeClientNbt(class_2487 tag) {
        super.writeClientNbt(tag);
        if (this.travelingItems.size() > 0) {
            class_2499 list = new class_2499();
            for (TravelingItem travelingItem : this.travelingItems) {
                class_2487 compound = new class_2487();
                compound.method_10569("id", travelingItem.id);
                compound.method_10566("v", (class_2520)travelingItem.variant.toNbt());
                compound.method_10544("a", travelingItem.amount);
                compound.method_10549("td", (double)(travelingItem.getPathLength() - 1));
                compound.method_10549("d", travelingItem.traveledDistance);
                int currentBlock = (int)Math.floor(travelingItem.traveledDistance);
                compound.method_10567("in", (byte)travelingItem.path.path[currentBlock].method_10146());
                compound.method_10567("out", (byte)travelingItem.path.path[currentBlock + 1].method_10146());
                compound.method_10549("s", travelingItem.getSpeed());
                list.add((Object)compound);
            }
            tag.method_10566("travelingItems", (class_2520)list);
        }
    }

    @Override
    public void readClientNbt(class_2487 tag) {
        super.readClientNbt(tag);
        this.clientTravelingItems.clear();
        class_2499 list = tag.method_10554("travelingItems", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 compound = list.method_10602(i);
            ClientTravelingItem newItem = new ClientTravelingItem(compound.method_10550("id"), ItemVariant.fromNbt((class_2487)compound.method_10562("v")), compound.method_10537("a"), compound.method_10574("td"), compound.method_10574("d"), class_2350.method_10143((int)compound.method_10571("in")), class_2350.method_10143((int)compound.method_10571("out")), compound.method_10574("s"));
            this.clientTravelingItems.add(newItem);
            ClientTravelingItemSmoothing.onReceiveItem(newItem);
        }
    }

    @Override
    public void clientTick() {
        Iterator<ClientTravelingItem> it = this.clientTravelingItems.iterator();
        while (it.hasNext()) {
            NodeHost[] nodeHostArray;
            ClientTravelingItem travelingItem = it.next();
            travelingItem.traveledDistance += travelingItem.speed();
            if (!(class_3532.method_15385((double)travelingItem.traveledDistance) < travelingItem.speed())) continue;
            it.remove();
            if (!(travelingItem.traveledDistance < travelingItem.totalPathDistance) || !((nodeHostArray = this.getLevel().method_8321(this.getPos().method_10093(travelingItem.out))) instanceof PipeBlockEntity)) continue;
            PipeBlockEntity otherPipe = (PipeBlockEntity)nodeHostArray;
            nodeHostArray = otherPipe.getHosts();
            int n = nodeHostArray.length;
            for (int i = 0; i < n; ++i) {
                NodeHost host = nodeHostArray[i];
                if (!(host instanceof ItemHost)) continue;
                ItemHost otherItemHost = (ItemHost)host;
                otherItemHost.clientTravelingItems.add(travelingItem);
                travelingItem.in = travelingItem.out;
            }
        }
    }

    public List<ClientTravelingItem> getClientTravelingItems() {
        return this.clientTravelingItems;
    }

    private static /* synthetic */ boolean lambda$tickAttractor$4(ItemAttachedIo attractor, Predicate endpointFilter, ItemVariant v) {
        return attractor.matchesItemFilter(v) && endpointFilter.test(v);
    }
}

