/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.pipe;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_259;
import net.minecraft.class_265;

public class PipeBoundingBoxes {
    public static final float CORE_SIZE = 0.375f;
    public static final float CORE_START = 0.3125f;
    public static final float CORE_END = 0.6875f;
    public static final class_265 CORE_SHAPE = class_259.method_1081((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    public static final class_265[] PIPE_CONNECTIONS = PipeBoundingBoxes.buildSideShapes(0.375, 0.3125);
    public static final class_265[] CONNECTOR_SHAPES = PipeBoundingBoxes.buildSideShapes(0.5, 0.25);
    public static final class_265[] INVENTORY_CONNECTIONS = PipeBoundingBoxes.combinePiecewise(PIPE_CONNECTIONS, CONNECTOR_SHAPES);
    private static final ConcurrentHashMap<Integer, class_265> pipeShapeCache = new ConcurrentHashMap();

    public static class_265[] buildSideShapes(double connectorSide, double connectorDepth) {
        double connectorSideStart = (1.0 - connectorSide) / 2.0;
        double connectorSideEnd = connectorSideStart + connectorSide;
        return new class_265[]{class_259.method_1081((double)connectorSideStart, (double)0.0, (double)connectorSideStart, (double)connectorSideEnd, (double)connectorDepth, (double)connectorSideEnd), class_259.method_1081((double)connectorSideStart, (double)(1.0 - connectorDepth), (double)connectorSideStart, (double)connectorSideEnd, (double)1.0, (double)connectorSideEnd), class_259.method_1081((double)connectorSideStart, (double)connectorSideStart, (double)0.0, (double)connectorSideEnd, (double)connectorSideEnd, (double)connectorDepth), class_259.method_1081((double)connectorSideStart, (double)connectorSideStart, (double)(1.0 - connectorDepth), (double)connectorSideEnd, (double)connectorSideEnd, (double)1.0), class_259.method_1081((double)0.0, (double)connectorSideStart, (double)connectorSideStart, (double)connectorDepth, (double)connectorSideEnd, (double)connectorSideEnd), class_259.method_1081((double)(1.0 - connectorDepth), (double)connectorSideStart, (double)connectorSideStart, (double)1.0, (double)connectorSideEnd, (double)connectorSideEnd)};
    }

    public static class_265[] buildCombinedShapes(class_265[] sideShapes) {
        class_265[] combinedShapes = new class_265[64];
        for (int mask = 0; mask < 64; ++mask) {
            class_265 currentShape = CORE_SHAPE;
            for (int i = 0; i < 6; ++i) {
                if ((mask & 1 << i) <= 0) continue;
                currentShape = class_259.method_1084((class_265)currentShape, (class_265)sideShapes[i]);
            }
            combinedShapes[mask] = currentShape.method_1097();
        }
        return combinedShapes;
    }

    public static class_265[] combinePiecewise(class_265[] part1, class_265[] part2) {
        class_265[] combinedShapes = new class_265[6];
        for (int i = 0; i < 6; ++i) {
            combinedShapes[i] = class_259.method_1084((class_265)part1[i], (class_265)part2[i]).method_1097();
        }
        return combinedShapes;
    }

    public static class_265 getPipeShape(int pipeConnections, int inventoryConnections, int attachments) {
        int cacheKey = pipeConnections | (inventoryConnections |= attachments) << 6;
        class_265 cachedShape = pipeShapeCache.get(cacheKey);
        if (cachedShape != null) {
            return cachedShape;
        }
        int allConnections = pipeConnections | inventoryConnections;
        class_265 shape = CORE_SHAPE;
        for (int i = 0; i < 6; ++i) {
            if ((allConnections & 1 << i) > 0) {
                shape = class_259.method_1084((class_265)shape, (class_265)PIPE_CONNECTIONS[i]);
            }
            if ((inventoryConnections & 1 << i) <= 0) continue;
            shape = class_259.method_1084((class_265)shape, (class_265)CONNECTOR_SHAPES[i]);
        }
        pipeShapeCache.put(cacheKey, shape);
        return shape;
    }
}

