/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.model;

import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasingModel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MachineBakedModel
implements class_1087,
FabricBakedModel {
    private static final class_2350[] DIRECTIONS = class_2350.values();
    private final class_809 blockTransformation;
    public final RenderMaterial cutoutMaterial;
    private final MachineCasing baseCasing;
    private final class_1058[] defaultOverlays;
    private final Map<String, class_1058[]> tieredOverlays;

    MachineBakedModel(class_809 blockTransformation, RenderMaterial cutoutMaterial, MachineCasing baseCasing, class_1058[] defaultOverlays, Map<String, class_1058[]> tieredOverlays) {
        this.blockTransformation = blockTransformation;
        this.cutoutMaterial = cutoutMaterial;
        this.baseCasing = baseCasing;
        this.defaultOverlays = defaultOverlays;
        this.tieredOverlays = tieredOverlays;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockRenderView, class_2680 blockState, class_2338 blockPos, Supplier<class_5819> supplier, RenderContext renderContext) {
        RenderAttachedBlockView bv;
        Object attachment;
        if (blockRenderView instanceof RenderAttachedBlockView && (attachment = (bv = (RenderAttachedBlockView)blockRenderView).getBlockEntityRenderAttachment(blockPos)) instanceof MachineModelClientData) {
            MachineModelClientData clientData = (MachineModelClientData)attachment;
            MachineCasing casing = clientData.casing == null ? this.baseCasing : clientData.casing;
            class_1058[] sprites = this.renderBase(renderContext, casing, clientData.frontDirection);
            if (clientData.outputDirection != null) {
                this.emitSprite(renderContext.getEmitter(), clientData.outputDirection, sprites[24], 3.0E-4f);
                if (clientData.itemAutoExtract) {
                    this.emitSprite(renderContext.getEmitter(), clientData.outputDirection, sprites[25], 3.0E-4f);
                }
                if (clientData.fluidAutoExtract) {
                    this.emitSprite(renderContext.getEmitter(), clientData.outputDirection, sprites[26], 3.0E-4f);
                }
            }
        }
    }

    public void emitItemQuads(class_1799 itemStack, Supplier<class_5819> supplier, RenderContext renderContext) {
        this.renderBase(renderContext, this.baseCasing, class_2350.field_11043);
    }

    private class_1058[] renderBase(RenderContext renderContext, MachineCasing casing, class_2350 facingDirection) {
        renderContext.meshConsumer().accept(MachineCasingModel.get(casing).getMesh());
        class_1058[] sprites = this.getSprites(casing);
        QuadEmitter emitter = renderContext.getEmitter();
        for (class_2350 d : DIRECTIONS) {
            class_1058 sprite = MachineBakedModel.getSprite(sprites, d, facingDirection, false);
            if (sprite == null) continue;
            this.emitSprite(emitter, d, sprite, 1.0E-6f);
        }
        return sprites;
    }

    public class_1058[] getSprites(@Nullable MachineCasing casing) {
        if (casing == null) {
            return this.defaultOverlays;
        }
        return this.tieredOverlays.getOrDefault(casing.name, this.defaultOverlays);
    }

    @Nullable
    public static class_1058 getSprite(class_1058[] sprites, class_2350 side, class_2350 facingDirection, boolean isActive) {
        int spriteId;
        if (side.method_10166().method_10179()) {
            spriteId = (facingDirection.method_10161() - side.method_10161() + 4) % 4 * 2;
        } else {
            spriteId = (facingDirection.method_10161() + 4) * 2;
            if (side == class_2350.field_11033) {
                spriteId += 8;
            }
        }
        if (isActive) {
            ++spriteId;
        }
        return sprites[spriteId];
    }

    private void emitSprite(QuadEmitter emitter, class_2350 d, class_1058 sprite, float depth) {
        if (sprite != null) {
            emitter.material(this.cutoutMaterial);
            emitter.square(d, 0.0f, 0.0f, 1.0f, 1.0f, -depth);
            emitter.cullFace(d);
            emitter.spriteBake(0, sprite, 4);
            emitter.spriteColor(0, -1, -1, -1, -1);
            emitter.emit();
        }
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 face, class_5819 random) {
        return Collections.emptyList();
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return MachineCasingModel.get(this.baseCasing).getSideSprite();
    }

    public class_809 method_4709() {
        return this.blockTransformation;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }
}

