/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.compat.viewer.impl.jei.JeiSlotUtil;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
class ViewerCategoryJei<D>
implements IRecipeCategory<D> {
    private final IJeiHelpers helpers;
    public final ViewerCategory<D> wrapped;
    public final RecipeType<D> recipeType;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable itemSlot;
    private final IDrawable fluidSlot;

    public ViewerCategoryJei(IJeiHelpers helpers, final ViewerCategory<D> wrapped) {
        IDrawable iDrawable;
        this.helpers = helpers;
        this.wrapped = wrapped;
        this.recipeType = RecipeType.create((String)wrapped.id.method_12836(), (String)wrapped.id.method_12832(), wrapped.dataClass);
        this.background = helpers.getGuiHelper().createBlankDrawable(wrapped.width - 8, wrapped.height - 8);
        ViewerCategory.Icon icon = wrapped.icon;
        if (icon instanceof ViewerCategory.Icon.Stack) {
            ViewerCategory.Icon.Stack stack = (ViewerCategory.Icon.Stack)icon;
            iDrawable = helpers.getGuiHelper().createDrawableItemStack(stack.stack());
        } else {
            iDrawable = new IDrawable(){

                public int getWidth() {
                    return 18;
                }

                public int getHeight() {
                    return 18;
                }

                public void draw(class_4587 poseStack, int xOffset, int yOffset) {
                    ViewerCategory.Icon.Texture texture = (ViewerCategory.Icon.Texture)wrapped.icon;
                    RenderSystem.setShaderTexture((int)0, (class_2960)texture.loc());
                    class_332.method_25291((class_4587)poseStack, (int)(xOffset - 1), (int)(yOffset - 1), (int)0, (float)texture.u(), (float)texture.v(), (int)18, (int)18, (int)256, (int)256);
                }
            };
        }
        this.icon = iDrawable;
        this.itemSlot = helpers.getGuiHelper().getSlotDrawable();
        this.fluidSlot = helpers.getGuiHelper().createDrawable(MachineScreen.SLOT_ATLAS, 18, 0, 18, 18);
    }

    public RecipeType<D> getRecipeType() {
        return this.recipeType;
    }

    public class_2561 getTitle() {
        return this.wrapped.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(final IRecipeLayoutBuilder builder, D recipe, IFocusGroup focuses) {
        this.wrapped.buildLayout(recipe, new ViewerCategory.LayoutBuilder(){

            @Override
            public ViewerCategory.SlotBuilder inputSlot(int x, int y) {
                return this.slot(RecipeIngredientRole.INPUT, x, y);
            }

            @Override
            public ViewerCategory.SlotBuilder outputSlot(int x, int y) {
                return this.slot(RecipeIngredientRole.OUTPUT, x, y);
            }

            @Override
            public void invisibleOutput(class_1799 stack) {
                builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(stack);
            }

            private ViewerCategory.SlotBuilder slot(RecipeIngredientRole role, int x, int y) {
                final IRecipeSlotBuilder slotBuilder = builder.addSlot(role, x - 4, y - 4);
                slotBuilder.setBackground(ViewerCategoryJei.this.itemSlot, -1, -1);
                return new ViewerCategory.SlotBuilder(){

                    @Override
                    public ViewerCategory.SlotBuilder variant(TransferVariant<?> variant) {
                        if (variant instanceof ItemVariant) {
                            ItemVariant item = (ItemVariant)variant;
                            this.item(item.toStack());
                        } else if (variant instanceof FluidVariant) {
                            FluidVariant fluid = (FluidVariant)variant;
                            if (!fluid.isBlank()) {
                                slotBuilder.addFluidStack(fluid.getFluid(), 1L, fluid.copyNbt());
                            }
                            JeiSlotUtil.overrideFluidRenderer(slotBuilder);
                            slotBuilder.setBackground(ViewerCategoryJei.this.fluidSlot, -1, -1);
                        } else {
                            throw new IllegalArgumentException("Unknown variant type: " + variant.getClass());
                        }
                        return this;
                    }

                    @Override
                    public ViewerCategory.SlotBuilder fluid(FluidVariant fluid, long amount, float probability) {
                        slotBuilder.addFluidStack(fluid.getFluid(), amount, fluid.copyNbt());
                        JeiSlotUtil.overrideFluidRenderer(slotBuilder);
                        JeiSlotUtil.customizeTooltip(slotBuilder, probability);
                        slotBuilder.setBackground(ViewerCategoryJei.this.fluidSlot, -1, -1);
                        return this;
                    }

                    private ViewerCategory.SlotBuilder items(List<class_1799> stacks, float probability) {
                        slotBuilder.addItemStacks(stacks);
                        JeiSlotUtil.customizeTooltip(slotBuilder, probability);
                        return this;
                    }

                    @Override
                    public ViewerCategory.SlotBuilder item(class_1799 stack, float probability) {
                        return this.items(List.of(stack), probability);
                    }

                    @Override
                    public ViewerCategory.SlotBuilder ingredient(class_1856 ingredient, long amount, float probability) {
                        return this.items(Stream.of(ingredient.method_8105()).map(i -> {
                            class_1799 cp = i.method_7972();
                            cp.method_7939((int)amount);
                            return cp;
                        }).toList(), probability);
                    }

                    @Override
                    public ViewerCategory.SlotBuilder removeBackground() {
                        slotBuilder.setBackground((IDrawable)ViewerCategoryJei.this.helpers.getGuiHelper().createBlankDrawable(0, 0), 0, 0);
                        return this;
                    }

                    @Override
                    public ViewerCategory.SlotBuilder markCatalyst() {
                        return this;
                    }
                };
            }
        });
    }

    public void draw(D recipe, IRecipeSlotsView recipeSlotsView, final class_4587 stack, double mouseX, double mouseY) {
        stack.method_22904(-4.0, -4.0, 0.0);
        this.wrapped.buildWidgets(recipe, new ViewerCategory.WidgetList(){

            @Override
            public void text(class_2561 text, float x, float y, ViewerCategory.TextAlign align, boolean shadow, boolean overrideColor, @Nullable class_2561 tooltip) {
                float alignedX;
                class_327 font = class_310.method_1551().field_1772;
                int width = font.method_27525((class_5348)text);
                switch (align) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LEFT: {
                        float f = x;
                        break;
                    }
                    case CENTER: {
                        float f = x - (float)width / 2.0f;
                        break;
                    }
                    case RIGHT: {
                        float f = alignedX = x - (float)width;
                    }
                }
                if (shadow) {
                    font.method_30881(stack, text, alignedX, y, overrideColor ? -12566464 : -1);
                } else {
                    font.method_30883(stack, text, alignedX, y, overrideColor ? -12566464 : -1);
                }
            }

            @Override
            public void arrow(int x, int y) {
                this.texture(new MIIdentifier("textures/gui/jei/arrow.png"), x, y, 0, 17, 24, 17);
            }

            @Override
            public void texture(class_2960 loc, int x, int y, int u, int v, int width, int height) {
                IDrawableStatic drawable = ViewerCategoryJei.this.helpers.getGuiHelper().createDrawable(loc, u, v, width, height);
                drawable.draw(stack, x, y);
            }

            @Override
            public void drawable(ViewerCategory.DrawableWidget widget) {
                widget.draw(stack);
            }

            @Override
            public void item(double x, double y, double w, double h, class_1935 item) {
                stack.method_22903();
                IDrawable drawable = ViewerCategoryJei.this.helpers.getGuiHelper().createDrawableItemStack(item.method_8389().method_7854());
                stack.method_22904(x, y, 0.0);
                stack.method_22905((float)w / 16.0f, (float)h / 16.0f, 0.0f);
                drawable.draw(stack);
                stack.method_22909();
            }

            @Override
            public void tooltip(int x, int y, int w, int h, List<class_2561> tooltip) {
            }
        });
    }

    public List<class_2561> getTooltipStrings(D recipe, IRecipeSlotsView recipeSlotsView, double jeiMouseX, double jeiMouseY) {
        final double mouseX = jeiMouseX + 4.0;
        final double mouseY = jeiMouseY + 4.0;
        final ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
        this.wrapped.buildWidgets(recipe, new ViewerCategory.WidgetList(){

            @Override
            public void text(class_2561 text, float x, float y, ViewerCategory.TextAlign align, boolean shadow, boolean overrideColor, @Nullable class_2561 tooltip) {
                if (tooltip != null) {
                    class_327 font = class_310.method_1551().field_1772;
                    if ((double)x <= mouseX && (double)y <= mouseY && mouseX <= (double)(x + (float)font.method_27525((class_5348)text))) {
                        Objects.requireNonNull(font);
                        if (mouseY <= (double)(y + 9.0f)) {
                            tooltips.add(tooltip);
                        }
                    }
                }
            }

            @Override
            public void arrow(int x, int y) {
            }

            @Override
            public void texture(class_2960 loc, int x, int y, int u, int v, int width, int height) {
            }

            @Override
            public void drawable(ViewerCategory.DrawableWidget widget) {
            }

            @Override
            public void item(double x, double y, double w, double h, class_1935 item) {
            }

            @Override
            public void tooltip(int x, int y, int w, int h, List<class_2561> tooltip) {
                if ((double)x <= mouseX && (double)y <= mouseY && mouseX <= (double)(x + w) && mouseY <= (double)(y + h)) {
                    tooltips.addAll(tooltip);
                }
            }
        });
        return tooltips;
    }
}

