/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.rei;

import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.compat.viewer.impl.rei.ReiSlotUtil;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
class ViewerCategoryRei<D>
implements DisplayCategory<ViewerDisplay<D>> {
    public final ViewerCategory<D> wrapped;
    public final CategoryIdentifier<ViewerDisplay<D>> identifier;
    private final Renderer icon;

    public ViewerCategoryRei(final ViewerCategory<D> wrapped) {
        AbstractRenderer abstractRenderer;
        this.wrapped = wrapped;
        this.identifier = CategoryIdentifier.of((class_2960)wrapped.id);
        ViewerCategory.Icon icon = wrapped.icon;
        if (icon instanceof ViewerCategory.Icon.Stack) {
            ViewerCategory.Icon.Stack stack = (ViewerCategory.Icon.Stack)icon;
            abstractRenderer = EntryStacks.of((class_1799)stack.stack());
        } else {
            abstractRenderer = new AbstractRenderer(){

                public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    ViewerCategory.Icon.Texture texture = (ViewerCategory.Icon.Texture)wrapped.icon;
                    RenderSystem.setShaderTexture((int)0, (class_2960)texture.loc());
                    1.method_25291((class_4587)matrices, (int)(bounds.x - 1), (int)(bounds.y - 1), (int)this.getZ(), (float)texture.u(), (float)texture.v(), (int)18, (int)18, (int)256, (int)256);
                }
            };
        }
        this.icon = abstractRenderer;
    }

    public CategoryIdentifier<? extends ViewerDisplay<D>> getCategoryIdentifier() {
        return this.identifier;
    }

    public class_2561 getTitle() {
        return this.wrapped.title;
    }

    public int getDisplayWidth(ViewerDisplay display) {
        return this.wrapped.width;
    }

    public int getDisplayHeight() {
        return this.wrapped.height;
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public void registerRecipes(DisplayRegistry registry) {
        this.wrapped.buildRecipes(registry.getRecipeManager(), r -> registry.add(this.makeDisplay(r)));
    }

    private void processLayout(D recipe, final List<IngredientBuilder> inputs, final List<IngredientBuilder> outputs) {
        this.wrapped.buildLayout(recipe, new ViewerCategory.LayoutBuilder(){

            @Override
            public ViewerCategory.SlotBuilder inputSlot(int x, int y) {
                IngredientBuilder ing = new IngredientBuilder(x, y, true);
                inputs.add(ing);
                return ing;
            }

            @Override
            public ViewerCategory.SlotBuilder outputSlot(int x, int y) {
                IngredientBuilder ing = new IngredientBuilder(x, y, false);
                outputs.add(ing);
                return ing;
            }

            @Override
            public void invisibleOutput(class_1799 item) {
                IngredientBuilder ing = new IngredientBuilder(0, 0, false);
                ing.item(item);
                ing.isVisible = false;
                outputs.add(ing);
            }
        });
    }

    private ViewerDisplay<D> makeDisplay(D recipe) {
        ArrayList<IngredientBuilder> inputs = new ArrayList<IngredientBuilder>();
        ArrayList<IngredientBuilder> outputs = new ArrayList<IngredientBuilder>();
        this.processLayout(recipe, inputs, outputs);
        return new ViewerDisplay<D>(this.identifier, ViewerCategoryRei.convert(inputs), ViewerCategoryRei.convert(outputs), recipe);
    }

    private static List<EntryIngredient> convert(List<IngredientBuilder> ings) {
        ArrayList<EntryIngredient> ingredients = new ArrayList<EntryIngredient>();
        for (IngredientBuilder ing : ings) {
            ingredients.add(EntryIngredient.of(ing.ing));
        }
        return ingredients;
    }

    public List<Widget> setupDisplay(ViewerDisplay<D> display, final Rectangle bounds) {
        final ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        this.wrapped.buildWidgets(display.recipe, new ViewerCategory.WidgetList(){

            @Override
            public void text(class_2561 text, float x, float y, ViewerCategory.TextAlign align, boolean shadow, boolean overrideColor, @Nullable class_2561 tooltip) {
                Label label = Widgets.createLabel((Point)new Point((double)((float)bounds.x + x), (double)((float)bounds.y + y)), (class_2561)text);
                switch (align) {
                    case LEFT: {
                        label.leftAligned();
                        break;
                    }
                    case CENTER: {
                        label.centered();
                        break;
                    }
                    case RIGHT: {
                        label.rightAligned();
                    }
                }
                label.shadow(shadow);
                if (overrideColor) {
                    label.color(-12566464, -4473925);
                }
                if (tooltip != null) {
                    label.tooltip(new class_2561[]{tooltip});
                }
                widgets.add(label);
            }

            @Override
            public void arrow(int x, int y) {
                widgets.add(Widgets.createArrow((Point)new Point(bounds.x + x, bounds.y + y)));
            }

            @Override
            public void texture(class_2960 loc, int x, int y, int u, int v, int width, int height) {
                widgets.add(Widgets.createTexturedWidget((class_2960)loc, (int)(bounds.x + x), (int)(bounds.y + y), (float)u, (float)v, (int)width, (int)height));
            }

            @Override
            public void drawable(ViewerCategory.DrawableWidget widget) {
                widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
                    matrices.method_22903();
                    matrices.method_22904((double)bounds2.x, (double)bounds2.y, 0.0);
                    widget.draw(matrices);
                    matrices.method_22909();
                }));
            }

            @Override
            public void item(double x, double y, double w, double h, class_1935 item) {
                widgets.add(Widgets.createSlot((Rectangle)new Rectangle((double)bounds.x + x, (double)bounds.y + y, w, h)).entry(EntryStacks.of((class_1935)item)).disableTooltips().disableHighlight().disableBackground());
            }

            @Override
            public void tooltip(int x, int y, int w, int h, List<class_2561> tooltip) {
                widgets.add(Widgets.createDrawableWidget((helper, matrices, reiMouseX, reiMouseY, delta) -> {
                    int mouseX = reiMouseX - bounds2.x;
                    int mouseY = reiMouseY - bounds2.y;
                    if (mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h) {
                        Tooltip.create((Collection)tooltip).queue();
                    }
                }));
            }
        });
        ArrayList<IngredientBuilder> inputs = new ArrayList<IngredientBuilder>();
        ArrayList<IngredientBuilder> outputs = new ArrayList<IngredientBuilder>();
        this.processLayout(display.recipe, inputs, outputs);
        for (IngredientBuilder input : inputs) {
            ViewerCategoryRei.processIngredient(widgets, input, true, bounds);
        }
        for (IngredientBuilder output : outputs) {
            ViewerCategoryRei.processIngredient(widgets, output, false, bounds);
        }
        return widgets;
    }

    private static Widget createFluidSlotBackground(Point point) {
        return Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreen.SLOT_ATLAS);
            helper.method_25302(matrices, point.x - 1, point.y - 1, 18, 0, 18, 18);
        });
    }

    private static void processIngredient(List<Widget> widgets, IngredientBuilder ing, boolean isInput, Rectangle bounds) {
        if (!ing.isVisible) {
            return;
        }
        Point point = new Point(bounds.x + ing.x, bounds.y + ing.y);
        Slot slot = Widgets.createSlot((Point)point).entries(ing.ing);
        if (isInput) {
            slot.markInput();
        } else {
            slot.markOutput();
        }
        if (!ing.hasBackground) {
            slot.disableBackground();
        }
        if (ing.isFluid) {
            widgets.add(ViewerCategoryRei.createFluidSlotBackground(point));
        }
        widgets.add((Widget)slot);
    }

    @Environment(value=EnvType.CLIENT)
    public static class ViewerDisplay<D>
    implements Display {
        private final CategoryIdentifier<ViewerDisplay<D>> identifier;
        private final List<EntryIngredient> inputs;
        private final List<EntryIngredient> outputs;
        final D recipe;

        public ViewerDisplay(CategoryIdentifier<ViewerDisplay<D>> identifier, List<EntryIngredient> inputs, List<EntryIngredient> outputs, D recipe) {
            this.identifier = identifier;
            this.inputs = inputs;
            this.outputs = outputs;
            this.recipe = recipe;
        }

        public List<EntryIngredient> getInputEntries() {
            return this.inputs;
        }

        public List<EntryIngredient> getOutputEntries() {
            return this.outputs;
        }

        public CategoryIdentifier<?> getCategoryIdentifier() {
            return this.identifier;
        }

        public Optional<class_2960> getDisplayLocation() {
            Optional<class_2960> optional;
            D d = this.recipe;
            if (d instanceof class_1860) {
                class_1860 r = (class_1860)d;
                optional = Optional.of(r.method_8114());
            } else {
                optional = Optional.empty();
            }
            return optional;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class IngredientBuilder
    implements ViewerCategory.SlotBuilder {
        private final int x;
        private final int y;
        private final boolean input;
        private final List<EntryStack<?>> ing;
        private boolean isFluid = false;
        private boolean hasBackground = true;
        private boolean isVisible = true;

        IngredientBuilder(int x, int y, boolean input) {
            this.x = x;
            this.y = y;
            this.input = input;
            this.ing = new ArrayList();
        }

        @Override
        public ViewerCategory.SlotBuilder variant(TransferVariant<?> variant) {
            if (variant instanceof ItemVariant) {
                ItemVariant item = (ItemVariant)variant;
                this.item(item.toStack());
            } else if (variant instanceof FluidVariant) {
                FluidVariant fluid = (FluidVariant)variant;
                this.isFluid = true;
                this.hasBackground = false;
                if (!fluid.isBlank()) {
                    this.ing.add(ReiSlotUtil.createFluidNoAmount(fluid));
                }
            } else {
                throw new IllegalArgumentException("Unknown variant type: " + variant.getClass());
            }
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder fluid(FluidVariant fluid, long amount, float probability) {
            this.isFluid = true;
            this.hasBackground = false;
            this.ing.add(ReiSlotUtil.createFluidEntryStack(fluid, amount, probability, this.input));
            return this;
        }

        private ViewerCategory.SlotBuilder items(List<class_1799> stacks, float probability) {
            for (class_1799 stack : stacks) {
                this.ing.add(EntryStacks.of((class_1799)stack).tooltip(ReiSlotUtil.getProbabilitySetting(probability, this.input)));
            }
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder item(class_1799 stack, float probability) {
            return this.items(List.of(stack), probability);
        }

        @Override
        public ViewerCategory.SlotBuilder ingredient(class_1856 ingredient, long amount, float probability) {
            return this.items(Stream.of(ingredient.method_8105()).map(i -> {
                class_1799 cp = i.method_7972();
                cp.method_7939((int)amount);
                return cp;
            }).toList(), probability);
        }

        @Override
        public ViewerCategory.SlotBuilder removeBackground() {
            this.hasBackground = false;
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder markCatalyst() {
            return this;
        }
    }
}

