/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.api.ReiDraggable;
import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.BackgroundRenderedSlot;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.UnsupportedOperationInventory;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class ConfigurableFluidStack
extends AbstractConfigurableStack<class_3611, FluidVariant> {
    private long capacity;

    public ConfigurableFluidStack(long capacity) {
        this.capacity = capacity;
    }

    public static ConfigurableFluidStack standardInputSlot(long capacity) {
        ConfigurableFluidStack stack = new ConfigurableFluidStack(capacity);
        stack.playerInsert = true;
        stack.pipesInsert = true;
        return stack;
    }

    public static ConfigurableFluidStack standardOutputSlot(long capacity) {
        ConfigurableFluidStack stack = new ConfigurableFluidStack(capacity);
        stack.pipesExtract = true;
        return stack;
    }

    public static ConfigurableFluidStack standardIOSlot(long capacity, boolean pipeIO) {
        ConfigurableFluidStack stack = new ConfigurableFluidStack(capacity);
        stack.playerInsert = true;
        if (pipeIO) {
            stack.pipesInsert = true;
            stack.pipesExtract = true;
        }
        return stack;
    }

    public static ConfigurableFluidStack lockedInputSlot(long capacity, class_3611 fluid) {
        ConfigurableFluidStack stack = new ConfigurableFluidStack(capacity);
        stack.key = FluidVariant.of((class_3611)fluid);
        stack.lockedInstance = fluid;
        stack.playerInsert = true;
        stack.playerLockable = false;
        stack.playerLocked = true;
        stack.pipesInsert = true;
        return stack;
    }

    public static ConfigurableFluidStack lockedOutputSlot(long capacity, class_3611 fluid) {
        ConfigurableFluidStack stack = new ConfigurableFluidStack(capacity);
        stack.key = FluidVariant.of((class_3611)fluid);
        stack.lockedInstance = fluid;
        stack.playerLockable = false;
        stack.playerLocked = true;
        stack.pipesExtract = true;
        return stack;
    }

    public ConfigurableFluidStack(ConfigurableFluidStack other) {
        super(other);
        this.capacity = other.capacity;
    }

    public ConfigurableFluidStack(class_2487 compound) {
        super(compound);
        this.capacity = compound.method_10537("capacity");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigurableFluidStack that = (ConfigurableFluidStack)o;
        return this.capacity == that.capacity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.capacity);
    }

    public static ArrayList<ConfigurableFluidStack> copyList(List<ConfigurableFluidStack> list) {
        ArrayList<ConfigurableFluidStack> copy = new ArrayList<ConfigurableFluidStack>(list.size());
        for (ConfigurableFluidStack stack : list) {
            copy.add(new ConfigurableFluidStack(stack));
        }
        return copy;
    }

    @Override
    protected FluidVariant getBlankVariant() {
        return FluidVariant.blank();
    }

    @Override
    protected class_3611 getEmptyInstance() {
        return class_3612.field_15906;
    }

    @Override
    protected class_2378<class_3611> getRegistry() {
        return class_2378.field_11154;
    }

    @Override
    protected FluidVariant readVariantFromNbt(class_2487 compound) {
        return FluidVariant.fromNbt((class_2487)compound);
    }

    public long getCapacity() {
        return this.capacity;
    }

    @Override
    protected long getRemainingCapacityFor(FluidVariant key) {
        return this.getRemainingSpace();
    }

    @Override
    public void setAmount(long amount) {
        super.setAmount(amount);
        if (amount > this.capacity) {
            throw new IllegalStateException("amount > capacity in the fluid stack");
        }
        if (amount < 0L) {
            throw new IllegalStateException("amount < 0 in the fluid stack");
        }
    }

    public void setCapacity(long capacity) {
        Preconditions.checkArgument((capacity >= 0L ? 1 : 0) != 0, (Object)"Fluid Capacity must be > 0");
        this.capacity = capacity;
        if (this.amount > capacity) {
            this.amount = capacity;
        }
    }

    public long getRemainingSpace() {
        return this.capacity - this.amount;
    }

    @Override
    public class_2487 toNbt() {
        class_2487 tag = super.toNbt();
        tag.method_10544("capacity", this.capacity);
        return tag;
    }

    public class ConfigurableFluidSlot
    extends class_1735
    implements ReiDraggable,
    BackgroundRenderedSlot {
        private final Runnable markDirty;

        public ConfigurableFluidSlot(ConfigurableFluidSlot other) {
            this(other.markDirty, other.field_7873, other.field_7872);
            this.field_7874 = other.field_7874;
        }

        public ConfigurableFluidSlot(Runnable markDirty, int x, int y) {
            super((class_1263)new UnsupportedOperationInventory(), -1, x, y);
            this.markDirty = markDirty;
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }

        public boolean method_7674(class_1657 playerEntity) {
            return false;
        }

        public boolean canInsertFluid(FluidVariant fluid) {
            FluidVariant storedFluid = (FluidVariant)this.getConfStack().getResource();
            return ConfigurableFluidStack.this.playerInsert && ConfigurableFluidStack.this.isResourceAllowedByLock(fluid.getFluid()) && (storedFluid.isBlank() || storedFluid.equals(fluid));
        }

        public boolean canExtractFluid(FluidVariant fluid) {
            return ConfigurableFluidStack.this.playerExtract;
        }

        public ConfigurableFluidStack getConfStack() {
            return ConfigurableFluidStack.this;
        }

        public class_1799 method_7677() {
            return class_1799.field_8037;
        }

        public void method_7673(class_1799 stack) {
        }

        public void method_44206(class_1799 itemStack) {
            this.method_7673(itemStack);
        }

        public void method_7668() {
            this.markDirty.run();
        }

        @Override
        public boolean dragFluid(FluidVariant fluidKey, Simulation simulation) {
            return ConfigurableFluidStack.this.playerLock(fluidKey.getFluid(), simulation);
        }

        @Override
        public boolean dragItem(ItemVariant itemKey, Simulation simulation) {
            return false;
        }

        @Override
        public int getBackgroundU() {
            return ConfigurableFluidStack.this.isPlayerLocked() ? 90 : (ConfigurableFluidStack.this.isMachineLocked() ? 126 : 18);
        }

        public boolean playerInteract(ContainerItemContext context, class_1657 player, boolean allowSlotExtract) {
            Storage io = (Storage)context.find(FluidStorage.ITEM);
            if (io != null) {
                long previousAmount = ConfigurableFluidStack.this.amount;
                try (Transaction transaction = Transaction.openOuter();){
                    for (StorageView view : io) {
                        FluidVariant fluid = (FluidVariant)view.getResource();
                        if (fluid.isBlank() || !this.canInsertFluid(fluid)) continue;
                        Transaction tx = transaction.openNested();
                        try {
                            long extracted = view.extract((Object)fluid, ConfigurableFluidStack.this.getRemainingSpace(), (TransactionContext)tx);
                            if (extracted <= 0L) continue;
                            player.method_17356(FluidVariantAttributes.getEmptySound((FluidVariant)fluid), class_3419.field_15245, 1.0f, 1.0f);
                            tx.commit();
                            ConfigurableFluidStack.this.increment(extracted);
                            ConfigurableFluidStack.this.setKey(fluid);
                        }
                        finally {
                            if (tx == null) continue;
                            tx.close();
                        }
                    }
                    transaction.commit();
                }
                if (previousAmount != ConfigurableFluidStack.this.amount) {
                    return true;
                }
                if (!allowSlotExtract) {
                    return false;
                }
                FluidVariant fluid = (FluidVariant)ConfigurableFluidStack.this.getResource();
                if (!fluid.isBlank() && this.canExtractFluid(fluid)) {
                    try (Transaction tx = Transaction.openOuter();){
                        long inserted = io.insert((Object)fluid, ConfigurableFluidStack.this.getAmount(), (TransactionContext)tx);
                        if (inserted > 0L) {
                            ConfigurableFluidStack.this.decrement(inserted);
                            player.method_17356(FluidVariantAttributes.getFillSound((FluidVariant)fluid), class_3419.field_15245, 1.0f, 1.0f);
                            tx.commit();
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
            return false;
        }
    }
}

