/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.api.ReiDraggable;
import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.BackgroundRenderedSlot;
import aztech.modern_industrialization.inventory.HackySlot;
import aztech.modern_industrialization.util.Simulation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;

public class ConfigurableItemStack
extends AbstractConfigurableStack<class_1792, ItemVariant> {
    private int adjustedCapacity = 64;

    public ConfigurableItemStack() {
    }

    public ConfigurableItemStack(class_2487 compound) {
        super(compound);
        this.adjustedCapacity = compound.method_10550("adjCap");
    }

    @Override
    public class_2487 toNbt() {
        class_2487 nbt = super.toNbt();
        nbt.method_10569("adjCap", this.adjustedCapacity);
        return nbt;
    }

    public static ConfigurableItemStack standardInputSlot() {
        ConfigurableItemStack stack = new ConfigurableItemStack();
        stack.playerInsert = true;
        stack.pipesInsert = true;
        return stack;
    }

    public static ConfigurableItemStack standardOutputSlot() {
        ConfigurableItemStack stack = new ConfigurableItemStack();
        stack.pipesExtract = true;
        return stack;
    }

    public static ConfigurableItemStack standardIOSlot(boolean pipeIO) {
        ConfigurableItemStack stack = new ConfigurableItemStack();
        stack.playerInsert = true;
        if (pipeIO) {
            stack.pipesInsert = true;
            stack.pipesExtract = true;
        }
        return stack;
    }

    public static ConfigurableItemStack lockedInputSlot(class_1792 item) {
        ConfigurableItemStack stack = new ConfigurableItemStack();
        stack.key = ItemVariant.of((class_1935)item);
        stack.lockedInstance = item;
        stack.playerInsert = true;
        stack.playerLockable = false;
        stack.playerLocked = true;
        stack.pipesInsert = true;
        return stack;
    }

    public ConfigurableItemStack(ConfigurableItemStack other) {
        super(other);
        this.adjustedCapacity = other.adjustedCapacity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigurableItemStack that = (ConfigurableItemStack)o;
        return this.adjustedCapacity == that.adjustedCapacity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.adjustedCapacity);
    }

    @Override
    protected ItemVariant getBlankVariant() {
        return ItemVariant.blank();
    }

    @Override
    protected class_1792 getEmptyInstance() {
        return class_1802.field_8162;
    }

    @Override
    protected class_2378<class_1792> getRegistry() {
        return class_2378.field_11142;
    }

    @Override
    protected ItemVariant readVariantFromNbt(class_2487 compound) {
        return ItemVariant.fromNbt((class_2487)compound);
    }

    public long getCapacity() {
        return ((ItemVariant)this.key).isBlank() ? (long)this.adjustedCapacity : (long)Math.min(this.adjustedCapacity, ((ItemVariant)this.key).getItem().method_7882());
    }

    @Override
    public long getRemainingCapacityFor(ItemVariant key) {
        return (long)Math.min(key.getItem().method_7882(), this.adjustedCapacity) - this.amount;
    }

    @Override
    public void setAmount(long amount) {
        super.setAmount(amount);
        if ((long)this.adjustedCapacity < amount) {
            this.adjustedCapacity = (int)amount;
        }
    }

    public static ArrayList<ConfigurableItemStack> copyList(List<ConfigurableItemStack> list) {
        ArrayList<ConfigurableItemStack> copy = new ArrayList<ConfigurableItemStack>(list.size());
        for (ConfigurableItemStack stack : list) {
            copy.add(new ConfigurableItemStack(stack));
        }
        return copy;
    }

    public boolean isValid(class_1799 stack) {
        return this.isResourceAllowedByLock(stack.method_7909());
    }

    public void adjustCapacity(boolean isIncrease, boolean isShiftDown) {
        int delta;
        int n = delta = isShiftDown ? 8 : 1;
        if (!isIncrease) {
            delta = -delta;
        }
        this.adjustedCapacity = Math.min(64, Math.max((int)this.amount, this.adjustedCapacity + delta));
    }

    public int getAdjustedCapacity() {
        return this.adjustedCapacity;
    }

    public class ConfigurableItemSlot
    extends HackySlot
    implements ReiDraggable,
    BackgroundRenderedSlot {
        private final Predicate<class_1799> insertPredicate;
        private final Runnable markDirty;

        public ConfigurableItemSlot(ConfigurableItemSlot other) {
            this(other.markDirty, other.field_7873, other.field_7872, other.insertPredicate);
            this.field_7874 = other.field_7874;
        }

        public ConfigurableItemSlot(Runnable markDirty, int x, int y, Predicate<class_1799> insertPredicate) {
            super(x, y);
            this.insertPredicate = insertPredicate;
            this.markDirty = markDirty;
        }

        public boolean method_7680(class_1799 stack) {
            return ConfigurableItemStack.this.playerInsert && ConfigurableItemStack.this.isValid(stack) && this.insertPredicate.test(stack);
        }

        public boolean method_7674(class_1657 playerEntity) {
            return ConfigurableItemStack.this.playerExtract;
        }

        public ConfigurableItemStack getConfStack() {
            return ConfigurableItemStack.this;
        }

        @Override
        protected class_1799 getRealStack() {
            return ((ItemVariant)ConfigurableItemStack.this.key).toStack((int)ConfigurableItemStack.this.amount);
        }

        @Override
        protected void setRealStack(class_1799 stack) {
            ConfigurableItemStack.this.key = ItemVariant.of((class_1799)stack);
            ConfigurableItemStack.this.amount = stack.method_7947();
            ConfigurableItemStack.this.notifyListeners();
            this.markDirty.run();
        }

        public int method_7675() {
            return ConfigurableItemStack.this.adjustedCapacity;
        }

        @Override
        public boolean dragFluid(FluidVariant fluidKey, Simulation simulation) {
            return false;
        }

        @Override
        public boolean dragItem(ItemVariant itemKey, Simulation simulation) {
            return ConfigurableItemStack.this.playerLock(itemKey.getItem(), simulation);
        }

        @Override
        public int getBackgroundU() {
            return ConfigurableItemStack.this.isPlayerLocked() ? 72 : (ConfigurableItemStack.this.isMachineLocked() ? 108 : 0);
        }
    }
}

