/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class CraftingMultiblockGuiClient
implements GuiComponentClient {
    public boolean isShapeValid;
    boolean hasActiveRecipe;
    float progress;
    int efficiencyTicks;
    int maxEfficiencyTicks;
    long currentRecipeEu;
    long baseRecipeEu;

    public CraftingMultiblockGuiClient(class_2540 buf) {
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(class_2540 buf) {
        this.isShapeValid = buf.readBoolean();
        if (this.isShapeValid) {
            this.hasActiveRecipe = buf.readBoolean();
            if (this.hasActiveRecipe) {
                this.progress = buf.readFloat();
                this.efficiencyTicks = buf.readInt();
                this.maxEfficiencyTicks = buf.readInt();
                this.currentRecipeEu = buf.readLong();
                this.baseRecipeEu = buf.readLong();
            }
        }
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    @Environment(value=EnvType.CLIENT)
    public class Renderer
    implements ClientComponentRenderer {
        private final MIIdentifier texture = new MIIdentifier("textures/gui/container/multiblock_info.png");

        @Override
        public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
            class_310 minecraftClient = class_310.method_1551();
            RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
            class_332.method_25290((class_4587)matrices, (int)(x + 4), (int)(y + 16), (float)0.0f, (float)0.0f, (int)166, (int)80, (int)166, (int)80);
            class_327 textRenderer = minecraftClient.field_1772;
            textRenderer.method_30883(matrices, (class_2561)(CraftingMultiblockGuiClient.this.isShapeValid ? MIText.MultiblockShapeValid.text() : MIText.MultiblockShapeInvalid.text()), (float)(x + 9), (float)(y + 23), CraftingMultiblockGuiClient.this.isShapeValid ? 0xFFFFFF : 0xFF0000);
            if (CraftingMultiblockGuiClient.this.isShapeValid) {
                textRenderer.method_30883(matrices, (class_2561)(CraftingMultiblockGuiClient.this.hasActiveRecipe ? MIText.MultiblockStatusActive.text() : MIText.MultiblockStatusActive.text()), (float)(x + 9), (float)(y + 34), 0xFFFFFF);
                if (CraftingMultiblockGuiClient.this.hasActiveRecipe) {
                    int deltaY = 45;
                    textRenderer.method_30883(matrices, (class_2561)MIText.Progress.text(String.format("%.1f", Float.valueOf(CraftingMultiblockGuiClient.this.progress * 100.0f)) + " %"), (float)(x + 9), (float)(y + deltaY), 0xFFFFFF);
                    deltaY += 11;
                    if (CraftingMultiblockGuiClient.this.efficiencyTicks != 0 || CraftingMultiblockGuiClient.this.maxEfficiencyTicks != 0) {
                        textRenderer.method_30883(matrices, (class_2561)MIText.EfficiencyTicks.text(CraftingMultiblockGuiClient.this.efficiencyTicks, CraftingMultiblockGuiClient.this.maxEfficiencyTicks), (float)(x + 9), (float)(y + deltaY), 0xFFFFFF);
                        deltaY += 11;
                    }
                    textRenderer.method_30883(matrices, (class_2561)MIText.BaseEuRecipe.text(TextHelper.getEuTextTick(CraftingMultiblockGuiClient.this.baseRecipeEu)), (float)(x + 9), (float)(y + deltaY), 0xFFFFFF);
                    textRenderer.method_30883(matrices, (class_2561)MIText.CurrentEuRecipe.text(TextHelper.getEuTextTick(CraftingMultiblockGuiClient.this.currentRecipeEu)), (float)(x + 9), (float)(y + (deltaY += 11)), 0xFFFFFF);
                }
            }
        }
    }
}

