/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.util.RenderHelper;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class EnergyBarClient
implements GuiComponentClient {
    final EnergyBar.Parameters params;
    long eu;
    long maxEu;

    public EnergyBarClient(class_2540 buf) {
        this.params = new EnergyBar.Parameters(buf.readInt(), buf.readInt());
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(class_2540 buf) {
        this.eu = buf.readLong();
        this.maxEu = buf.readLong();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    @Environment(value=EnvType.CLIENT)
    public class Renderer
    implements ClientComponentRenderer {
        public static final int WIDTH = 13;
        public static final int HEIGHT = 18;

        public static void renderEnergy(class_332 helper, class_4587 matrices, int px, int py, float fill) {
            RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreen.SLOT_ATLAS);
            helper.method_25302(matrices, px, py, 230, 0, 13, 18);
            int fillPixels = (int)((double)(fill * 18.0f) * 0.9 + 1.8);
            if ((double)fill > 0.95) {
                fillPixels = 18;
            }
            helper.method_25302(matrices, px, py + 18 - fillPixels, 243, 18 - fillPixels, 13, fillPixels);
        }

        @Override
        public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
            Renderer.renderEnergy(helper, matrices, x + EnergyBarClient.this.params.renderX, y + EnergyBarClient.this.params.renderY, (float)EnergyBarClient.this.eu / (float)EnergyBarClient.this.maxEu);
        }

        @Override
        public void renderTooltip(MachineScreen screen, class_4587 matrices, int x, int y, int cursorX, int cursorY) {
            if (RenderHelper.isPointWithinRectangle(EnergyBarClient.this.params.renderX, EnergyBarClient.this.params.renderY, 13, 18, cursorX - x, cursorY - y)) {
                class_5250 tooltip;
                if (class_437.method_25442()) {
                    tooltip = MIText.EuMaxed.text(EnergyBarClient.this.eu, EnergyBarClient.this.maxEu, "");
                } else {
                    TextHelper.MaxedAmount maxedAmount = TextHelper.getMaxedAmount(EnergyBarClient.this.eu, EnergyBarClient.this.maxEu);
                    tooltip = MIText.EuMaxed.text(maxedAmount.digit(), maxedAmount.maxDigit(), maxedAmount.unit());
                }
                screen.method_30901(matrices, Collections.singletonList(tooltip), cursorX, cursorY);
            }
        }
    }
}

