/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.GunpowderOverclockGui;
import aztech.modern_industrialization.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class GunpowderOverclockGuiClient
implements GuiComponentClient {
    final GunpowderOverclockGui.Parameters params;
    int remTick;

    public GunpowderOverclockGuiClient(class_2540 buf) {
        this.params = new GunpowderOverclockGui.Parameters(buf.readInt(), buf.readInt());
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(class_2540 buf) {
        this.remTick = buf.readInt();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    @Environment(value=EnvType.CLIENT)
    public class Renderer
    implements ClientComponentRenderer {
        @Override
        public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
            if (GunpowderOverclockGuiClient.this.remTick > 0) {
                RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreen.SLOT_ATLAS);
                int px = x + GunpowderOverclockGuiClient.this.params.renderX;
                int py = y + GunpowderOverclockGuiClient.this.params.renderY;
                helper.method_25302(matrices, px, py, 0, 58, 20, 20);
            }
        }

        @Override
        public void renderTooltip(MachineScreen screen, class_4587 matrices, int x, int y, int cursorX, int cursorY) {
            if (GunpowderOverclockGuiClient.this.remTick > 0 && RenderHelper.isPointWithinRectangle(GunpowderOverclockGuiClient.this.params.renderX, GunpowderOverclockGuiClient.this.params.renderY, 20, 20, cursorX - x, cursorY - y)) {
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                int seconds = GunpowderOverclockGuiClient.this.remTick / 20;
                int hours = seconds / 3600;
                int minutes = seconds % 3600 / 60;
                String time = String.format("%d", seconds);
                if (hours > 0) {
                    time = String.format("%d:%02d:%02d", hours, minutes, seconds % 60);
                } else if (minutes > 0) {
                    time = String.format("%d:%02d", minutes, seconds % 60);
                }
                tooltip.add(MIText.GunpowderTime.text(time));
                screen.method_30901(matrices, tooltip, cursorX, cursorY);
            }
        }
    }
}

