/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.RecipeEfficiencyBar;
import aztech.modern_industrialization.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class RecipeEfficiencyBarClient
implements GuiComponentClient {
    final RecipeEfficiencyBar.Parameters params;
    boolean hasActiveRecipe;
    int efficiencyTicks;
    int maxEfficiencyTicks;
    long currentRecipeEu;
    long baseRecipeEu;
    long maxRecipeEu;
    private static final class_2960 TEXTURE = new MIIdentifier("textures/gui/efficiency_bar.png");
    private static final int WIDTH = 100;
    private static final int HEIGHT = 2;

    public RecipeEfficiencyBarClient(class_2540 buf) {
        this.params = new RecipeEfficiencyBar.Parameters(buf.readInt(), buf.readInt());
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(class_2540 buf) {
        this.hasActiveRecipe = buf.readBoolean();
        if (this.hasActiveRecipe) {
            this.efficiencyTicks = buf.readInt();
            this.maxEfficiencyTicks = buf.readInt();
            this.currentRecipeEu = buf.readLong();
            this.baseRecipeEu = buf.readLong();
        }
        this.maxRecipeEu = buf.readLong();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    @Environment(value=EnvType.CLIENT)
    public class Renderer
    implements ClientComponentRenderer {
        @Override
        public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            class_332.method_25291((class_4587)matrices, (int)(x + RecipeEfficiencyBarClient.this.params.renderX - 1), (int)(y + RecipeEfficiencyBarClient.this.params.renderY - 1), (int)helper.method_25305(), (float)0.0f, (float)2.0f, (int)102, (int)4, (int)102, (int)6);
            if (RecipeEfficiencyBarClient.this.hasActiveRecipe) {
                int barPixels = (int)((float)RecipeEfficiencyBarClient.this.efficiencyTicks / (float)RecipeEfficiencyBarClient.this.maxEfficiencyTicks * 100.0f);
                class_332.method_25291((class_4587)matrices, (int)(x + RecipeEfficiencyBarClient.this.params.renderX), (int)(y + RecipeEfficiencyBarClient.this.params.renderY), (int)helper.method_25305(), (float)0.0f, (float)0.0f, (int)barPixels, (int)2, (int)102, (int)6);
            }
        }

        @Override
        public void renderTooltip(MachineScreen screen, class_4587 matrices, int x, int y, int cursorX, int cursorY) {
            if (RenderHelper.isPointWithinRectangle(RecipeEfficiencyBarClient.this.params.renderX, RecipeEfficiencyBarClient.this.params.renderY, 100, 2, cursorX - x, cursorY - y)) {
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                if (RecipeEfficiencyBarClient.this.hasActiveRecipe) {
                    DecimalFormat factorFormat = new DecimalFormat("#.#");
                    tooltip.add(MIText.EfficiencyTicks.text(RecipeEfficiencyBarClient.this.efficiencyTicks, RecipeEfficiencyBarClient.this.maxEfficiencyTicks));
                    tooltip.add(MIText.EfficiencyFactor.text(factorFormat.format((double)RecipeEfficiencyBarClient.this.currentRecipeEu / (double)RecipeEfficiencyBarClient.this.baseRecipeEu)));
                    tooltip.add(MIText.EfficiencyEu.text(RecipeEfficiencyBarClient.this.currentRecipeEu));
                } else {
                    tooltip.add(MIText.EfficiencyDefaultMessage.text());
                }
                tooltip.add(MIText.EfficiencyMaxOverclock.text(RecipeEfficiencyBarClient.this.maxRecipeEu));
                screen.method_30901(matrices, tooltip, cursorX, cursorY);
            }
        }
    }
}

