/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.TemperatureBar;
import aztech.modern_industrialization.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class TemperatureBarClient
implements GuiComponentClient {
    public final TemperatureBar.Parameters params;
    public int temperature;

    public TemperatureBarClient(class_2540 buf) {
        this.params = new TemperatureBar.Parameters(buf.readInt(), buf.readInt(), buf.readInt());
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(class_2540 buf) {
        this.temperature = buf.readInt();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    @Environment(value=EnvType.CLIENT)
    public class Renderer
    implements ClientComponentRenderer {
        private final MIIdentifier TEXTURE = new MIIdentifier("textures/gui/efficiency_bar.png");
        private final int WIDTH = 100;
        private final int HEIGHT = 2;

        @Override
        public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.TEXTURE);
            class_332.method_25291((class_4587)matrices, (int)(x + TemperatureBarClient.this.params.renderX - 1), (int)(y + TemperatureBarClient.this.params.renderY - 1), (int)helper.method_25305(), (float)0.0f, (float)2.0f, (int)102, (int)4, (int)102, (int)6);
            int barPixels = (int)((float)TemperatureBarClient.this.temperature / (float)TemperatureBarClient.this.params.temperatureMax * 100.0f);
            class_332.method_25291((class_4587)matrices, (int)(x + TemperatureBarClient.this.params.renderX), (int)(y + TemperatureBarClient.this.params.renderY), (int)helper.method_25305(), (float)0.0f, (float)0.0f, (int)barPixels, (int)2, (int)102, (int)6);
            RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreen.SLOT_ATLAS);
            helper.method_25302(matrices, x + TemperatureBarClient.this.params.renderX - 22, y + TemperatureBarClient.this.params.renderY + 1 - 10, 144, 0, 20, 20);
        }

        @Override
        public void renderTooltip(MachineScreen screen, class_4587 matrices, int x, int y, int cursorX, int cursorY) {
            if (RenderHelper.isPointWithinRectangle(TemperatureBarClient.this.params.renderX, TemperatureBarClient.this.params.renderY, 100, 2, cursorX - x, cursorY - y)) {
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                tooltip.add(MIText.Temperature.text(TemperatureBarClient.this.temperature));
                screen.method_30901(matrices, tooltip, cursorX, cursorY);
            }
        }
    }
}

