/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public abstract class HatchBlockEntity
extends MachineBlockEntity
implements Tickable {
    private String lastSyncedMachineCasing = null;
    private String matchedCasing = null;

    public HatchBlockEntity(BEP bep, MachineGuiParameters guiParams, OrientationComponent.Params orientationParams) {
        super(bep, guiParams, orientationParams);
        this.registerComponents(new IComponent.ClientOnly(){

            @Override
            public void writeClientNbt(class_2487 tag) {
                if (HatchBlockEntity.this.matchedCasing != null) {
                    tag.method_10582("matchedCasing", HatchBlockEntity.this.matchedCasing);
                }
            }

            @Override
            public void readClientNbt(class_2487 tag) {
                HatchBlockEntity.this.matchedCasing = tag.method_10545("matchedCasing") ? tag.method_10558("matchedCasing") : null;
            }
        });
    }

    public abstract HatchType getHatchType();

    public abstract boolean upgradesToSteel();

    public boolean isMatched() {
        return this.matchedCasing != null;
    }

    public void method_10996() {
        super.method_10996();
        this.clearMachineLock();
    }

    public void unlink() {
        this.matchedCasing = null;
        this.clearMachineLock();
    }

    public void link(MachineCasing casing) {
        this.matchedCasing = casing.name;
    }

    protected void clearMachineLock() {
        for (ConfigurableItemStack itemStack : this.getInventory().getItemStacks()) {
            itemStack.disableMachineLock();
        }
        for (ConfigurableFluidStack fluidStack : this.getInventory().getFluidStacks()) {
            fluidStack.disableMachineLock();
        }
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineCasing casing = this.isMatched() ? MachineCasings.get(this.matchedCasing) : null;
        MachineModelClientData data = new MachineModelClientData(casing);
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public void onPlaced(class_1309 placer, class_1799 itemStack) {
        super.onPlaced(placer, itemStack);
        if (this.orientation.params.hasOutput) {
            this.orientation.outputDirection = this.orientation.outputDirection.method_10153();
        }
    }

    @Override
    public void tick() {
        if (this.field_11863.method_8608()) {
            return;
        }
        if (!Objects.equals(this.lastSyncedMachineCasing, this.matchedCasing)) {
            this.lastSyncedMachineCasing = this.matchedCasing;
            this.sync();
        }
        this.tickTransfer();
        this.method_5431();
    }

    protected void tickTransfer() {
    }

    public void appendItemInputs(List<ConfigurableItemStack> list) {
    }

    public void appendItemOutputs(List<ConfigurableItemStack> list) {
    }

    public void appendFluidInputs(List<ConfigurableFluidStack> list) {
    }

    public void appendFluidOutputs(List<ConfigurableFluidStack> list) {
    }

    public void appendEnergyInputs(List<EnergyComponent> list) {
    }

    public void appendEnergyOutputs(List<EnergyComponent> list) {
    }
}

