/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.multiblocks.world.ChunkEventListener;
import aztech.modern_industrialization.machines.multiblocks.world.ChunkEventListeners;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class ShapeMatcher
implements ChunkEventListener {
    private final class_2338 controllerPos;
    private final ShapeTemplate template;
    private final Map<class_2338, SimpleMember> simpleMembers;
    private final Map<class_2338, HatchFlags> hatchFlags;
    private boolean needsRematch = true;
    private boolean matchSuccessful = false;
    private final List<HatchBlockEntity> matchedHatches = new ArrayList<HatchBlockEntity>();

    public ShapeMatcher(class_1937 world, class_2338 controllerPos, class_2350 controllerDirection, ShapeTemplate template) {
        this.controllerPos = controllerPos;
        this.template = template;
        this.simpleMembers = ShapeMatcher.toWorldPos(controllerPos, controllerDirection, template.simpleMembers);
        this.hatchFlags = ShapeMatcher.toWorldPos(controllerPos, controllerDirection, template.hatchFlags);
    }

    public static class_2338 toWorldPos(class_2338 controllerPos, class_2350 controllerDirection, class_2338 templatePos) {
        class_2338 rotatedPos = controllerDirection == class_2350.field_11043 ? templatePos : (controllerDirection == class_2350.field_11035 ? new class_2338(-templatePos.method_10263(), templatePos.method_10264(), -templatePos.method_10260()) : (controllerDirection == class_2350.field_11034 ? new class_2338(-templatePos.method_10260(), templatePos.method_10264(), templatePos.method_10263()) : new class_2338(templatePos.method_10260(), templatePos.method_10264(), -templatePos.method_10263())));
        return rotatedPos.method_10081((class_2382)controllerPos);
    }

    private static <V> Map<class_2338, V> toWorldPos(class_2338 controllerPos, class_2350 controllerDirection, Map<class_2338, V> templateMap) {
        HashMap<class_2338, V> result = new HashMap<class_2338, V>();
        for (Map.Entry<class_2338, V> entry : templateMap.entrySet()) {
            result.put(ShapeMatcher.toWorldPos(controllerPos, controllerDirection, entry.getKey()), entry.getValue());
        }
        return result;
    }

    public Set<class_2338> getPositions() {
        return new HashSet<class_2338>(this.simpleMembers.keySet());
    }

    public SimpleMember getSimpleMember(class_2338 pos) {
        return Objects.requireNonNull(this.simpleMembers.get(pos));
    }

    @Nullable
    public HatchFlags getHatchFlags(class_2338 pos) {
        return this.hatchFlags.get(pos);
    }

    public List<HatchBlockEntity> getMatchedHatches() {
        return Collections.unmodifiableList(this.matchedHatches);
    }

    public void unlinkHatches() {
        for (HatchBlockEntity hatch : this.matchedHatches) {
            hatch.unlink();
        }
        this.matchedHatches.clear();
        this.matchSuccessful = false;
        this.needsRematch = true;
    }

    public boolean matches(class_2338 pos, class_1937 world, @Nullable List<HatchBlockEntity> hatches) {
        SimpleMember simpleMember = this.simpleMembers.get(pos);
        if (simpleMember == null) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        if (simpleMember.matchesState(state)) {
            return true;
        }
        class_2586 be = world.method_8321(pos);
        if (be instanceof HatchBlockEntity) {
            HatchBlockEntity hatch = (HatchBlockEntity)be;
            HatchFlags flags = this.hatchFlags.get(pos);
            if (flags != null && flags.allows(hatch.getHatchType()) && !hatch.isMatched()) {
                if (this.matchedHatches != null) {
                    this.matchedHatches.add(hatch);
                }
                return true;
            }
        }
        return false;
    }

    public boolean needsRematch() {
        return this.needsRematch;
    }

    public boolean isMatchSuccessful() {
        return this.matchSuccessful && !this.needsRematch;
    }

    public void rematch(class_1937 world) {
        this.unlinkHatches();
        this.matchSuccessful = true;
        for (class_2338 pos : this.simpleMembers.keySet()) {
            if (this.matches(pos, world, this.matchedHatches)) continue;
            this.matchSuccessful = false;
        }
        if (!this.matchSuccessful) {
            this.matchedHatches.clear();
        } else {
            for (HatchBlockEntity hatch : this.matchedHatches) {
                hatch.link(this.template.hatchCasing);
            }
        }
        this.needsRematch = false;
    }

    public Set<class_1923> getSpannedChunks() {
        HashSet<class_1923> spannedChunks = new HashSet<class_1923>();
        for (class_2338 pos : this.simpleMembers.keySet()) {
            spannedChunks.add(new class_1923(pos));
        }
        return spannedChunks;
    }

    public void registerListeners(class_1937 world) {
        for (class_1923 chunkPos : this.getSpannedChunks()) {
            ChunkEventListeners.listeners.add(world, chunkPos, this);
        }
    }

    public void unregisterListeners(class_1937 world) {
        for (class_1923 chunkPos : this.getSpannedChunks()) {
            ChunkEventListeners.listeners.remove(world, chunkPos, this);
        }
    }

    @Override
    public void onBlockUpdate(class_2338 pos) {
        if (this.simpleMembers.containsKey(pos)) {
            this.needsRematch = true;
        }
    }

    @Override
    public void onUnload() {
        this.needsRematch = true;
    }

    @Override
    public void onLoad() {
        this.needsRematch = true;
    }
}

