/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe;

import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessConditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class MachineRecipeType
implements class_3956<MachineRecipe>,
class_1865<MachineRecipe> {
    private final Map<class_1792, List<MachineRecipe>> recipeCache = new HashMap<class_1792, List<MachineRecipe>>();
    private final List<MachineRecipe> fluidOnlyRecipes = new ArrayList<MachineRecipe>();
    private long lastUpdate = 0L;
    private static final long UPDATE_INTERVAL = 20000L;
    private final class_2960 id;
    private boolean allowItemInput = false;
    private boolean allowFluidInput = false;
    private boolean allowItemOutput = false;
    private boolean allowFluidOutput = false;

    public MachineRecipeType(class_2960 id) {
        this.id = id;
    }

    protected Collection<MachineRecipe> getManagerRecipes(class_1937 world) {
        return world.method_8433().method_30027((class_3956)this);
    }

    public Collection<MachineRecipe> getRecipes(class_1937 world) {
        return this.getManagerRecipes(world);
    }

    @Nullable
    public MachineRecipe getRecipe(class_1937 world, class_2960 id) {
        return this.getRecipes(world).stream().filter(r -> r.method_8114().equals((Object)id)).findFirst().orElse(null);
    }

    private void updateRecipeCache(class_3218 world) {
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate <= 20000L) {
            return;
        }
        this.lastUpdate = time;
        this.recipeCache.clear();
        this.fluidOnlyRecipes.clear();
        for (MachineRecipe recipe : this.getRecipes((class_1937)world)) {
            if (recipe.itemInputs.size() == 0) {
                if (recipe.fluidInputs.size() <= 0) continue;
                this.fluidOnlyRecipes.add(recipe);
                continue;
            }
            for (class_1792 inputItem : recipe.itemInputs.get(0).getInputItems()) {
                this.recipeCache.putIfAbsent(inputItem, new ArrayList());
                this.recipeCache.get(inputItem).add(recipe);
            }
        }
    }

    public Collection<MachineRecipe> getMatchingRecipes(class_3218 world, class_1792 input) {
        this.updateRecipeCache(world);
        return Collections.unmodifiableCollection(this.recipeCache.getOrDefault(input, Collections.emptyList()));
    }

    public Collection<MachineRecipe> getFluidOnlyRecipes(class_3218 world) {
        this.updateRecipeCache(world);
        return Collections.unmodifiableList(this.fluidOnlyRecipes);
    }

    public MachineRecipeType withItemInputs() {
        this.allowItemInput = true;
        return this;
    }

    public MachineRecipeType withFluidInputs() {
        this.allowFluidInput = true;
        return this;
    }

    public MachineRecipeType withItemOutputs() {
        this.allowItemOutput = true;
        return this;
    }

    public MachineRecipeType withFluidOutputs() {
        this.allowFluidOutput = true;
        return this;
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getPath() {
        return this.id.method_12832();
    }

    private void validateRecipe(MachineRecipe recipe) {
        if (!this.allowItemInput && recipe.itemInputs.size() > 0) {
            throw new IllegalArgumentException("Item inputs are not allowed.");
        }
        if (!this.allowFluidInput && recipe.fluidInputs.size() > 0) {
            throw new IllegalArgumentException("Fluid inputs are not allowed.");
        }
        if (!this.allowItemOutput && recipe.itemOutputs.size() > 0) {
            throw new IllegalArgumentException("Item outputs are not allowed.");
        }
        if (!this.allowFluidOutput && recipe.fluidOutputs.size() > 0) {
            throw new IllegalArgumentException("Fluid outputs are not allowed.");
        }
        if (recipe.itemInputs.size() + recipe.fluidInputs.size() == 0) {
            throw new IllegalArgumentException("Must have at least one fluid or item input.");
        }
        if (recipe.itemOutputs.size() + recipe.fluidOutputs.size() == 0) {
            throw new IllegalArgumentException("Must have at least one fluid or item output.");
        }
    }

    public MachineRecipe fromJson(class_2960 id, JsonObject json) {
        MachineRecipe recipe = new MachineRecipe(id, this);
        if (this.id.equals((Object)MIMachineRecipeTypes.FORGE_HAMMER.id)) {
            recipe.eu = MachineRecipeType.readNonNegativeInt(json, "eu");
            recipe.duration = MachineRecipeType.readNonNegativeInt(json, "duration");
        } else {
            recipe.eu = MachineRecipeType.readPositiveInt(json, "eu");
            recipe.duration = MachineRecipeType.readPositiveInt(json, "duration");
        }
        recipe.itemInputs = MachineRecipeType.readArray(json, "item_inputs", MachineRecipeType::readItemInput);
        recipe.fluidInputs = MachineRecipeType.readArray(json, "fluid_inputs", MachineRecipeType::readFluidInput);
        recipe.itemOutputs = MachineRecipeType.readArray(json, "item_outputs", MachineRecipeType::readItemOutput);
        recipe.fluidOutputs = MachineRecipeType.readArray(json, "fluid_outputs", MachineRecipeType::readFluidOutput);
        recipe.conditions = MachineRecipeType.readConditions(json);
        this.validateRecipe(recipe);
        return recipe;
    }

    private static int readPositiveInt(JsonObject json, String element) {
        int x = class_3518.method_15260((JsonObject)json, (String)element);
        if (x <= 0) {
            throw new IllegalArgumentException(element + " should be a positive integer.");
        }
        return x;
    }

    private static int readNonNegativeInt(JsonObject json, String element) {
        int x = class_3518.method_15260((JsonObject)json, (String)element);
        if (x < 0) {
            throw new IllegalArgumentException(element + " should be a positive integer.");
        }
        return x;
    }

    private static int readFluidAmount(JsonObject json, String element) {
        double amountMb = class_3518.method_34927((JsonObject)json, (String)element);
        int amount = (int)Math.round(amountMb * 81.0);
        if (amount < 0) {
            throw new IllegalArgumentException(element + " should be a positive fluid amount.");
        }
        return amount;
    }

    private static float readProbability(JsonObject json, String element) {
        if (class_3518.method_15278((JsonObject)json, (String)element)) {
            float x = class_3518.method_15259((JsonObject)json, (String)element);
            if (x < 0.0f || x > 1.0f) {
                throw new IllegalArgumentException(element + " should be a float between 0 and 1.");
            }
            return x;
        }
        return 1.0f;
    }

    private static class_2960 readIdentifier(JsonObject json, String element) {
        return new class_2960(class_3518.method_15265((JsonObject)json, (String)element));
    }

    private static <T> List<T> readArray(JsonObject json, String element, Function<JsonObject, T> reader) {
        if (!class_3518.method_15264((JsonObject)json, (String)element)) {
            JsonElement backupObject = json.get(element);
            if (backupObject != null && backupObject.isJsonObject()) {
                return Arrays.asList(reader.apply(backupObject.getAsJsonObject()));
            }
            return Collections.emptyList();
        }
        JsonArray array = class_3518.method_15261((JsonObject)json, (String)element);
        JsonObject[] objects = new JsonObject[array.size()];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = array.get(i).getAsJsonObject();
        }
        return Arrays.stream(objects).map(reader).collect(Collectors.toList());
    }

    public static MachineRecipe.ItemInput readItemInput(JsonObject json) {
        int amount = 1;
        if (json.has("amount")) {
            amount = MachineRecipeType.readNonNegativeInt(json, "amount");
        } else if (json.has("count")) {
            amount = MachineRecipeType.readNonNegativeInt(json, "count");
        }
        float probability = MachineRecipeType.readProbability(json, "probability");
        class_1856 ingredient = json.has("ingredient") ? class_1856.method_8102((JsonElement)json.get("ingredient")) : class_1856.method_8102((JsonElement)json);
        return new MachineRecipe.ItemInput(ingredient, amount, probability);
    }

    private static MachineRecipe.FluidInput readFluidInput(JsonObject json) {
        class_2960 id = MachineRecipeType.readIdentifier(json, "fluid");
        class_3611 fluid = (class_3611)class_2378.field_11154.method_17966(id).orElseThrow(() -> {
            throw new IllegalArgumentException("Fluid " + id + " does not exist.");
        });
        int amount = MachineRecipeType.readFluidAmount(json, "amount");
        float probability = MachineRecipeType.readProbability(json, "probability");
        return new MachineRecipe.FluidInput(fluid, amount, probability);
    }

    private static MachineRecipe.ItemOutput readItemOutput(JsonObject json) {
        class_2960 id = MachineRecipeType.readIdentifier(json, "item");
        class_1792 item = (class_1792)class_2378.field_11142.method_17966(id).orElseThrow(() -> {
            throw new IllegalArgumentException("Item " + id + " does not exist.");
        });
        int amount = 1;
        if (json.has("amount")) {
            amount = MachineRecipeType.readPositiveInt(json, "amount");
        }
        float probability = MachineRecipeType.readProbability(json, "probability");
        return new MachineRecipe.ItemOutput(item, amount, probability);
    }

    private static MachineRecipe.FluidOutput readFluidOutput(JsonObject json) {
        class_2960 id = MachineRecipeType.readIdentifier(json, "fluid");
        class_3611 fluid = (class_3611)class_2378.field_11154.method_17966(id).orElseThrow(() -> {
            throw new IllegalArgumentException("Fluid " + id + " does not exist.");
        });
        int amount = MachineRecipeType.readFluidAmount(json, "amount");
        float probability = MachineRecipeType.readProbability(json, "probability");
        return new MachineRecipe.FluidOutput(fluid, amount, probability);
    }

    private static List<MachineProcessCondition> readConditions(JsonObject object) {
        if (!object.has("process_conditions")) {
            return List.of();
        }
        JsonArray array = class_3518.method_15261((JsonObject)object, (String)"process_conditions");
        ArrayList<MachineProcessCondition> conditions = new ArrayList<MachineProcessCondition>(array.size());
        for (JsonElement condJson : array) {
            JsonObject obj = condJson.getAsJsonObject();
            class_2960 id = new class_2960(class_3518.method_15265((JsonObject)obj, (String)"id"));
            MachineProcessCondition.Serializer<?> serializer = MachineProcessConditions.get(id);
            if (serializer == null) {
                throw new IllegalArgumentException("Unknown machine process condition " + id);
            }
            conditions.add((MachineProcessCondition)serializer.fromJson(obj));
        }
        return conditions;
    }

    private static <T> List<T> readList(class_2540 buf, Function<class_2540, T> reader) {
        ArrayList<T> l = new ArrayList<T>();
        int size = buf.method_10816();
        for (int i = 0; i < size; ++i) {
            l.add(reader.apply(buf));
        }
        return l;
    }

    private static <T> void writeList(class_2540 buf, List<T> list, BiConsumer<class_2540, T> writer) {
        buf.method_10804(list.size());
        for (T t : list) {
            writer.accept(buf, (class_2540)t);
        }
    }

    public MachineRecipe fromNetwork(class_2960 id, class_2540 buf) {
        MachineRecipe recipe = new MachineRecipe(id, this);
        recipe.eu = buf.method_10816();
        recipe.duration = buf.method_10816();
        recipe.itemInputs = MachineRecipeType.readList(buf, b -> new MachineRecipe.ItemInput(class_1856.method_8086((class_2540)b), b.method_10816(), b.readFloat()));
        recipe.fluidInputs = MachineRecipeType.readList(buf, b -> new MachineRecipe.FluidInput((class_3611)class_2378.field_11154.method_10200(b.method_10816()), b.method_10792(), b.readFloat()));
        recipe.itemOutputs = MachineRecipeType.readList(buf, b -> new MachineRecipe.ItemOutput(class_1792.method_7875((int)b.method_10816()), b.method_10816(), b.readFloat()));
        recipe.fluidOutputs = MachineRecipeType.readList(buf, b -> new MachineRecipe.FluidOutput((class_3611)class_2378.field_11154.method_10200(b.method_10816()), b.method_10792(), b.readFloat()));
        recipe.conditions = MachineRecipeType.readList(buf, b -> {
            MachineProcessCondition.Serializer<?> serializer = MachineProcessConditions.get(b.method_10810());
            String json = b.method_19772();
            return serializer.fromJson(JsonParser.parseString((String)json).getAsJsonObject());
        });
        return recipe;
    }

    public void toNetwork(class_2540 buf, MachineRecipe recipe) {
        buf.method_10804(recipe.eu);
        buf.method_10804(recipe.duration);
        MachineRecipeType.writeList(buf, recipe.itemInputs, (b, i) -> {
            i.ingredient.method_8088(buf);
            buf.method_10804(i.amount);
            buf.writeFloat(i.probability);
        });
        MachineRecipeType.writeList(buf, recipe.fluidInputs, (b, i) -> {
            buf.method_10804(class_2378.field_11154.method_10206((Object)i.fluid));
            buf.method_10791(i.amount);
            buf.writeFloat(i.probability);
        });
        MachineRecipeType.writeList(buf, recipe.itemOutputs, (b, i) -> {
            buf.method_10804(class_1792.method_7880((class_1792)i.item));
            buf.method_10804(i.amount);
            buf.writeFloat(i.probability);
        });
        MachineRecipeType.writeList(buf, recipe.fluidOutputs, (b, i) -> {
            buf.method_10804(class_2378.field_11154.method_10206((Object)i.fluid));
            buf.method_10791(i.amount);
            buf.writeFloat(i.probability);
        });
        MachineRecipeType.writeList(buf, recipe.conditions, (b, cond) -> {
            MachineProcessCondition.Serializer<?> serializer = cond.getSerializer();
            buf.method_10812(MachineProcessConditions.getId(serializer));
            buf.method_10814(serializer.toJson((MachineProcessCondition)MachineRecipeType.cast(cond), true).toString());
        });
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }
}

