/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.class_2561;

public class CustomProcessCondition
implements MachineProcessCondition {
    public static final Serde SERIALIZER = new Serde();
    static final Map<String, Definition> definitions = new HashMap<String, Definition>();
    private final String id;
    private final List<class_2561> description;

    public static void onReload() {
        definitions.clear();
        KubeJSProxy.instance.fireCustomConditionEvent();
    }

    public static void register(String id, BiPredicate<MachineProcessCondition.Context, MachineRecipe> predicate, class_2561 ... description) {
        Objects.requireNonNull(predicate);
        if (definitions.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate custom process condition definition: " + id);
        }
        if (description.length == 0) {
            throw new IllegalArgumentException("Custom process condition must have a description");
        }
        definitions.put(id, new Definition(predicate, List.of(description)));
    }

    public CustomProcessCondition(String id) {
        Definition definition = definitions.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Unknown custom process condition definition: " + id);
        }
        this.id = id;
        this.description = definition.description;
    }

    public CustomProcessCondition(String id, List<class_2561> description) {
        this.id = id;
        this.description = description;
    }

    @Override
    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        return CustomProcessCondition.definitions.get((Object)this.id).predicate.test(context, recipe);
    }

    @Override
    public void appendDescription(List<class_2561> list) {
        list.addAll(this.description);
    }

    @Override
    public MachineProcessCondition.Serializer<?> getSerializer() {
        return SERIALIZER;
    }

    private record Definition(BiPredicate<MachineProcessCondition.Context, MachineRecipe> predicate, List<class_2561> description) {
    }

    private static class Serde
    implements MachineProcessCondition.Serializer<CustomProcessCondition> {
        private Serde() {
        }

        @Override
        public CustomProcessCondition fromJson(JsonObject json) {
            String id = json.get("custom_id").getAsString();
            if (json.has("description")) {
                ArrayList<class_2561> description = new ArrayList<class_2561>();
                for (JsonElement element : json.getAsJsonArray("description")) {
                    description.add((class_2561)class_2561.class_2562.method_10872((JsonElement)element));
                }
                return new CustomProcessCondition(id, description);
            }
            return new CustomProcessCondition(id);
        }

        @Override
        public JsonObject toJson(CustomProcessCondition condition, boolean syncToClient) {
            JsonObject obj = new JsonObject();
            obj.addProperty("custom_id", condition.id);
            if (syncToClient) {
                JsonArray description = new JsonArray();
                for (class_2561 line : condition.description) {
                    description.add(class_2561.class_2562.method_10868((class_2561)line));
                }
                obj.add("description", (JsonElement)description);
            }
            return obj;
        }
    }
}

