/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.blocks.OreBlock;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.part.TextureGenParams;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.materials.set.MaterialOreSet;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2430;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3825;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5843;
import net.minecraft.class_6019;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6806;
import net.minecraft.class_6816;
import net.minecraft.class_6880;

public class OrePart
implements PartKeyProvider {
    public final boolean deepslate;
    public final PartKey key;
    public static final Set<String> GENERATED_MATERIALS = new HashSet<String>();

    @Override
    public PartKey key() {
        return this.key;
    }

    public PartTemplate of(int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.of(new OrePartParams(class_6019.method_35017((int)0, (int)2), set, veinsPerChunk, veinSize, maxYLevel));
    }

    public PartTemplate of(class_6019 xpProvider, int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.of(new OrePartParams(xpProvider, set, veinsPerChunk, veinSize, maxYLevel));
    }

    public PartTemplate of(class_6019 xpProvider, MaterialOreSet set) {
        return this.of(new OrePartParams(xpProvider, set));
    }

    public PartTemplate of(MaterialOreSet set) {
        return this.of(new OrePartParams(class_6019.method_35017((int)0, (int)0), set));
    }

    public OrePart(boolean deepslate) {
        this.key = new PartKey(deepslate ? "ore_deepslate" : "ore");
        this.deepslate = deepslate;
    }

    public PartTemplate of(OrePartParams oreParams) {
        return new PartTemplate(this.deepslate ? "Deepslate %s Ore" : "Ore", this.key).withRegister((partContext, part, itemPath, itemId, itemTag, englishName) -> {
            String loot;
            PartKey mainPartKey = partContext.get(MaterialProperty.MAIN_PART).key();
            if (mainPartKey.equals(MIParts.INGOT.key())) {
                loot = partContext.getMaterialPart(MIParts.RAW_METAL).getItemId();
            } else if (mainPartKey.equals(MIParts.DUST.key())) {
                loot = partContext.getMaterialPart(MIParts.DUST).getItemId();
            } else if (mainPartKey.equals(MIParts.GEM.key())) {
                loot = partContext.getMaterialPart(MIParts.GEM).getItemId();
            } else {
                throw new UnsupportedOperationException("Could not find matching main part.");
            }
            BlockDefinition<OreBlock> oreBlockBlockDefinition = MIBlock.block(englishName, itemPath, MIBlock.BlockDefinitionParams.of(ModernIndustrialization.STONE_MATERIAL).withBlockConstructor(s -> new OreBlock((class_4970.class_2251)s, oreParams, partContext.getMaterialName())).withLootTable((block, lootGenerator) -> lootGenerator.method_16258(block, class_2430.method_10377((class_2248)block, (class_1792)((class_1792)class_2378.field_11142.method_10223(new class_2960(loot)))))).addMoreTags(List.of(ConventionalBlockTags.ORES)).sortOrder(SortOrder.ORES.and((Comparable)((Object)partContext.getMaterialName()))).method_36557(this.deepslate ? 4.5f : 3.0f).method_36558(3.0f).method_9626(this.deepslate ? class_2498.field_29033 : class_2498.field_11544), OreBlock.class);
            if (mainPartKey.equals(MIParts.INGOT.key()) != (oreParams.xpDropped.method_35011() == 0)) {
                throw new IllegalArgumentException("Mismatch between raw ore and xp drops for material: " + partContext.getMaterialName());
            }
            String tag = "c:" + partContext.getMaterialName() + "_ores";
            TagsToGenerate.generateTag(tag, oreBlockBlockDefinition.method_8389(), partContext.getMaterialEnglishName() + " Ores");
            TagsToGenerate.addTagToTag(tag, ConventionalItemTags.ORES.comp_327().toString(), "Ores");
            MIConfig config = MIConfig.getConfig();
            if (oreParams.generate) {
                GENERATED_MATERIALS.add(partContext.getMaterialName());
                if (config.generateOres && !config.blacklistedOres.contains(partContext.getMaterialName())) {
                    MIIdentifier oreGenId = new MIIdentifier((this.deepslate ? "deepslate_" : "") + "ore_generator_" + partContext.getMaterialName());
                    ImmutableList target = ImmutableList.of((Object)class_3124.method_33994((class_3825)(this.deepslate ? class_6806.field_35859 : class_6806.field_35858), (class_2680)oreBlockBlockDefinition.asBlock().method_9564()));
                    class_6880 configuredOreGen = class_5458.method_30562((class_2378)class_5458.field_25929, (class_2960)oreGenId, (Object)new class_2975(class_3031.field_13517, (class_3037)new class_3124((List)target, oreParams.veinSize)));
                    class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)oreGenId, (Object)new class_6796(configuredOreGen, class_6816.method_39732((int)oreParams.veinsPerChunk, (class_6797)class_6795.method_39634((class_5843)class_5843.method_33840(), (class_5843)class_5843.method_33841((int)oreParams.maxYLevel)))));
                    class_5321 featureKey = class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)oreGenId);
                    BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13176, (class_5321)featureKey);
                }
            }
        }).withTexture(new TextureGenParams.Ore(this.deepslate, oreParams.set)).withCustomPath((this.deepslate ? "deepslate_" : "") + "%s_ore", "%s_ores");
    }

    public List<PartTemplate> ofAll(OrePartParams params) {
        return List.of(MIParts.ORE_DEEPSLATE.of(params), MIParts.ORE.of(params));
    }

    public List<PartTemplate> ofAll(class_6019 xpProvider, int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.ofAll(new OrePartParams(xpProvider, set, veinsPerChunk, veinSize, maxYLevel));
    }

    public List<PartTemplate> ofAll(int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.ofAll(new OrePartParams(class_6019.method_35017((int)0, (int)0), set, veinsPerChunk, veinSize, maxYLevel));
    }

    public static class OrePartParams {
        public final class_6019 xpDropped;
        public final MaterialOreSet set;
        public final boolean generate;
        public final int veinsPerChunk;
        public final int veinSize;
        public final int maxYLevel;

        private OrePartParams(class_6019 xpDropped, MaterialOreSet set, boolean generate, int veinsPerChunk, int veinSize, int maxYLevel) {
            this.xpDropped = xpDropped;
            this.set = set;
            this.generate = generate;
            this.veinsPerChunk = veinsPerChunk;
            this.veinSize = veinSize;
            this.maxYLevel = maxYLevel;
        }

        public OrePartParams(class_6019 xpDropped, MaterialOreSet set) {
            this(xpDropped, set, false, 0, 0, 0);
        }

        public OrePartParams(class_6019 xpDropped, MaterialOreSet set, int veinsPerChunk, int veinSize, int maxYLevel) {
            this(xpDropped, set, true, veinsPerChunk, veinSize, maxYLevel);
        }
    }
}

