/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.blocks.storage.tank.AbstractTankBlockEntity;
import aztech.modern_industrialization.blocks.storage.tank.TankBlock;
import aztech.modern_industrialization.blocks.storage.tank.TankBlockEntity;
import aztech.modern_industrialization.blocks.storage.tank.TankItem;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.PartEnglishNameFormatter;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.part.TextureGenParams;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.proxy.CommonProxy;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2343;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class TankPart
implements PartKeyProvider {
    public static final BiConsumer<class_2248, class_4910> MODEL_GENERATOR = (block, gen) -> {
        class_4945 textureSlot = class_4945.method_27043((String)"0");
        class_4944 mapping = class_4944.method_25883((class_4945)textureSlot, (class_2960)new MIIdentifier("block/" + class_2378.field_11146.method_10221(block).method_12832()));
        gen.method_35868(block, mapping, new class_4942(Optional.of(new MIIdentifier("base/tank")), Optional.empty(), new class_4945[]{textureSlot}));
    };

    @Override
    public PartKey key() {
        return new PartKey("tank");
    }

    public PartTemplate of(String nameOverride, String path, int bucketCapacity) {
        return this.of(new PartEnglishNameFormatter.Overridden(nameOverride), bucketCapacity, path);
    }

    public PartTemplate of(long bucketCapacity) {
        return this.of(new PartEnglishNameFormatter.Default("Tank"), bucketCapacity, null);
    }

    public PartTemplate of(PartEnglishNameFormatter englishNameFormatter, long bucketCapacity, @Nullable String maybePathOverridden) {
        MutableObject bet = new MutableObject();
        long capacity = 81000L * bucketCapacity;
        PartTemplate tank = new PartTemplate(englishNameFormatter, this.key()).asBlock(SortOrder.TANKS, new TextureGenParams.SimpleRecoloredBlock()).withRegister((partContext, part, itemPath, itemId, itemTag, englishName) -> {
            StorageBehaviour tankStorageBehaviour = StorageBehaviour.uniformQuantity(capacity);
            class_2343 factory = (pos, state) -> new TankBlockEntity((class_2591)bet.getValue(), pos, state);
            BlockDefinition<TankBlock> blockDefinition = MIBlock.block(englishName, itemPath, MIBlock.BlockDefinitionParams.of().withBlockConstructor(s -> new TankBlock(factory, tankStorageBehaviour)).withBlockItemConstructor(TankItem::new).withModel(MODEL_GENERATOR).withBlockEntityRendererItemModel().noLootTable().sortOrder(SortOrder.TANKS.and(Long.valueOf(bucketCapacity))));
            TankBlock block = blockDefinition.asBlock();
            TankItem item = (TankItem)blockDefinition.method_8389();
            TagsToGenerate.generateTag(MITags.TANKS, (class_1792)item, "Tanks");
            bet.setValue((Object)((class_2591)class_2378.method_10226((class_2378)class_2378.field_11137, (String)itemId, (Object)FabricBlockEntityTypeBuilder.create((arg_0, arg_1) -> ((class_2343)block.factory).method_10123(arg_0, arg_1), (class_2248[])new class_2248[]{block}).build(null))));
            FluidStorage.SIDED.registerSelf(new class_2591[]{(class_2591)bet.getValue()});
            item.registerItemApi();
            CommonProxy.INSTANCE.registerPartTankClient(block, (class_1792)item, partContext.getMaterialName(), itemPath, (class_2591<AbstractTankBlockEntity>)((class_2591)bet.getValue()), partContext.get(MaterialProperty.MEAN_RGB));
        });
        if (maybePathOverridden != null) {
            tank = tank.withCustomPath(maybePathOverridden);
        }
        return tank;
    }
}

