/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.nuclear.FluidNuclearComponent;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.NeutronType;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public interface INuclearTileData {
    public double getTemperature();

    public double getHeatTransferCoeff();

    public double getMeanNeutronAbsorption(NeutronType var1);

    public double getMeanNeutronFlux(NeutronType var1);

    public double getMeanNeutronGeneration();

    public double getMeanEuGeneration();

    public TransferVariant getVariant();

    public long getVariantAmount();

    public boolean isFluid();

    @Nullable
    default public INuclearComponent<?> getComponent() {
        FluidVariant resource;
        TransferVariant variant = this.getVariant();
        if (variant instanceof ItemVariant) {
            class_1792 class_17922;
            ItemVariant resource2 = (ItemVariant)variant;
            if (!variant.isBlank() && this.getVariantAmount() > 0L && (class_17922 = resource2.getItem()) instanceof INuclearComponent) {
                INuclearComponent comp = (INuclearComponent)class_17922;
                return comp;
            }
        } else if (variant instanceof FluidVariant && !(resource = (FluidVariant)variant).isBlank() && this.getVariantAmount() > 0L) {
            return FluidNuclearComponent.get(resource.getFluid());
        }
        return null;
    }

    public static void write(Optional<INuclearTileData> maybeData, class_2540 buf) {
        if (maybeData.isPresent()) {
            INuclearTileData tile = maybeData.get();
            buf.writeBoolean(true);
            buf.writeDouble(tile.getTemperature());
            buf.writeDouble(tile.getMeanNeutronAbsorption(NeutronType.FAST));
            buf.writeDouble(tile.getMeanNeutronAbsorption(NeutronType.THERMAL));
            buf.writeDouble(tile.getMeanNeutronFlux(NeutronType.FAST));
            buf.writeDouble(tile.getMeanNeutronFlux(NeutronType.THERMAL));
            buf.writeDouble(tile.getMeanNeutronGeneration());
            buf.writeDouble(tile.getHeatTransferCoeff());
            buf.writeDouble(tile.getMeanEuGeneration());
            buf.writeBoolean(!tile.isFluid());
            buf.method_10794(tile.getVariant().toNbt());
            buf.writeLong(tile.getVariantAmount());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static Optional<INuclearTileData> read(class_2540 buf) {
        boolean isPresent = buf.readBoolean();
        if (isPresent) {
            final double temperature = buf.readDouble();
            final double meanFastNeutronAbsorption = buf.readDouble();
            final double meanThermalNeutronAbsorption = buf.readDouble();
            final double meanFastNeutronFlux = buf.readDouble();
            final double meanThermalNeutronFlux = buf.readDouble();
            final double meanNeutronGeneration = buf.readDouble();
            final double heatTransferCoeff = buf.readDouble();
            final double euGeneration = buf.readDouble();
            boolean isItem = buf.readBoolean();
            ItemVariant variant = isItem ? ItemVariant.fromNbt((class_2487)buf.method_10798()) : FluidVariant.fromNbt((class_2487)buf.method_10798());
            long amount = buf.readLong();
            return Optional.of(new INuclearTileData(){
                final /* synthetic */ TransferVariant val$variant;
                final /* synthetic */ long val$amount;
                final /* synthetic */ boolean val$isItem;
                {
                    this.val$variant = transferVariant;
                    this.val$amount = l;
                    this.val$isItem = bl;
                }

                @Override
                public double getTemperature() {
                    return temperature;
                }

                @Override
                public double getHeatTransferCoeff() {
                    return heatTransferCoeff;
                }

                @Override
                public double getMeanNeutronAbsorption(NeutronType type) {
                    if (type == NeutronType.FAST) {
                        return meanFastNeutronAbsorption;
                    }
                    if (type == NeutronType.THERMAL) {
                        return meanThermalNeutronAbsorption;
                    }
                    return meanThermalNeutronAbsorption + meanFastNeutronAbsorption;
                }

                @Override
                public double getMeanNeutronFlux(NeutronType type) {
                    if (type == NeutronType.FAST) {
                        return meanFastNeutronFlux;
                    }
                    if (type == NeutronType.THERMAL) {
                        return meanThermalNeutronFlux;
                    }
                    return meanFastNeutronFlux + meanThermalNeutronFlux;
                }

                @Override
                public double getMeanNeutronGeneration() {
                    return meanNeutronGeneration;
                }

                @Override
                public double getMeanEuGeneration() {
                    return euGeneration;
                }

                @Override
                public TransferVariant getVariant() {
                    return this.val$variant;
                }

                @Override
                public long getVariantAmount() {
                    return this.val$amount;
                }

                @Override
                public boolean isFluid() {
                    return !this.val$isItem;
                }
            });
        }
        return Optional.empty();
    }

    public static boolean areEquals(Optional<INuclearTileData> a, Optional<INuclearTileData> b) {
        if (a.isPresent() != b.isPresent()) {
            return false;
        }
        if (a.isPresent()) {
            INuclearTileData A = a.get();
            INuclearTileData B = b.get();
            for (NeutronType type : NeutronType.TYPES) {
                if (A.getMeanNeutronAbsorption(type) != B.getMeanNeutronAbsorption(type)) {
                    return false;
                }
                if (A.getMeanNeutronFlux(type) == B.getMeanNeutronFlux(type)) continue;
                return false;
            }
            return A.getTemperature() == B.getTemperature() && A.getHeatTransferCoeff() == B.getTemperature() && A.getVariantAmount() == B.getVariantAmount() && A.getMeanNeutronGeneration() == B.getMeanNeutronGeneration() && A.getVariant().equals(B.getVariant()) && A.getMeanEuGeneration() == B.getMeanEuGeneration();
        }
        return true;
    }
}

