/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.fluid;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.ReiDraggable;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.pipes.fluid.FluidPipeInterface;
import aztech.modern_industrialization.pipes.fluid.FluidPipeScreenHandler;
import aztech.modern_industrialization.pipes.gui.PipeScreen;
import aztech.modern_industrialization.pipes.impl.PipePackets;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.RenderHelper;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class FluidPipeScreen
extends PipeScreen<FluidPipeScreenHandler> {
    private static final class_2960 TEXTURE = new MIIdentifier("textures/gui/pipe/fluid.png");

    public FluidPipeScreen(FluidPipeScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title, 153);
    }

    protected void method_25426() {
        super.method_25426();
        this.addNetworkFluidButton();
        this.addConnectionTypeButton(148, 22, ((FluidPipeScreenHandler)this.field_2797).iface);
        this.addPriorityWidgets(33, 42, ((FluidPipeScreenHandler)this.field_2797).iface, "transfer", 0);
    }

    @Override
    protected class_2960 getBackgroundTexture() {
        return TEXTURE;
    }

    private void addNetworkFluidButton() {
        this.method_37063((class_364)new NetworkFluidButton(72 + this.field_2776, 20 + this.field_2800, widget -> this.updateNetworkFluid(), (button, matrices, mouseX, mouseY) -> {
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.add(FluidHelper.getFluidName(((FluidPipeScreenHandler)this.field_2797).iface.getNetworkFluid(), false));
            if (!((FluidPipeScreenHandler)this.field_2797).iface.getNetworkFluid().isBlank()) {
                lines.add(MIText.NetworkFluidHelpClear.text().method_10862(TextHelper.GRAY_TEXT));
            } else {
                lines.add(MIText.NetworkFluidHelpSet.text().method_10862(TextHelper.GRAY_TEXT));
            }
            this.method_30901(matrices, lines, mouseX, mouseY);
        }, ((FluidPipeScreenHandler)this.field_2797).iface));
    }

    private void updateNetworkFluid() {
        FluidPipeInterface iface = ((FluidPipeScreenHandler)this.field_2797).iface;
        FluidVariant targetFluid = null;
        if (iface.getNetworkFluid().isBlank()) {
            FluidVariant fluid = (FluidVariant)StorageUtil.findStoredResource((Storage)((Storage)ContainerItemContext.ofPlayerCursor((class_1657)this.field_22787.field_1724, (class_1703)this.field_2797).find(FluidStorage.ITEM)));
            if (fluid != null && !fluid.isBlank()) {
                targetFluid = fluid;
            }
        } else if (FluidPipeScreen.method_25442()) {
            targetFluid = FluidVariant.blank();
        }
        if (targetFluid != null) {
            this.setNetworkFluid(targetFluid);
        }
    }

    private void setNetworkFluid(FluidVariant fluidKey) {
        ((FluidPipeScreenHandler)this.field_2797).iface.setNetworkFluid(fluidKey);
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(((FluidPipeScreenHandler)this.field_2797).field_7763);
        fluidKey.toPacket(buf);
        ClientPlayNetworking.send((class_2960)PipePackets.SET_NETWORK_FLUID, (class_2540)buf);
    }

    @Environment(value=EnvType.CLIENT)
    private class NetworkFluidButton
    extends class_4185
    implements ReiDraggable {
        private final FluidPipeInterface iface;

        public NetworkFluidButton(int x, int y, class_4185.class_4241 onPress, class_4185.class_5316 tooltipSupplier, FluidPipeInterface iface) {
            super(x, y, 16, 16, null, onPress, tooltipSupplier);
            this.iface = iface;
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreen.SLOT_ATLAS);
            this.method_25302(matrices, this.field_22760 - 1, this.field_22761 - 1, 18, 0, 18, 18);
            if (!this.iface.getNetworkFluid().isBlank()) {
                RenderHelper.drawFluidInGui(matrices, this.iface.getNetworkFluid(), this.field_22760, this.field_22761);
            }
            if (this.method_25367()) {
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.method_25296(matrices, this.field_22760, this.field_22761, this.field_22760 + 16, this.field_22761 + 16, -2130706433, -2130706433);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                RenderSystem.enableDepthTest();
            }
            if (this.method_25367()) {
                this.method_25352(matrices, mouseX, mouseY);
            }
        }

        @Override
        public boolean dragFluid(FluidVariant fluidKey, Simulation simulation) {
            if (simulation.isActing()) {
                FluidPipeScreen.this.setNetworkFluid(fluidKey);
            }
            return true;
        }

        @Override
        public boolean dragItem(ItemVariant itemKey, Simulation simulation) {
            return false;
        }
    }
}

