/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.FastBlockEntity;
import aztech.modern_industrialization.api.WrenchableBlockEntity;
import aztech.modern_industrialization.items.ConfigCardItem;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.gui.IPipeScreenHandlerHelper;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.pipes.impl.PipePartBuilder;
import aztech.modern_industrialization.pipes.impl.PipeShapeBuilder;
import aztech.modern_industrialization.pipes.impl.PipeVoxelShape;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.WorldHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class PipeBlockEntity
extends FastBlockEntity
implements IPipeScreenHandlerHelper,
RenderAttachmentBlockEntity,
WrenchableBlockEntity {
    private static final int MAX_PIPES = 3;
    private static final class_265[][][] SHAPE_CACHE = new class_265[3][6][5];
    private static final class_265[] ME_WIRE_CONNECTOR_SHAPES;
    static final class_265 DEFAULT_SHAPE;
    class_265 currentCollisionShape = class_259.method_1073();
    private final SortedSet<PipeNetworkNode> pipes = new TreeSet<PipeNetworkNode>(Comparator.comparing(PipeNetworkNode::getType));
    SortedMap<PipeNetworkType, PipeEndpointType[]> connections = new TreeMap<PipeNetworkType, PipeEndpointType[]>();
    SortedMap<PipeNetworkType, class_2487> customData = new TreeMap<PipeNetworkType, class_2487>();
    @Nullable
    class_2680 camouflage = null;
    private final List<class_3545<PipeNetworkType, PipeNetworkNode>> unloadedPipes = new ArrayList<class_3545<PipeNetworkType, PipeNetworkNode>>();
    boolean stateReplaced = false;

    public void loadPipes() {
        if (this.field_11863.field_9236 || this.unloadedPipes.size() == 0) {
            return;
        }
        for (class_3545<PipeNetworkType, PipeNetworkNode> unloaded : this.unloadedPipes) {
            PipeNetworks.get((class_3218)this.field_11863).getManager((PipeNetworkType)unloaded.method_15442()).nodeLoaded((PipeNetworkNode)unloaded.method_15441(), this.field_11867);
            this.pipes.add((PipeNetworkNode)unloaded.method_15441());
        }
        this.unloadedPipes.clear();
        this.updateConnections();
    }

    public PipeBlockEntity(class_2338 pos, class_2680 state) {
        super(MIPipes.BLOCK_ENTITY_TYPE_PIPE, pos, state);
    }

    void updateConnections() {
        this.loadPipes();
        for (PipeNetworkNode pipe : this.pipes) {
            pipe.updateConnections(this.field_11863, this.field_11867);
        }
        this.onConnectionsChanged();
    }

    public SortedSet<PipeNetworkNode> getNodes() {
        this.loadPipes();
        return Collections.unmodifiableSortedSet(this.pipes);
    }

    boolean canAddPipe(PipeNetworkType type) {
        this.loadPipes();
        if (this.field_11863.field_9236) {
            return this.connections.size() < 3 && !this.connections.containsKey(type);
        }
        if (this.pipes.size() == 3) {
            return false;
        }
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            return false;
        }
        return true;
    }

    void addPipe(PipeNetworkType type, PipeNetworkData data) {
        if (!this.canAddPipe(type)) {
            return;
        }
        PipeNetworkNode node = type.getNodeCtor().get();
        PipeNetworkManager manager = PipeNetworks.get((class_3218)this.field_11863).getManager(type);
        manager.addNode(node, this.field_11867, data);
        for (class_2350 direction : class_2350.values()) {
            manager.addLink(this.field_11867, direction, false);
        }
        this.pipes.add(node);
        node.buildInitialConnections(this.field_11863, this.field_11867);
        this.updateConnections();
    }

    public void removePipeAndDropContainedItems(PipeNetworkType type) {
        this.loadPipes();
        PipeNetworkNode removedPipe = null;
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            removedPipe = pipe;
            break;
        }
        if (removedPipe == null) {
            throw new IllegalArgumentException("Can't remove type " + type.getIdentifier() + " from BlockEntity at pos " + this.field_11867);
        }
        this.pipes.remove(removedPipe);
        removedPipe.getManager().removeNode(this.field_11867);
        this.onConnectionsChanged();
        ArrayList<class_1799> droppedStacks = new ArrayList<class_1799>();
        removedPipe.appendDroppedStacks(droppedStacks);
        for (class_1799 droppedStack : droppedStacks) {
            this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), droppedStack));
        }
    }

    public void removeConnection(PipeNetworkType type, class_2350 direction) {
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            pipe.removeConnection(this.field_11863, this.field_11867, direction);
            pipe.getManager().removeLink(this.field_11867, direction);
            this.onConnectionsChanged();
            return;
        }
    }

    public void addConnection(class_1657 player, PipeNetworkType type, class_2350 direction) {
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            pipe.addConnection(this, player, this.field_11863, this.field_11867, direction);
            pipe.getManager().addLink(this.field_11867, direction, true);
            pipe.updateConnections(this.field_11863, this.field_11867);
            this.onConnectionsChanged();
            return;
        }
    }

    public boolean hasCamouflage() {
        return this.camouflage != null;
    }

    public class_1799 getCamouflageStack() {
        Objects.requireNonNull(this.camouflage, "Can't get camouflage stack when there is no camouflage");
        return new class_1799((class_1935)this.camouflage.method_26204());
    }

    private void setCamouflage(class_1657 player, @Nullable class_2680 newCamouflage) {
        class_3414 sound;
        class_2498 group;
        boolean hadCamouflage = this.hasCamouflage();
        if (this.camouflage != null) {
            if (newCamouflage == null || newCamouflage.method_26204() != this.camouflage.method_26204()) {
                class_2338 pos = this.field_11867;
                class_1264.method_5449((class_1937)this.field_11863, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)this.getCamouflageStack());
            }
            if (newCamouflage == null) {
                group = this.camouflage.method_26231();
                sound = group.method_10595();
                this.field_11863.method_8396(player, this.field_11867, sound, class_3419.field_15245, (group.method_10597() + 1.0f) / 4.0f, group.method_10599() * 0.8f);
            }
            this.camouflage = null;
            this.method_5431();
            if (!this.field_11863.method_8608()) {
                this.sync();
                this.rebuildCollisionShape();
            }
        }
        this.camouflage = newCamouflage;
        if (newCamouflage != null) {
            group = newCamouflage.method_26231();
            sound = group.method_10598();
            this.field_11863.method_8396(player, this.field_11867, sound, class_3419.field_15245, (group.method_10597() + 1.0f) / 4.0f, group.method_10599() * 0.8f);
            this.method_5431();
            if (!this.field_11863.method_8608()) {
                this.sync();
                this.rebuildCollisionShape();
            }
        }
        if (hadCamouflage != this.hasCamouflage()) {
            class_2680 newState = (class_2680)this.method_11010().method_11657((class_2769)PipeBlock.CAMOUFLAGED, (Comparable)Boolean.valueOf(this.hasCamouflage()));
            if (this.hasCamouflage()) {
                newState = (class_2680)newState.method_11657((class_2769)PipeBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            this.field_11863.method_8501(this.field_11867, newState);
        }
    }

    public boolean tryRemoveCamouflage(class_1657 player, class_1268 hand) {
        class_1799 handStack = player.method_5998(hand);
        if (this.camouflage == null || !handStack.method_31573(MITags.WRENCHES)) {
            return false;
        }
        this.setCamouflage(player, null);
        return true;
    }

    public boolean tryApplyCamouflage(class_1657 player, class_1268 hand) {
        boolean itemChanged;
        class_1799 handStack = player.method_5998(hand);
        if (!MIItem.CONFIG_CARD.is(handStack)) {
            return false;
        }
        if (player.method_5715()) {
            if (this.camouflage != null) {
                return ConfigCardItem.setCamouflage(player, hand, this.camouflage);
            }
            return false;
        }
        class_2680 newCamouflage = ConfigCardItem.readCamouflage(handStack);
        if (newCamouflage.method_26215()) {
            return false;
        }
        if (newCamouflage == this.camouflage) {
            return true;
        }
        boolean bl = itemChanged = this.camouflage == null || newCamouflage.method_26204() != this.camouflage.method_26204();
        if (!player.method_31549().field_7477 && itemChanged) {
            class_1792 itemToUse = newCamouflage.method_26204().method_8389();
            PlayerInventoryStorage inv = PlayerInventoryStorage.of((class_1657)player);
            ItemVariant toExtract = (ItemVariant)StorageUtil.findExtractableResource((Storage)inv, v -> v.isOf((Object)itemToUse), null);
            try (Transaction tx = Transaction.openOuter();){
                if (toExtract == null || inv.extract((Object)toExtract, 1L, (TransactionContext)tx) != 1L) {
                    player.method_7353((class_2561)MITooltips.line(MIText.ConfigCardNoCamouflageInInventory).arg(newCamouflage, MITooltips.BLOCK_STATE_PARSER).build().method_27692(class_124.field_1061), true);
                    boolean bl2 = true;
                    return bl2;
                }
                tx.commit();
            }
        }
        this.setCamouflage(player, newCamouflage);
        return true;
    }

    public boolean customUse(PipeVoxelShape shape, class_1657 player, class_1268 hand) {
        for (PipeNetworkNode node : this.pipes) {
            if (node.getType() != shape.type) continue;
            return node.customUse(this, player, hand, shape.direction);
        }
        return false;
    }

    public ExtendedScreenHandlerFactory getGui(PipeNetworkType type, class_2350 direction) {
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            return pipe.getConnectionGui(direction, this);
        }
        return null;
    }

    public void method_11012() {
        if (this.stateReplaced) {
            this.loadPipes();
            for (PipeNetworkNode pipe : this.pipes) {
                pipe.getManager().removeNode(this.field_11867);
            }
        } else {
            for (PipeNetworkNode pipe : this.pipes) {
                pipe.onUnload();
                pipe.getManager().nodeUnloaded(pipe, this.field_11867);
            }
        }
        super.method_11012();
    }

    public void method_11007(class_2487 tag) {
        int i = 0;
        for (PipeNetworkNode pipeNetworkNode : this.pipes) {
            tag.method_10582("pipe_type_" + i, pipeNetworkNode.getType().getIdentifier().toString());
            tag.method_10566("pipe_data_" + i, (class_2520)pipeNetworkNode.toTag(new class_2487()));
            ++i;
        }
        for (class_3545 class_35452 : this.unloadedPipes) {
            tag.method_10582("pipe_type_" + i, ((PipeNetworkType)class_35452.method_15442()).getIdentifier().toString());
            tag.method_10566("pipe_data_" + i, (class_2520)((PipeNetworkNode)class_35452.method_15441()).toTag(new class_2487()));
            ++i;
        }
        if (this.camouflage != null) {
            tag.method_10566("camouflage", (class_2520)class_2512.method_10686((class_2680)this.camouflage));
        }
    }

    public void method_11014(class_2487 tag) {
        class_2680 class_26802 = this.camouflage = tag.method_10545("camouflage") ? class_2512.method_10681((class_2487)tag.method_10562("camouflage")) : null;
        if (!tag.method_10545("pipes")) {
            this.pipes.clear();
            int i = 0;
            while (tag.method_10545("pipe_type_" + i)) {
                class_2960 typeId = new class_2960(tag.method_10558("pipe_type_" + i));
                PipeNetworkType type = PipeNetworkType.get(typeId);
                PipeNetworkNode node = type.getNodeCtor().get();
                node.fromTag(tag.method_10562("pipe_data_" + i));
                this.unloadedPipes.add((class_3545<PipeNetworkType, PipeNetworkNode>)new class_3545((Object)type, (Object)node));
                ++i;
            }
        } else {
            this.connections.clear();
            this.customData.clear();
            class_2487 pipesTag = tag.method_10562("pipes");
            for (String key : pipesTag.method_10541()) {
                class_2487 nodeTag = pipesTag.method_10562(key);
                PipeNetworkType type = PipeNetworkType.get(new class_2960(key));
                this.connections.put(type, NbtHelper.decodeConnections(nodeTag.method_10547("connections")));
                this.customData.put(type, nodeTag.method_10562("custom").method_10553());
            }
            this.rebuildCollisionShape();
            WorldHelper.forceChunkRemesh(this.field_11863, this.field_11867);
        }
    }

    public void method_10996() {
        PipeNetworks.scheduleLoadPipe(this.field_11863, this);
    }

    public void onConnectionsChanged() {
        SortedMap<PipeNetworkType, PipeEndpointType[]> oldRendererConnections = this.connections;
        this.connections = new TreeMap<PipeNetworkType, PipeEndpointType[]>();
        for (PipeNetworkNode pipe : this.pipes) {
            this.connections.put(pipe.getType(), pipe.getConnections(this.field_11867));
        }
        if (!this.connections.equals(oldRendererConnections)) {
            this.rebuildCollisionShape();
            this.sync();
        }
        this.method_5431();
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.loadPipes();
        class_2487 pipesTag = new class_2487();
        for (PipeNetworkNode pipe : this.pipes) {
            class_2487 nodeTag = new class_2487();
            nodeTag.method_10566("custom", (class_2520)pipe.writeCustomData());
            nodeTag.method_10570("connections", NbtHelper.encodeConnections(pipe.getConnections(this.field_11867)));
            pipesTag.method_10566(pipe.getType().getIdentifier().toString(), (class_2520)nodeTag);
        }
        tag.method_10566("pipes", (class_2520)pipesTag);
        if (this.camouflage != null) {
            tag.method_10566("camouflage", (class_2520)class_2512.method_10686((class_2680)this.camouflage));
        }
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public Object getRenderAttachmentData() {
        PipeNetworkType[] types = new PipeNetworkType[this.connections.size()];
        PipeEndpointType[][] renderedConnections = new PipeEndpointType[this.connections.size()][];
        class_2487[] customData = new class_2487[this.connections.size()];
        int i = 0;
        for (Map.Entry<PipeNetworkType, PipeEndpointType[]> entry : this.connections.entrySet()) {
            types[i] = entry.getKey();
            renderedConnections[i] = Arrays.copyOf(entry.getValue(), 6);
            customData[i] = (class_2487)this.customData.get(entry.getKey());
            ++i;
        }
        return new RenderAttachment(this.camouflage, types, renderedConnections, customData);
    }

    @Override
    public void callSync() {
        this.sync();
    }

    @Override
    public void callMarkDirty() {
        this.method_5431();
    }

    @Override
    public boolean isWithinUseDistance(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @Override
    public boolean doesNodeStillExist(PipeNetworkNode node) {
        return this.pipes.contains(node);
    }

    @Override
    public boolean useWrench(class_1657 player, class_1268 hand, class_3965 hitResult) {
        return PipeBlock.useWrench(this, player, hand, hitResult);
    }

    public Collection<PipeVoxelShape> getPartShapes() {
        ArrayList<PipeVoxelShape> shapes = new ArrayList<PipeVoxelShape>();
        PipeEndpointType[][] renderedConnections = new PipeEndpointType[this.connections.size()][];
        PipeNetworkType[] types = new PipeNetworkType[this.connections.size()];
        int slot = 0;
        for (Map.Entry<PipeNetworkType, PipeEndpointType[]> connections : this.connections.entrySet()) {
            renderedConnections[slot] = connections.getValue();
            types[slot] = connections.getKey();
            ++slot;
        }
        for (slot = 0; slot < renderedConnections.length; ++slot) {
            shapes.add(new PipeVoxelShape(SHAPE_CACHE[slot][class_2350.field_11043.method_10146()][0], types[slot], null, false));
            for (class_2350 direction : class_2350.values()) {
                int connectionType = PipePartBuilder.getRenderType(slot, direction, renderedConnections);
                if (connectionType == 0) continue;
                PipeEndpointType connType = renderedConnections[slot][direction.method_10146()];
                boolean opensGui = connType != null && connType != PipeEndpointType.PIPE && types[slot].opensGui();
                shapes.add(new PipeVoxelShape(SHAPE_CACHE[slot][direction.method_10146()][connectionType], types[slot], direction, opensGui));
            }
        }
        return shapes;
    }

    private void rebuildCollisionShape() {
        if (this.camouflage != null) {
            this.currentCollisionShape = class_259.method_1077();
        } else {
            this.currentCollisionShape = this.getPartShapes().stream().map(vs -> vs.shape).reduce(class_259.method_1073(), class_259::method_1084);
            for (class_2350 direction : class_2350.values()) {
                boolean renderConnector = false;
                for (Map.Entry<PipeNetworkType, PipeEndpointType[]> entry : this.connections.entrySet()) {
                    PipeEndpointType conn = entry.getValue()[direction.method_10146()];
                    if (conn != PipeEndpointType.BLOCK || !entry.getKey().getIdentifier().method_12832().endsWith("me_wire")) continue;
                    renderConnector = true;
                }
                if (!renderConnector) continue;
                this.currentCollisionShape = class_259.method_1084((class_265)this.currentCollisionShape, (class_265)ME_WIRE_CONNECTOR_SHAPES[direction.method_10146()]);
            }
            this.currentCollisionShape = this.currentCollisionShape.method_1097();
        }
    }

    public static class_265[] buildSideShapes(double connectorSide, double connectorDepth) {
        double connectorSideStart = (1.0 - connectorSide) / 2.0;
        double connectorSideEnd = connectorSideStart + connectorSide;
        return new class_265[]{class_259.method_1081((double)connectorSideStart, (double)0.0, (double)connectorSideStart, (double)connectorSideEnd, (double)connectorDepth, (double)connectorSideEnd), class_259.method_1081((double)connectorSideStart, (double)(1.0 - connectorDepth), (double)connectorSideStart, (double)connectorSideEnd, (double)1.0, (double)connectorSideEnd), class_259.method_1081((double)connectorSideStart, (double)connectorSideStart, (double)0.0, (double)connectorSideEnd, (double)connectorSideEnd, (double)connectorDepth), class_259.method_1081((double)connectorSideStart, (double)connectorSideStart, (double)(1.0 - connectorDepth), (double)connectorSideEnd, (double)connectorSideEnd, (double)1.0), class_259.method_1081((double)0.0, (double)connectorSideStart, (double)connectorSideStart, (double)connectorDepth, (double)connectorSideEnd, (double)connectorSideEnd), class_259.method_1081((double)(1.0 - connectorDepth), (double)connectorSideStart, (double)connectorSideStart, (double)1.0, (double)connectorSideEnd, (double)connectorSideEnd)};
    }

    private static void validateShapes() {
        int intersectingConfigurations = 0;
        int nonIntersectingConfigurations = 0;
        PipeEndpointType[][] endpoints = new PipeEndpointType[3][6];
        int maxMask = 262144;
        for (int mask = 0; mask < maxMask; ++mask) {
            class_265[] shapes = new class_265[]{class_259.method_1073(), class_259.method_1073(), class_259.method_1073()};
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 6; ++j) {
                    boolean hasConnection = (mask & 1 << i * 6 + j) != 0;
                    endpoints[i][j] = hasConnection ? PipeEndpointType.PIPE : null;
                    int renderType = PipeShapeBuilder.getRenderType(i, class_2350.method_10143((int)j), endpoints);
                    if (renderType == 0) continue;
                    shapes[i] = class_259.method_1084((class_265)shapes[i], (class_265)SHAPE_CACHE[i][j][renderType]);
                }
            }
            if (class_259.method_1074((class_265)shapes[0], (class_265)shapes[1], (class_247)class_247.field_16896) || class_259.method_1074((class_265)shapes[0], (class_265)shapes[2], (class_247)class_247.field_16896) || class_259.method_1074((class_265)shapes[1], (class_265)shapes[2], (class_247)class_247.field_16896)) {
                System.out.println("Intersecting configuration: " + Integer.toBinaryString(mask));
                ++intersectingConfigurations;
                return;
            }
            ++nonIntersectingConfigurations;
        }
        System.out.printf("Intersecting configurations: %d, non-intersecting configurations: %d\n", intersectingConfigurations, nonIntersectingConfigurations);
    }

    static {
        for (int slot = 0; slot < 3; ++slot) {
            for (class_2350 direction : class_2350.values()) {
                int connectionTypes = slot == 0 ? 2 : (slot == 1 ? 4 : 5);
                for (int connectionType = 0; connectionType < connectionTypes; ++connectionType) {
                    PipeShapeBuilder psb = new PipeShapeBuilder(PipePartBuilder.getSlotPos(slot), direction);
                    if (connectionType == 0) {
                        psb.centerConnector();
                    } else if (connectionType == 1) {
                        psb.straightLine(false, false);
                    } else if (connectionType == 2) {
                        psb.shortBend(false, false);
                    } else if (connectionType == 3) {
                        psb.farShortBend(false, false);
                    } else {
                        psb.longBend(false, false);
                    }
                    PipeBlockEntity.SHAPE_CACHE[slot][direction.method_10146()][connectionType] = psb.getShape();
                }
            }
        }
        DEFAULT_SHAPE = SHAPE_CACHE[0][0][0];
        ME_WIRE_CONNECTOR_SHAPES = PipeBlockEntity.buildSideShapes(0.5, 0.125);
    }

    record RenderAttachment(@Nullable class_2680 camouflage, PipeNetworkType[] types, PipeEndpointType[][] renderedConnections, class_2487[] customData) {
    }
}

