/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.item;

import aztech.modern_industrialization.api.WhitelistedItemStorage;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.item.ItemNetworkData;
import aztech.modern_industrialization.pipes.item.ItemNetworkNode;
import aztech.modern_industrialization.util.StorageUtil2;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public class ItemNetwork
extends PipeNetwork {
    public static final int TICK_RATE = 60;
    private static final ReferenceOpenHashSet<class_1792> WHITELIST_CACHED_SET = new ReferenceOpenHashSet();
    int inactiveTicks = 0;
    long lastMovedItems = 0L;

    public ItemNetwork(int id, PipeNetworkData data) {
        super(id, data == null ? new ItemNetworkData() : data);
    }

    @Override
    public void tick(class_3218 world) {
        if (this.inactiveTicks == 0) {
            this.doNetworkTransfer(world);
            this.inactiveTicks = 60;
        }
        --this.inactiveTicks;
    }

    private void doNetworkTransfer(class_3218 world) {
        ArrayList<ExtractionTarget> extractionTargets = new ArrayList<ExtractionTarget>();
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            class_2338 pos = entry.getPos();
            ItemNetworkNode itemNode = (ItemNetworkNode)entry.getNode();
            for (ItemNetworkNode.ItemConnection connection : itemNode.connections) {
                class_2350 querySide;
                class_2338 queryPos;
                Storage source;
                if (!connection.canExtract() || (source = (Storage)ItemStorage.SIDED.find((class_1937)world, queryPos = pos.method_10093(connection.direction), (Object)(querySide = connection.direction.method_10153()))) == null) continue;
                extractionTargets.add(new ExtractionTarget(connection, (Storage<ItemVariant>)source, queryPos, querySide));
            }
        }
        extractionTargets.sort(Comparator.comparing(et -> et.connection.extractPriority));
        List<Aggregate> insertTargets = this.getAggregatedInsertTargets(world);
        CombinedStorage insertStorage = new CombinedStorage(insertTargets);
        this.lastMovedItems = 0L;
        try (Transaction tx = Transaction.openOuter();){
            for (ExtractionTarget target : extractionTargets) {
                while (insertTargets.size() > 0 && target.connection.extractPriority > insertTargets.get(insertTargets.size() - 1).getPriority()) {
                    insertTargets.remove(insertTargets.size() - 1);
                }
                try {
                    this.lastMovedItems += StorageUtil.move(target.storage, (Storage)insertStorage, target.connection::canStackMoveThrough, (long)target.connection.getMoves(), (TransactionContext)tx);
                }
                catch (Exception exception) {
                    class_128 crashReport = class_128.method_560((Throwable)exception, (String)"Moving items in a pipe network");
                    crashReport.method_562("Block being extracted from:").method_578("Dimension", (Object)world.method_27983()).method_578("Position", (Object)target.queryPos).method_578("Accessed from side", (Object)target.querySide);
                    throw new class_148(crashReport);
                }
            }
            tx.commit();
        }
    }

    private List<Aggregate> getAggregatedInsertTargets(class_3218 world) {
        Int2ObjectOpenHashMap priorityBuckets = new Int2ObjectOpenHashMap();
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            ItemNetworkNode node = (ItemNetworkNode)entry.getNode();
            for (ItemNetworkNode.ItemConnection connection : node.connections) {
                WhitelistedItemStorage wis;
                Storage target;
                if (!connection.canInsert()) continue;
                if (connection.cache == null) {
                    connection.cache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)world, (class_2338)entry.getPos().method_10093(connection.direction));
                }
                if ((target = (Storage)connection.cache.find((Object)connection.direction.method_10153())) == null || !target.supportsInsertion()) continue;
                PriorityBucket bucket = (PriorityBucket)priorityBuckets.computeIfAbsent(connection.insertPriority, PriorityBucket::new);
                InsertTarget it = new InsertTarget(connection, StorageUtil2.wrapInventory((Storage<ItemVariant>)target));
                if (connection.whitelist || target instanceof WhitelistedItemStorage && (wis = (WhitelistedItemStorage)target).currentlyWhitelisted()) {
                    bucket.whitelist.add(it);
                    continue;
                }
                bucket.blacklist.add(it);
            }
        }
        PriorityBucket[] sortedBuckets = (PriorityBucket[])priorityBuckets.values().toArray((Object[])new PriorityBucket[0]);
        Arrays.sort(sortedBuckets, Comparator.comparingInt(pb -> -pb.priority));
        ArrayList<Aggregate> targets = new ArrayList<Aggregate>();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (PriorityBucket pb2 : sortedBuckets) {
            int whitelistSize = pb2.whitelist.size();
            int blacklistSize = pb2.blacklist.size();
            if (whitelistSize > 0) {
                Collections.shuffle(pb2.whitelist);
                targets.add(new WhitelistAggregate(pb2.priority, pb2.whitelist));
            }
            if (blacklistSize > 0) {
                Collections.shuffle(pb2.blacklist);
                targets.add(new BlacklistAggregate(pb2.priority, pb2.blacklist));
            }
            if (whitelistSize <= 0 || blacklistSize <= 0 || !(((Random)random).nextDouble() >= (double)whitelistSize / (double)(whitelistSize + blacklistSize))) continue;
            Collections.swap(targets, targets.size() - 2, targets.size() - 1);
        }
        return targets;
    }

    private static long insertTargets(List<InsertTarget> targets, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long totalInserted = 0L;
        for (InsertTarget target : targets) {
            if (!target.connection.canStackMoveThrough(resource)) continue;
            long inserted = target.target.insert((Object)resource, maxAmount, transaction);
            totalInserted += inserted;
            if ((maxAmount -= inserted) != 0L) continue;
            break;
        }
        return totalInserted;
    }

    private static class ExtractionTarget {
        private final ItemNetworkNode.ItemConnection connection;
        private final Storage<ItemVariant> storage;
        private final class_2338 queryPos;
        private final class_2350 querySide;

        private ExtractionTarget(ItemNetworkNode.ItemConnection connection, Storage<ItemVariant> storage, class_2338 queryPos, class_2350 querySide) {
            this.connection = connection;
            this.storage = storage;
            this.queryPos = queryPos;
            this.querySide = querySide;
        }
    }

    private static interface Aggregate
    extends InsertionOnlyStorage<ItemVariant> {
        public int getPriority();

        default public Iterator<StorageView<ItemVariant>> iterator() {
            return Collections.emptyIterator();
        }
    }

    private static class PriorityBucket {
        private final int priority;
        private final List<InsertTarget> whitelist = new ArrayList<InsertTarget>();
        private final List<InsertTarget> blacklist = new ArrayList<InsertTarget>();

        private PriorityBucket(int priority) {
            this.priority = priority;
        }
    }

    private record InsertTarget(ItemNetworkNode.ItemConnection connection, Storage<ItemVariant> target) {
    }

    private static class WhitelistAggregate
    implements Aggregate {
        private final int priority;
        private final Map<class_1792, List<Storage<ItemVariant>>> map = new IdentityHashMap<class_1792, List<Storage<ItemVariant>>>();
        private final List<InsertTarget> targets;

        WhitelistAggregate(int priority, List<InsertTarget> targets) {
            this.priority = priority;
            this.targets = targets;
            for (InsertTarget target : targets) {
                if (target.connection.whitelist) {
                    ItemNetworkNode.ItemConnection conn = target.connection;
                    for (ItemVariant variant : conn.stacksCache) {
                        if (variant.hasNbt()) continue;
                        this.map.computeIfAbsent(variant.getItem(), v -> new ArrayList()).add(target.target);
                    }
                    continue;
                }
                ObjectIterator objectIterator = target.target;
                if (objectIterator instanceof WhitelistedItemStorage) {
                    WhitelistedItemStorage wis = (WhitelistedItemStorage)objectIterator;
                    WHITELIST_CACHED_SET.clear();
                    wis.getWhitelistedItems((Set<class_1792>)WHITELIST_CACHED_SET);
                    for (class_1792 item : WHITELIST_CACHED_SET) {
                        this.map.computeIfAbsent(item, v -> new ArrayList()).add(target.target);
                    }
                    continue;
                }
                throw new IllegalStateException("Internal item pipe error! Should never happen!");
            }
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (resource.hasNbt()) {
                return ItemNetwork.insertTargets(this.targets, resource, maxAmount, transaction);
            }
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            long totalInserted = 0L;
            List<Storage<ItemVariant>> targets = this.map.get(resource.getItem());
            if (targets != null) {
                for (Storage<ItemVariant> target : targets) {
                    long inserted = target.insert((Object)resource, maxAmount, transaction);
                    totalInserted += inserted;
                    if ((maxAmount -= inserted) != 0L) continue;
                    break;
                }
            }
            return totalInserted;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }

    private static class BlacklistAggregate
    implements Aggregate {
        private final int priority;
        private final List<InsertTarget> targets;

        private BlacklistAggregate(int priority, List<InsertTarget> targets) {
            this.priority = priority;
            this.targets = targets;
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return ItemNetwork.insertTargets(this.targets, resource, maxAmount, transaction);
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }
}

