/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.client.MIRenderTypes;
import aztech.modern_industrialization.compat.sodium.SodiumCompat;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1723;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_777;
import net.minecraft.class_827;
import org.lwjgl.system.MemoryStack;

@Environment(value=EnvType.CLIENT)
public class RenderHelper {
    private static final Supplier<class_777[]> OVERLAY_QUADS;
    private static final float W = 0.05f;
    private static final MIIdentifier LOCKED_TEXTURE_LOCATION;
    private static final Supplier<class_777[]> CUBE_QUADS;
    private static final float TANK_W = 0.0635f;
    public static final int FULL_LIGHT = 0xF000F0;
    private static final float[] DEFAULT_BRIGHTNESSES;
    public static final BuiltinItemRendererRegistry.DynamicItemRenderer BLOCK_AND_ENTITY_RENDERER;

    public static void drawOverlay(class_4587 ms, class_4597 vcp, float r, float g, float b, int light, int overlay) {
        class_4588 vc = vcp.getBuffer(MIRenderTypes.solidHighlight());
        for (class_777 overlayQuad : OVERLAY_QUADS.get()) {
            vc.method_22919(ms.method_23760(), overlayQuad, r, g, b, light, overlay);
        }
    }

    public static void drawCube(class_4587 ms, class_4597 vcp, float r, float g, float b, int light, int overlay) {
        class_4588 vc = vcp.getBuffer(MIRenderTypes.solidHighlight());
        for (class_777 cubeQuad : CUBE_QUADS.get()) {
            vc.method_22919(ms.method_23760(), cubeQuad, r, g, b, light, overlay);
        }
    }

    public static void drawFluidInTank(class_2586 be, class_4587 ms, class_4597 vcp, FluidVariant fluid, float fill) {
        RenderHelper.drawFluidInTank(be.method_10997(), be.method_11016(), ms, vcp, fluid, fill);
    }

    public static void drawFluidInTank(class_1937 world, class_2338 pos, class_4587 ms, class_4597 vcp, FluidVariant fluid, float fill) {
        class_4588 vc = vcp.getBuffer(class_4722.method_24076());
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        int color = FluidVariantRendering.getColor((FluidVariant)fluid, (class_1920)world, (class_2338)pos);
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        SodiumCompat.markSpriteActive(sprite);
        float topHeight = fill = 0.0635f + 0.873f * Math.min(1.0f, Math.max(fill, 0.0f));
        float bottomHeight = 0.0635f;
        if (FluidVariantAttributes.isLighterThanAir((FluidVariant)fluid)) {
            topHeight = 0.9365f;
            bottomHeight = 1.0f - fill;
        }
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        for (class_2350 direction : class_2350.values()) {
            QuadEmitter emitter = renderer.meshBuilder().getEmitter();
            if (direction.method_10166().method_10178()) {
                emitter.square(direction, 0.0635f, 0.0635f, 0.9365f, 0.9365f, direction == class_2350.field_11036 ? 1.0f - topHeight : bottomHeight);
            } else {
                emitter.square(direction, 0.0635f, bottomHeight, 0.9365f, topHeight, 0.0635f);
            }
            emitter.spriteBake(0, sprite, 4);
            emitter.spriteColor(0, -1, -1, -1, -1);
            vc.method_22919(ms.method_23760(), emitter.toBakedQuad(0, sprite, false), r, g, b, 0xF000F0, class_4608.field_21444);
        }
    }

    public static void drawFluidInGui(class_4587 ms, FluidVariant fluid, int i, int j) {
        RenderHelper.drawFluidInGui(ms, fluid, i, j, 16, 1.0f);
        RenderSystem.enableDepthTest();
    }

    public static void drawFluidInGui(class_4587 ms, FluidVariant fluid, float i, float j, int scale, float fractionUp) {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        int color = FluidVariantRendering.getColor((FluidVariant)fluid);
        if (sprite == null) {
            return;
        }
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(class_757::method_34541);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        float x0 = i;
        float y0 = j;
        float x1 = x0 + (float)scale;
        float y1 = y0 + (float)scale * fractionUp;
        float z = 0.5f;
        float u0 = sprite.method_4594();
        float v1 = sprite.method_4575();
        float v0 = v1 + (sprite.method_4593() - v1) * fractionUp;
        float u1 = sprite.method_4577();
        class_1159 model = ms.method_23760().method_23761();
        bufferBuilder.method_22918(model, x0, y1, z).method_22915(r, g, b, 1.0f).method_22913(u0, v1).method_1344();
        bufferBuilder.method_22918(model, x1, y1, z).method_22915(r, g, b, 1.0f).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(model, x1, y0, z).method_22915(r, g, b, 1.0f).method_22913(u1, v0).method_1344();
        bufferBuilder.method_22918(model, x0, y0, z).method_22915(r, g, b, 1.0f).method_22913(u0, v0).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.enableDepthTest();
        SodiumCompat.markSpriteActive(sprite);
    }

    public static boolean isPointWithinRectangle(int xStart, int yStart, int width, int height, double pointX, double pointY) {
        return pointX >= (double)(xStart - 1) && pointX < (double)(xStart + width + 1) && pointY >= (double)(yStart - 1) && pointY < (double)(yStart + height + 1);
    }

    public static void quadWithAlpha(class_4588 consumer, class_4587.class_4665 matrixEntry, class_777 quad, float red, float green, float blue, float alpha, int light, int overlay) {
        boolean useQuadColorData = false;
        float[] fs = DEFAULT_BRIGHTNESSES;
        int[] js = quad.method_3357();
        class_2382 vec3i = quad.method_3358().method_10163();
        class_1160 vec3f = new class_1160((float)vec3i.method_10263(), (float)vec3i.method_10264(), (float)vec3i.method_10260());
        class_1159 matrix4f = matrixEntry.method_23761();
        vec3f.method_23215(matrixEntry.method_23762());
        int j = js.length / 8;
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(class_290.field_1590.method_1362());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                float t;
                float s;
                float r;
                float w;
                float v;
                intBuffer.clear();
                intBuffer.put(js, k * 8, 8);
                float f = byteBuffer.getFloat(0);
                float g = byteBuffer.getFloat(4);
                float h = byteBuffer.getFloat(8);
                if (useQuadColorData) {
                    float l = (float)(byteBuffer.get(12) & 0xFF) / 255.0f;
                    v = (float)(byteBuffer.get(13) & 0xFF) / 255.0f;
                    w = (float)(byteBuffer.get(14) & 0xFF) / 255.0f;
                    r = l * fs[k] * red;
                    s = v * fs[k] * green;
                    t = w * fs[k] * blue;
                } else {
                    r = fs[k] * red;
                    s = fs[k] * green;
                    t = fs[k] * blue;
                }
                v = byteBuffer.getFloat(16);
                w = byteBuffer.getFloat(20);
                class_1162 vector4f = new class_1162(f, g, h, 1.0f);
                vector4f.method_22674(matrix4f);
                consumer.method_23919(vector4f.method_4953(), vector4f.method_4956(), vector4f.method_4957(), r, s, t, alpha, v, w, overlay, light, vec3f.method_4943(), vec3f.method_4945(), vec3f.method_4947());
            }
        }
    }

    public static void fill(class_4587 matrices, int x1, int y1, int x2, int y2, int color) {
        RenderHelper.fill(matrices.method_23760().method_23761(), x1, y1, x2, y2, color);
    }

    private static void fill(class_1159 matrix, int x1, int y1, int x2, int y2, int color) {
        int j;
        if (x1 < x2) {
            j = x1;
            x1 = x2;
            x2 = j;
        }
        if (y1 < y2) {
            j = y1;
            y1 = y2;
            y2 = j;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(g, h, k, f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(g, h, k, f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(g, h, k, f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(g, h, k, f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawLockedTexture(class_2586 entity, class_4587 matrices, class_4597 vertexConsumers, int colorRgb) {
        class_4588 vc = vertexConsumers.getBuffer(class_1921.method_23581());
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(LOCKED_TEXTURE_LOCATION);
        class_2338 pos = entity.method_11016();
        class_2680 state = entity.method_11010();
        float r = (float)(colorRgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorRgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorRgb & 0xFF) / 255.0f;
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        for (class_2350 direction : class_2350.values()) {
            if (direction.method_10166().method_10178() || entity.method_10997() != null && !class_2248.method_9607((class_2680)state, (class_1922)entity.method_10997(), (class_2338)pos, (class_2350)direction.method_10153(), (class_2338)pos.method_10093(direction.method_10153()))) continue;
            QuadEmitter emitter = renderer.meshBuilder().getEmitter();
            emitter.square(direction, 1.0f, 0.0f, 0.0f, 1.0f, 1.015f);
            emitter.spriteBake(0, sprite, 4);
            vc.method_22919(matrices.method_23760(), emitter.toBakedQuad(0, sprite, false), r, g, b, 0xF000F0, class_4608.field_21444);
        }
    }

    public static void renderVoxelShape(class_4587 poseStack, class_4588 consumer, class_265 shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        for (class_238 aabb : shape.method_1090()) {
            class_761.method_3291((class_4587)poseStack, (class_4588)consumer, (class_265)class_259.method_1078((class_238)aabb), (double)x, (double)y, (double)z, (float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    public static void setupRenderHelper() {
        ClientSpriteRegistryCallback.event((class_2960)class_1723.field_21668).register((atlas, registry) -> registry.register((class_2960)LOCKED_TEXTURE_LOCATION));
    }

    static {
        LOCKED_TEXTURE_LOCATION = new MIIdentifier("block/locked");
        OVERLAY_QUADS = Suppliers.memoize(() -> {
            class_777[] overlayQuads = new class_777[24];
            Renderer r = RendererAccess.INSTANCE.getRenderer();
            RenderMaterial material = r.materialFinder().blendMode(0, BlendMode.SOLID).find();
            for (class_2350 direction : class_2350.values()) {
                QuadEmitter emitter = r.meshBuilder().getEmitter();
                emitter.square(direction, 0.0f, 0.0f, 1.0f, 0.05f, 0.0f);
                emitter.material(material);
                overlayQuads[direction.method_10146() * 4] = emitter.toBakedQuad(0, null, false);
                emitter = r.meshBuilder().getEmitter();
                emitter.square(direction, 0.0f, 0.95f, 1.0f, 1.0f, 0.0f);
                emitter.material(material);
                overlayQuads[direction.method_10146() * 4 + 1] = emitter.toBakedQuad(0, null, false);
                emitter = r.meshBuilder().getEmitter();
                emitter.square(direction, 0.0f, 0.05f, 0.05f, 0.95f, 0.0f);
                emitter.material(material);
                overlayQuads[direction.method_10146() * 4 + 2] = emitter.toBakedQuad(0, null, false);
                emitter = r.meshBuilder().getEmitter();
                emitter.square(direction, 0.95f, 0.05f, 1.0f, 0.95f, 0.0f);
                emitter.material(material);
                overlayQuads[direction.method_10146() * 4 + 3] = emitter.toBakedQuad(0, null, false);
            }
            return overlayQuads;
        });
        CUBE_QUADS = Suppliers.memoize(() -> {
            class_777[] cubeQuads = new class_777[6];
            Renderer r = RendererAccess.INSTANCE.getRenderer();
            for (class_2350 direction : class_2350.values()) {
                QuadEmitter emitter = r.meshBuilder().getEmitter();
                emitter.square(direction, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
                cubeQuads[direction.method_10146()] = emitter.toBakedQuad(0, null, false);
            }
            return cubeQuads;
        });
        DEFAULT_BRIGHTNESSES = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        BLOCK_AND_ENTITY_RENDERER = (stack, mode, matrices, vertexConsumers, light, overlay) -> {
            class_1792 patt17253$temp = stack.method_7909();
            if (!(patt17253$temp instanceof class_1747)) {
                throw new IllegalArgumentException("Stack must be a block item!");
            }
            class_1747 blockItem = (class_1747)patt17253$temp;
            class_2248 patt17412$temp = blockItem.method_7711();
            if (!(patt17412$temp instanceof class_2343)) {
                throw new IllegalArgumentException("Block must be an entity block!");
            }
            class_2343 entityBlock = (class_2343)patt17412$temp;
            class_2586 fakeBlockEntity = entityBlock.method_10123(class_2338.field_10980, blockItem.method_7711().method_9564());
            class_2487 tag = Objects.requireNonNullElseGet(stack.method_7941("BlockEntityTag"), class_2487::new);
            Objects.requireNonNull(fakeBlockEntity).method_11014(tag);
            class_310.method_1551().method_1541().method_3353(fakeBlockEntity.method_11010(), matrices, vertexConsumers, light, overlay);
            class_827 renderer = class_310.method_1551().method_31975().method_3550(fakeBlockEntity);
            Objects.requireNonNull(renderer).method_3569(fakeBlockEntity, class_310.method_1551().method_1488(), matrices, vertexConsumers, light, overlay);
        };
    }
}

