/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2478;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import potionstudios.byg.common.BYGCarvableBlocks;
import potionstudios.byg.common.BYGFlammables;
import potionstudios.byg.common.BYGFlattenables;
import potionstudios.byg.common.BYGHoeables;
import potionstudios.byg.common.BYGTags;
import potionstudios.byg.common.block.BYGBlockTags;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.entity.BYGEntities;
import potionstudios.byg.common.entity.ai.village.poi.BYGPoiTypes;
import potionstudios.byg.common.entity.villager.BYGVillagerType;
import potionstudios.byg.config.BYGConfigHandler;
import potionstudios.byg.config.ConfigVersionTracker;
import potionstudios.byg.config.SettingsConfig;
import potionstudios.byg.mixin.access.BlockEntityTypeAccess;
import potionstudios.byg.mixin.access.DeltaFeatureAccess;
import potionstudios.byg.mixin.access.PoiTypesAccess;
import potionstudios.byg.reg.BlockRegistryObject;
import potionstudios.byg.server.command.ReloadConfigsCommand;
import potionstudios.byg.server.command.ResetConfigsCommand;
import potionstudios.byg.server.command.UpdateConfigsCommand;
import potionstudios.byg.server.command.ValidateConfigsCommand;
import potionstudios.byg.util.FileUtils;
import potionstudios.byg.util.MLBlockTags;
import potionstudios.byg.util.ModPlatform;

public class BYG {
    public static final String MOD_ID = "byg";
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean INITIALIZED;
    private static final Map<class_2248, Predicate<class_4970.class_4971>> BLOCKSTATE_IS_REPLACEMENTS;

    public static void commonLoad() {
        BYG.registerBlockTagReplacements();
        PoiTypesAccess.byg_invokeRegisterBlockStates(BYGPoiTypes.FORAGER.asHolder());
        String loadAllConfigs = BYGConfigHandler.loadAllConfigs(false, false);
        BYG.logConfigErrors();
        BYGEntities.registerSpawnPlacements();
        FileUtils.backUpDirectory(ModPlatform.INSTANCE.configPath(), "last_working_configs_backup");
        if (Boolean.getBoolean("bygDev")) {
            ModPlatform.INSTANCE.addTagsUpdatedListener(access -> {
                for (BYGTags tag : BYGTags.values()) {
                    for (BYGTags.RegistryType<?> allowed : tag.acceptedTypes) {
                        class_6862<?> bygTag;
                        Optional<class_6885.class_6888<?>> holder = allowed.getTag(bygTag = tag.byg(allowed));
                        if (!holder.isEmpty() && !holder.get().method_40239().findFirst().isEmpty()) continue;
                        BYG.logWarning("Tag %s of type %s is empty!".formatted(bygTag.comp_327(), allowed.registry.method_29177()));
                    }
                }
            });
        }
    }

    private static void registerBlockTagReplacements() {
        BYG.blockToBlockTagReplacement(class_2246.field_10504, MLBlockTags.BOOKSHELVES);
        BYG.blockToBlockTagReplacement(class_2246.field_10362, BYGBlockTags.FARMLAND);
        BYG.blockToBlockTagReplacement(class_2246.field_10471, BYGBlockTags.END_STONE);
    }

    public static void blockToBlockTagReplacement(class_2248 block, class_6862<class_2248> blockTag) {
        BLOCKSTATE_IS_REPLACEMENTS.put(block, state -> state.method_26164(blockTag));
    }

    public static void blockToInstanceOfReplacement(class_2248 block, Class<? extends class_2248> clazz) {
        BLOCKSTATE_IS_REPLACEMENTS.put(block, state -> clazz.isInstance(state.method_26204()));
    }

    public static Map<class_2248, Predicate<class_4970.class_4971>> getBlockstateIsReplacements() {
        return BLOCKSTATE_IS_REPLACEMENTS;
    }

    public static void attachCommands(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environmentType) {
        LiteralArgumentBuilder bygCommands = class_2170.method_9247((String)MOD_ID);
        LiteralArgumentBuilder config = class_2170.method_9247((String)"config");
        config.then(ReloadConfigsCommand.register());
        config.then(UpdateConfigsCommand.register());
        config.then(ValidateConfigsCommand.register());
        config.then(ResetConfigsCommand.register());
        bygCommands.then((ArgumentBuilder)config);
        dispatcher.register(bygCommands);
    }

    public static void threadSafeCommonLoad() {
        BYGVillagerType.setVillagerForBYGBiomes();
        BYG.appendBlocksToBlockEntities();
        DeltaFeatureAccess.byg_setCANNOT_REPLACE((ImmutableList<class_2248>)new ImmutableList.Builder().addAll(DeltaFeatureAccess.byg_getCANNOT_REPLACE()).add((Object)((class_2248)BYGBlocks.EMBUR_GEL_BLOCK.get())).add((Object)((class_2248)BYGBlocks.EMBUR_GEL_BRANCH.get())).add((Object)((class_2248)BYGBlocks.EMBUR_GEL_VINES.get())).addAll((Iterable)class_156.method_654(new ArrayList(), list -> {
            for (class_2248 block : class_2378.field_11146) {
                class_3614 material = block.method_9564().method_26207();
                if (material != class_3614.field_15935 && material != class_3614.field_15946 && material != class_3614.field_15938 && material != class_3614.field_15956 && material != class_3614.field_26708 && material != class_3614.field_15926 && material != class_3614.field_15923 && material != class_3614.field_15932) continue;
                list.add(block);
            }
        })).build());
    }

    private static void appendBlocksToBlockEntities() {
        BlockEntityTypeAccess campfireBuilderAccess = (BlockEntityTypeAccess)class_2591.field_17380;
        ObjectOpenHashSet validCampfireBlocks = new ObjectOpenHashSet(campfireBuilderAccess.byg_getValidBlocks());
        validCampfireBlocks.add((class_2248)BYGBlocks.CRYPTIC_CAMPFIRE.get());
        validCampfireBlocks.add((class_2248)BYGBlocks.BORIC_CAMPFIRE.get());
        campfireBuilderAccess.byg_setValidBlocks((Set<class_2248>)validCampfireBlocks);
        BlockEntityTypeAccess signBuilderAccess = (BlockEntityTypeAccess)class_2591.field_11911;
        ObjectOpenHashSet signValidBlocks = new ObjectOpenHashSet(signBuilderAccess.byg_getValidBlocks());
        for (BlockRegistryObject<class_2248> signBlock : BYGBlocks.SIGN_BLOCKS) {
            class_2248 block = (class_2248)signBlock.get();
            if (block instanceof class_2478) {
                signValidBlocks.add(block);
                continue;
            }
            throw new IllegalArgumentException("Attempting to add block to sign block entity that is not a type of SignBlock");
        }
        signBuilderAccess.byg_setValidBlocks((Set<class_2248>)signValidBlocks);
    }

    public static void threadSafeLoadFinish() {
        BYG.logDebug("BYG: \"Load Complete Event\" Starting...");
        BYGHoeables.tillablesBYG();
        BYGFlammables.flammablesBYG();
        BYGCarvableBlocks.addCarverBlocks();
        BYGFlattenables.addFlattenables();
        BYG.logDebug("BYG: \"Load Complete\" Event Complete!");
    }

    public static class_2960 createLocation(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static class_2960 createLocation(class_5321<?> path) {
        return path.method_29177();
    }

    public static class_2960 createLocation(class_6880<?> holder) {
        return BYG.createLocation((class_5321)holder.method_40230().orElseThrow());
    }

    public static void logWarning(String msg) {
        SettingsConfig.LoggerSettings loggerSettings = SettingsConfig.getConfig().loggerSettings();
        if (loggerSettings.logWarnings()) {
            if (loggerSettings.exclude().stream().noneMatch(msg::contains)) {
                LOGGER.warn(msg);
            }
        }
    }

    public static void logInfo(String msg) {
        SettingsConfig.LoggerSettings loggerSettings = SettingsConfig.getConfig().loggerSettings();
        if (loggerSettings.logInfo()) {
            if (loggerSettings.exclude().stream().noneMatch(msg::contains)) {
                LOGGER.info(msg);
            }
        }
    }

    public static void logDebug(String msg) {
        SettingsConfig.LoggerSettings loggerSettings = SettingsConfig.getConfig().loggerSettings();
        if (loggerSettings.logDebug()) {
            if (loggerSettings.exclude().stream().noneMatch(msg::contains)) {
                LOGGER.debug(msg);
            }
        }
    }

    public static void logError(String msg) {
        LOGGER.error(msg);
    }

    public static void logConfigErrors() {
        if (!BYGConfigHandler.CONFIG_EXCEPTIONS.isEmpty()) {
            for (int i = 0; i < 3; ++i) {
                BYG.logError("");
            }
            BYG.logError("=".repeat(100));
            BYG.logError("");
            BYG.logError("BYG config(s) errors have occurred, BYG has used default settings instead! Errors:");
            BYG.logError("");
            int count = 0;
            for (Exception e : BYGConfigHandler.CONFIG_EXCEPTIONS) {
                BYG.logError(count + ". " + e.getMessage());
                BYG.logError("");
                ++count;
            }
            BYG.logError("");
            BYG.logError("This error goes away after you fix or delete your configs and you restart your game.");
            BYG.logError("");
            BYG.logError("=".repeat(100));
            for (int i = 0; i < 3; ++i) {
                BYG.logError("");
            }
        }
    }

    static {
        BLOCKSTATE_IS_REPLACEMENTS = new HashMap<class_2248, Predicate<class_4970.class_4971>>();
        ConfigVersionTracker.getConfig(new ConfigVersionTracker(ModPlatform.INSTANCE.configPath().toFile().exists() ? 0 : 6), false);
    }
}

