/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.end;

import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.serialization.jankson.JanksonJsonOps;
import corgitaco.corgilib.serialization.jankson.JanksonUtil;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6005;
import net.minecraft.class_6908;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.config.BYGConfigHandler;
import potionstudios.byg.util.BYGUtil;
import potionstudios.byg.util.ModPlatform;

public record EndBiomesConfig(boolean forceBYGEndBiomeSource, boolean addAllEndBiomeCategoryEntries, int skyLayerStartY, LayersBiomeData islandLayers, LayersBiomeData voidLayers, LayersBiomeData skyLayers) {
    public static final Supplier<Path> LEGACY_CONFIG_PATH = () -> ModPlatform.INSTANCE.configPath().resolve("byg-end-biomes.json");
    public static final Supplier<Path> CONFIG_PATH = () -> ModPlatform.INSTANCE.configPath().resolve("end-biomes.json5");
    public static final Codec<EndBiomesConfig> LEGACY_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("useBYGNetherBiomeSourceInNewWorlds").forGetter(overworldBiomeConfig -> overworldBiomeConfig.forceBYGEndBiomeSource), (App)Codec.BOOL.fieldOf("addAllEndBiomeCategoryEntries").forGetter(overworldBiomeConfig -> overworldBiomeConfig.addAllEndBiomeCategoryEntries), (App)Codec.INT.fieldOf("skyLayerStartY").forGetter(overworldBiomeConfig -> overworldBiomeConfig.skyLayerStartY), (App)LayersBiomeData.CODEC.fieldOf("islandLayerData").forGetter(overworldBiomeConfig -> overworldBiomeConfig.islandLayers), (App)LayersBiomeData.CODEC.fieldOf("voidLayerData").forGetter(overworldBiomeConfig -> overworldBiomeConfig.voidLayers), (App)LayersBiomeData.CODEC.fieldOf("skyLayerData").forGetter(overworldBiomeConfig -> overworldBiomeConfig.skyLayers)).apply((Applicative)builder, EndBiomesConfig::new));
    public static final Codec<EndBiomesConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("forceBYGEndBiomeSource").forGetter(overworldBiomeConfig -> overworldBiomeConfig.forceBYGEndBiomeSource), (App)Codec.BOOL.fieldOf("addAllEndBiomeCategoryEntries").forGetter(overworldBiomeConfig -> overworldBiomeConfig.addAllEndBiomeCategoryEntries), (App)Codec.INT.fieldOf("skyLayerStartY").forGetter(overworldBiomeConfig -> overworldBiomeConfig.skyLayerStartY), (App)LayersBiomeData.CODEC.fieldOf("islandLayer").forGetter(overworldBiomeConfig -> overworldBiomeConfig.islandLayers), (App)LayersBiomeData.CODEC.fieldOf("voidLayer").forGetter(overworldBiomeConfig -> overworldBiomeConfig.voidLayers), (App)LayersBiomeData.CODEC.fieldOf("skyLayer").forGetter(overworldBiomeConfig -> overworldBiomeConfig.skyLayers)).apply((Applicative)builder, EndBiomesConfig::new));
    public static EndBiomesConfig INSTANCE = null;
    public static final EndBiomesConfig DEFAULT = new EndBiomesConfig(true, true, 180, LayersBiomeData.DEFAULT_END_ISLANDS, LayersBiomeData.DEFAULT_END_VOID, LayersBiomeData.DEFAULT_END_SKY);

    public static EndBiomesConfig getConfig() {
        return EndBiomesConfig.getConfig(false, false, null);
    }

    public static EndBiomesConfig getConfig(boolean serialize) {
        return EndBiomesConfig.getConfig(serialize, false, null);
    }

    public static EndBiomesConfig getConfig(boolean serialize, boolean recreate, @Nullable class_2378<class_1959> additional) {
        if (INSTANCE == null || serialize || recreate) {
            INSTANCE = EndBiomesConfig.readConfig(recreate);
        }
        if (additional != null && INSTANCE.addAllEndBiomeCategoryEntries()) {
            class_6005 registryDefaults = ((class_6005.class_6006)class_156.method_654((Object)class_6005.method_34971(), builder -> additional.method_10220().map(arg_0 -> ((class_2378)additional).method_29113(arg_0)).map(Optional::get).map(arg_0 -> ((class_2378)additional).method_40290(arg_0)).filter(biomeHolder -> biomeHolder.method_40220(class_6908.field_37394)).map(biomeHolder -> (class_5321)biomeHolder.method_40230().orElseThrow()).forEach(biomeResourceKey -> builder.method_34975(biomeResourceKey, 2)))).method_34974();
            BiPredicate<Collection, class_5321> filter = (existing, added) -> !existing.contains(added);
            EndBiomesConfig registryUpdatedConfig = new EndBiomesConfig(INSTANCE.forceBYGEndBiomeSource(), INSTANCE.addAllEndBiomeCategoryEntries(), INSTANCE.skyLayerStartY(), new LayersBiomeData(BYGUtil.combineWeightedRandomLists(filter, INSTANCE.islandLayers().biomeWeights(), registryDefaults), INSTANCE.islandLayers().biomeSize()), new LayersBiomeData(INSTANCE.voidLayers().biomeWeights(), INSTANCE.voidLayers().biomeSize()), new LayersBiomeData(INSTANCE.skyLayers().biomeWeights(), INSTANCE.skyLayers().biomeSize()));
            EndBiomesConfig.createConfig(CONFIG_PATH.get(), registryUpdatedConfig);
            INSTANCE = registryUpdatedConfig;
        }
        return INSTANCE;
    }

    private static EndBiomesConfig readConfig(boolean recreate) {
        Path legacyPath = LEGACY_CONFIG_PATH.get();
        Path path = CONFIG_PATH.get();
        EndBiomesConfig config = DEFAULT;
        if (legacyPath.toFile().exists()) {
            try {
                FileReader reader = new FileReader(legacyPath.toFile());
                config = (EndBiomesConfig)((Pair)LEGACY_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).result().orElseThrow(() -> BYGUtil.configFileFailureException(path))).getFirst();
                reader.close();
                Files.delete(legacyPath);
            }
            catch (IOException e) {
                BYG.logError("Could not create new config file for: " + legacyPath.toString());
                e.printStackTrace();
                return config;
            }
        }
        if (!path.toFile().exists() || recreate) {
            EndBiomesConfig.createConfig(path, config);
        }
        BYG.logInfo(String.format("\"%s\" was read.", path.toString()));
        try {
            return (EndBiomesConfig)JanksonUtil.readConfig((Path)path, CODEC, (DynamicOps)JanksonJsonOps.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
            BYGConfigHandler.CONFIG_EXCEPTIONS.add(e);
            return DEFAULT;
        }
    }

    private static void createConfig(Path path, EndBiomesConfig configToSerialize) {
        Map comments = (Map)class_156.method_654(new HashMap(), map -> {
            map.put("forceBYGEndBiomeSource", "Is BYG's End Biome Source used?\nBYG's end biome source will automatically add all known end biomes that specify their biome category as \"the_end\", see \"addAllEndBiomeCategoryEntries\" comment.");
            map.put("addAllEndBiomeCategoryEntries", "Does this config automatically fill with all biomes using the \"the_end\" biome category? Note: Vanilla at the time of writing does not have an end biomes tag.");
            map.put("skyLayer", "Biomes that spawn in the Y range of \"skyLayerStartY to Dimension Max Y.");
            map.put("islandLayer", "Biomes that spawn where the large end islands/surface generate.");
            map.put("voidLayer", "Biomes that spawn where there is no ground aka void.");
            String biomeWeights = "Higher weight, means the biome in question is bound to spawn more frequently against all other biomes listed here.\nWeight of 0 means the biome is disabled.\n\n\"data\" should be a valid biome ID from vanilla, mods, or datapacks.\nIf the biome in question is not in the biome registry, the biome is ignored & logged in the \"latest.log\".\n";
            map.put("skyLayer.biomeWeights", biomeWeights);
            map.put("islandLayer.biomeWeights", biomeWeights);
            map.put("voidLayer.biomeWeights", biomeWeights);
        });
        String endConfigHeader = "If your settings in this file seem to have to no effect on the generation of the end, it is more than likely that another mod(s) related to the end has taken control instead, and you should user their config.";
        JanksonUtil.createConfig((Path)path, CODEC, (String)("/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n\n" + endConfigHeader + "\n*/"), (Map)comments, (DynamicOps)JanksonJsonOps.INSTANCE, (Object)configToSerialize);
    }
}

