/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.overworld;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import corgitaco.corgilib.serialization.codec.CodecUtil;
import corgitaco.corgilib.serialization.codec.FromFileCodec;
import corgitaco.corgilib.serialization.codec.Wrapped;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import potionstudios.byg.common.world.biome.BYGBiomes;
import potionstudios.byg.util.BYGUtil;

public class BYGOverworldBiomeSelectors {
    public static final FromFileCodec<List<List<class_5321<class_1959>>>> BIOME_LAYOUT_CODEC = FromFileCodec.create((Codec)CodecUtil.wrapCodecForCollectionSerializing((Codec)Codec.list((Codec)Codec.list((Codec)CodecUtil.BIOME_CODEC))).xmap(CodecUtil.WrapForSerialization::value, CodecUtil::wrap), (String)"biome_layout");
    public static final Codec<List<List<class_5321<class_1959>>>> OLD_BIOME_LAYOUT_CODEC = Codec.list((Codec)Codec.list((Codec)CodecUtil.BIOME_CODEC));
    public static final Map<String, Pair<Map<String, String>, Wrapped<List<List<class_5321<class_1959>>>>>> BIOME_LAYOUTS = new HashMap<String, Pair<Map<String, String>, Wrapped<List<List<class_5321<class_1959>>>>>>();
    public static final String BIOME_LAYOUT = "\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\n";
    public static final String OCEAN_BIOMES_LAYOUT = "[ DEEP-ICY, DEEP-COLD, DEEP-NEUTRAL, DEEP-WARM, DEEP-HOT ]\n[ SHALLOW-ICY, SHALLOW-COLD, SHALLOW-NEUTRAL, SHALLOW-WARM, SHALLOW-HOT ],\n\n";
    public static final String REQUIRES_VALID_KEYS = "All keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String SHATTERED_BIOMES_LAYOUT = "Appearing on shattered terrain here is the \"shattered_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\nIn slots containing \"minecraft:the_void\", biomes at the equivalent temperature/humidity index in \"middle_biomes\" will be used instead.\n";
    public static final String PEAK_BIOMES_LAYOUT = "Appearing on mountainous terrain & BELOW weirdness 0, here is the \"peak_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String SLOPE_BIOMES_LAYOUT = "Appearing on sloped terrain, near mountainous terrain, & BELOW weirdness 0, here is the \"slope_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String SLOPE_BIOMES_VARIANT_LAYOUT = "Appearing on sloped terrain, near mountainous terrain, & ABOVE weirdness 0, here is the \"slope_biome_variants\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\n" + BYGOverworldBiomeSelectors.invalidKeysOkay("slope_biomes");
    public static final String PEAK_BIOMES_VARIANT_LAYOUT = "Appearing on mountainous terrain & ABOVE weirdness 0, here is the \"peak_biome_variants\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\n" + BYGOverworldBiomeSelectors.invalidKeysOkay("slope_biomes");
    public static final String OCEANS_BIOMES_LAYOUT_COMMENT = "Appearing on terrain below sea level, here is the \"ocean_biomes\" layout:\n[ DEEP-ICY, DEEP-COLD, DEEP-NEUTRAL, DEEP-WARM, DEEP-HOT ]\n[ SHALLOW-ICY, SHALLOW-COLD, SHALLOW-NEUTRAL, SHALLOW-WARM, SHALLOW-HOT ],\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String PLATEAU_BIOMES_LAYOUT = "Appearing on elevated flat terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"plateau_biome_variants\", here is the \"plateau_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String PLATEAU_BIOMES_VARIANT_LAYOUT = "Appearing on elevated flat terrain ABOVE weirdness 0, here is the \"plateau_biomes_variant\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\n" + BYGOverworldBiomeSelectors.invalidKeysOkay("plateau_biomes");
    public static final String MIDDLE_BIOMES_LAYOUT = "Appearing on terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"middle_biomes_variants\", here is the \"middle_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String MIDDLE_BIOMES_VARIANT_LAYOUT = "Appearing on terrain ABOVE weirdness 0, here is the \"middle_biomes_variant\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\n" + BYGOverworldBiomeSelectors.invalidKeysOkay("middle_biomes");
    public static final String BEACH_BIOMES_LAYOUT = "Appearing on terrain bordering oceans, here is the \"beach_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    protected static final Wrapped<List<List<class_5321<class_1959>>>> OCEANS_VANILLA = BYGOverworldBiomeSelectors.create("oceans/oceans_vanilla", "Appearing on terrain below sea level, here is the \"ocean_biomes\" layout:\n[ DEEP-ICY, DEEP-COLD, DEEP-NEUTRAL, DEEP-WARM, DEEP-HOT ]\n[ SHALLOW-ICY, SHALLOW-COLD, SHALLOW-NEUTRAL, SHALLOW-WARM, SHALLOW-HOT ],\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{class_1972.field_9418, class_1972.field_9470, class_1972.field_9446, class_1972.field_9439, class_1972.field_9408}, {class_1972.field_9435, class_1972.field_9467, class_1972.field_9423, class_1972.field_9441, class_1972.field_9408}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> MIDDLE_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("middle_biomes/middle_biomes_vanilla", "Appearing on terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"middle_biomes_variants\", here is the \"middle_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{class_1972.field_35117, class_1972.field_35117, class_1972.field_35117, class_1972.field_9454, class_1972.field_9420}, {class_1972.field_9451, class_1972.field_9451, class_1972.field_9409, class_1972.field_9420, class_1972.field_35113}, {class_1972.field_9414, class_1972.field_9451, class_1972.field_9409, class_1972.field_9412, class_1972.field_9475}, {class_1972.field_9449, class_1972.field_9449, class_1972.field_9409, class_1972.field_9417, class_1972.field_9417}, {class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> MIDDLE_BIOMES_VARIANT_VANILLA = BYGOverworldBiomeSelectors.create("middle_biomes_variant/middle_biomes_variant_vanilla", MIDDLE_BIOMES_VARIANT_LAYOUT, new class_5321[][]{{class_1972.field_9453, class_1972.field_9473, class_1972.field_9454, class_1972.field_9473, class_1972.field_9473}, {class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_35119}, {class_1972.field_9455, class_1972.field_9473, class_1972.field_9473, class_1972.field_35112, class_1972.field_9473}, {class_1972.field_9473, class_1972.field_9473, class_1972.field_9451, class_1972.field_35118, class_1972.field_9440}, {class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473}});
    public static final Wrapped<List<List<class_5321<class_1959>>>> PLATEAU_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("plateau_biomes/plateau_biomes_vanilla", "Appearing on elevated flat terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"plateau_biome_variants\", here is the \"plateau_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{class_1972.field_35117, class_1972.field_35117, class_1972.field_35117, class_1972.field_9454, class_1972.field_9454}, {class_1972.field_34470, class_1972.field_34470, class_1972.field_9409, class_1972.field_9420, class_1972.field_35113}, {class_1972.field_34470, class_1972.field_34470, class_1972.field_34470, class_1972.field_34470, class_1972.field_9475}, {class_1972.field_9430, class_1972.field_9430, class_1972.field_9409, class_1972.field_9409, class_1972.field_9417}, {class_1972.field_9415, class_1972.field_9415, class_1972.field_9415, class_1972.field_35110, class_1972.field_35110}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> PLATEAU_BIOMES_VARIANT_VANILLA = BYGOverworldBiomeSelectors.create("plateau_biomes_variant/plateau_biomes_variant_vanilla", PLATEAU_BIOMES_VARIANT_LAYOUT, new class_5321[][]{{class_1972.field_9453, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473}, {class_1972.field_9473, class_1972.field_9473, class_1972.field_34470, class_1972.field_34470, class_1972.field_35119}, {class_1972.field_9473, class_1972.field_9473, class_1972.field_9409, class_1972.field_9412, class_1972.field_9473}, {class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473}, {class_1972.field_9443, class_1972.field_9443, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> PEAK_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("peak_biomes/peak_biomes_vanilla", "Appearing on mountainous terrain & BELOW weirdness 0, here is the \"peak_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{class_1972.field_34474, class_1972.field_34474, class_1972.field_34474, class_1972.field_34474, class_1972.field_34474}, {class_1972.field_34474, class_1972.field_34474, class_1972.field_34474, class_1972.field_34474, class_1972.field_34474}, {class_1972.field_34474, class_1972.field_34474, class_1972.field_34474, class_1972.field_34474, class_1972.field_34474}, {class_1972.field_34475, class_1972.field_34475, class_1972.field_34475, class_1972.field_34475, class_1972.field_34475}, {class_1972.field_9443, class_1972.field_9443, class_1972.field_9415, class_1972.field_35110, class_1972.field_35110}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> SHATTERED_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("shattered_biomes/shattered_biomes_vanilla", "Appearing on shattered terrain here is the \"shattered_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\nIn slots containing \"minecraft:the_void\", biomes at the equivalent temperature/humidity index in \"middle_biomes\" will be used instead.\n", new class_5321[][]{{class_1972.field_35111, class_1972.field_35111, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {class_1972.field_35111, class_1972.field_35111, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {class_1972.field_35116, class_1972.field_35116, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473}, {class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> BEACH_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("beach_biomes/beach_biomes_vanilla", "Appearing on terrain bordering oceans, here is the \"beach_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{class_1972.field_9478, class_1972.field_9478, class_1972.field_9478, class_1972.field_9478, class_1972.field_9478}, {class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434}, {class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434}, {class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434}, {class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> PEAK_BIOMES_VARIANT_VANILLA = BYGOverworldBiomeSelectors.create("peak_biomes_variant/peak_biomes_variant_vanilla", PEAK_BIOMES_VARIANT_LAYOUT, new class_5321[][]{{class_1972.field_35115, class_1972.field_35115, class_1972.field_35115, class_1972.field_35115, class_1972.field_35115}, {class_1972.field_35115, class_1972.field_35115, class_1972.field_35115, class_1972.field_35115, class_1972.field_35115}, {class_1972.field_35115, class_1972.field_35115, class_1972.field_35115, BYGBiomes.DACITE_RIDGES, BYGBiomes.DACITE_RIDGES}, {class_1972.field_34475, class_1972.field_34475, class_1972.field_34475, class_1972.field_34475, class_1972.field_34475}, {class_1972.field_9415, class_1972.field_9415, class_1972.field_9415, class_1972.field_35110, class_1972.field_35110}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> BEACH_BIOMES_1 = BYGOverworldBiomeSelectors.create("beach_biomes/beach_biomes_1", "Appearing on terrain bordering oceans, here is the \"beach_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{class_1972.field_9478, class_1972.field_9478, class_1972.field_9478, class_1972.field_9478, class_1972.field_9478}, {class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434}, {BYGBiomes.BASALT_BARRERA, BYGBiomes.BASALT_BARRERA, BYGBiomes.BASALT_BARRERA, BYGBiomes.BASALT_BARRERA, BYGBiomes.BASALT_BARRERA}, {BYGBiomes.RAINBOW_BEACH, BYGBiomes.RAINBOW_BEACH, BYGBiomes.RAINBOW_BEACH, BYGBiomes.RAINBOW_BEACH, BYGBiomes.RAINBOW_BEACH}, {BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.WINDSWEPT_DESERT}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> PEAK_BIOMES_1 = BYGOverworldBiomeSelectors.create("peak_biomes/peak_biomes_1", "Appearing on mountainous terrain & BELOW weirdness 0, here is the \"peak_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{BYGBiomes.SHATTERED_GLACIER, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS}, {BYGBiomes.SHATTERED_GLACIER, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS}, {BYGBiomes.SHATTERED_GLACIER, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS}, {BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.GUIANA_SHIELD}, {BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.SIERRA_BADLANDS}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> SLOPE_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("slope_biomes/slope_biomes_vanilla", "Appearing on sloped terrain, near mountainous terrain, & BELOW weirdness 0, here is the \"slope_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{class_1972.field_34472, class_1972.field_34472, class_1972.field_34471, class_1972.field_34471, class_1972.field_34471}, {class_1972.field_34472, class_1972.field_34472, class_1972.field_34471, class_1972.field_34471, class_1972.field_34471}, {class_1972.field_34472, class_1972.field_34472, class_1972.field_34471, class_1972.field_34471, class_1972.field_34471}, {class_1972.field_9430, class_1972.field_9430, class_1972.field_9409, class_1972.field_9409, class_1972.field_9417}, {class_1972.field_9415, class_1972.field_9415, class_1972.field_9415, class_1972.field_35110, class_1972.field_35110}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> SLOPE_BIOMES_1 = BYGOverworldBiomeSelectors.create("slope_biomes/slope_biomes_1", "Appearing on sloped terrain, near mountainous terrain, & BELOW weirdness 0, here is the \"slope_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{BYGBiomes.SHATTERED_GLACIER, BYGBiomes.HOWLING_PEAKS, BYGBiomes.CANADIAN_SHIELD, BYGBiomes.TWILIGHT_MEADOW, BYGBiomes.BOREALIS_GROVE}, {BYGBiomes.SHATTERED_GLACIER, BYGBiomes.HOWLING_PEAKS, BYGBiomes.CANADIAN_SHIELD, BYGBiomes.TWILIGHT_MEADOW, BYGBiomes.BOREALIS_GROVE}, {BYGBiomes.SHATTERED_GLACIER, BYGBiomes.HOWLING_PEAKS, BYGBiomes.CANADIAN_SHIELD, BYGBiomes.TWILIGHT_MEADOW, BYGBiomes.BOREALIS_GROVE}, {BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.REDWOOD_THICKET, BYGBiomes.REDWOOD_THICKET, BYGBiomes.GUIANA_SHIELD}, {BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.SIERRA_BADLANDS}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> SLOPE_BIOMES_VARIANT_VANILLA = BYGOverworldBiomeSelectors.create("slope_biomes_variant/slope_biomes_variant_vanilla", SLOPE_BIOMES_VARIANT_LAYOUT, new class_5321[][]{{class_1972.field_34472, class_1972.field_34472, class_1972.field_34471, class_1972.field_34471, class_1972.field_34471}, {class_1972.field_34472, class_1972.field_34472, class_1972.field_34471, class_1972.field_34471, class_1972.field_34471}, {class_1972.field_34472, class_1972.field_34472, class_1972.field_34471, class_1972.field_34471, class_1972.field_34471}, {class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473}, {class_1972.field_9443, class_1972.field_9443, class_1972.field_9473, class_1972.field_9473, class_1972.field_9473}});
    public static final Wrapped<List<List<class_5321<class_1959>>>> OCEANS = BYGOverworldBiomeSelectors.create("oceans/oceans_1", "Appearing on terrain below sea level, here is the \"ocean_biomes\" layout:\n[ DEEP-ICY, DEEP-COLD, DEEP-NEUTRAL, DEEP-WARM, DEEP-HOT ]\n[ SHALLOW-ICY, SHALLOW-COLD, SHALLOW-NEUTRAL, SHALLOW-WARM, SHALLOW-HOT ],\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{class_1972.field_9418, class_1972.field_9467, class_1972.field_9423, BYGBiomes.LUSH_STACKS, BYGBiomes.DEAD_SEA}, {class_1972.field_9435, class_1972.field_9467, class_1972.field_9423, BYGBiomes.LUSH_STACKS, BYGBiomes.DEAD_SEA}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> MIDDLE_BIOMES_1 = BYGOverworldBiomeSelectors.create("middle_biomes/middle_biomes_1", "Appearing on terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"middle_biomes_variants\", here is the \"middle_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.FROSTED_CONIFEROUS_FOREST, BYGBiomes.CONIFEROUS_FOREST}, {BYGBiomes.AUTUMNAL_VALLEY, BYGBiomes.AUTUMNAL_VALLEY, BYGBiomes.SKYRIS_VALE, BYGBiomes.SKYRIS_VALE, BYGBiomes.CIKA_WOODS}, {BYGBiomes.PRAIRIE, BYGBiomes.ALLIUM_FIELDS, BYGBiomes.ALLIUM_FIELDS, BYGBiomes.RED_OAK_FOREST, BYGBiomes.TEMPERATE_RAINFOREST}, {BYGBiomes.ARAUCARIA_SAVANNA, BYGBiomes.ARAUCARIA_SAVANNA, BYGBiomes.AMARANTH_FIELDS, BYGBiomes.EBONY_WOODS, BYGBiomes.JACARANDA_FOREST}, {BYGBiomes.MOJAVE_DESERT, BYGBiomes.MOJAVE_DESERT, BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.ATACAMA_DESERT, BYGBiomes.ATACAMA_DESERT}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> MIDDLE_BIOMES_2 = BYGOverworldBiomeSelectors.create("middle_biomes/middle_biomes_2", "Appearing on terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"middle_biomes_variants\", here is the \"middle_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.FROSTED_TAIGA, BYGBiomes.FROSTED_TAIGA, BYGBiomes.AUTUMNAL_TAIGA}, {BYGBiomes.COCONINO_MEADOW, BYGBiomes.COCONINO_MEADOW, BYGBiomes.MAPLE_TAIGA, BYGBiomes.AUTUMNAL_FOREST, BYGBiomes.AUTUMNAL_FOREST}, {BYGBiomes.PRAIRIE, BYGBiomes.ORCHARD, BYGBiomes.ORCHARD, BYGBiomes.ASPEN_FOREST, BYGBiomes.WEEPING_WITCH_FOREST}, {BYGBiomes.BAOBAB_SAVANNA, BYGBiomes.BAOBAB_SAVANNA, BYGBiomes.RED_OAK_FOREST, BYGBiomes.CRAG_GARDENS, BYGBiomes.TROPICAL_RAINFOREST}, {BYGBiomes.MOJAVE_DESERT, BYGBiomes.MOJAVE_DESERT, BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.ATACAMA_DESERT, BYGBiomes.ATACAMA_DESERT}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> MIDDLE_BIOMES_3 = BYGOverworldBiomeSelectors.create("middle_biomes/middle_biomes_3", "Appearing on terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"middle_biomes_variants\", here is the \"middle_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.FROSTED_CONIFEROUS_FOREST, BYGBiomes.FROSTED_TAIGA, BYGBiomes.BLACK_FOREST}, {BYGBiomes.COCONINO_MEADOW, BYGBiomes.COCONINO_MEADOW, BYGBiomes.MAPLE_TAIGA, BYGBiomes.ZELKOVA_FOREST, BYGBiomes.DACITE_RIDGES}, {BYGBiomes.PRAIRIE, BYGBiomes.PRAIRIE, BYGBiomes.ALLIUM_FIELDS, BYGBiomes.ASPEN_FOREST, BYGBiomes.TEMPERATE_RAINFOREST}, {BYGBiomes.FIRECRACKER_SHRUBLAND, BYGBiomes.FIRECRACKER_SHRUBLAND, BYGBiomes.AMARANTH_FIELDS, BYGBiomes.FORGOTTEN_FOREST, BYGBiomes.FRAGMENT_FOREST}, {BYGBiomes.MOJAVE_DESERT, BYGBiomes.MOJAVE_DESERT, BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.ATACAMA_DESERT, BYGBiomes.ATACAMA_DESERT}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> PLATEAU_BIOMES_1 = BYGOverworldBiomeSelectors.create("plateau_biomes/plateau_biomes_1", "Appearing on elevated flat terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"plateau_biome_variants\", here is the \"plateau_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.FROSTED_CONIFEROUS_FOREST, BYGBiomes.FROSTED_TAIGA, BYGBiomes.CONIFEROUS_FOREST}, {BYGBiomes.COCONINO_MEADOW, BYGBiomes.COCONINO_MEADOW, BYGBiomes.ASPEN_FOREST, BYGBiomes.SKYRIS_VALE, BYGBiomes.SKYRIS_VALE}, {BYGBiomes.GROVE, BYGBiomes.GROVE, BYGBiomes.GROVE, BYGBiomes.ROSE_FIELDS, BYGBiomes.DACITE_RIDGES}, {BYGBiomes.BAOBAB_SAVANNA, BYGBiomes.BAOBAB_SAVANNA, BYGBiomes.TEMPERATE_RAINFOREST, BYGBiomes.EBONY_WOODS, BYGBiomes.JACARANDA_FOREST}, {BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.SIERRA_BADLANDS}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> PLATEAU_BIOMES_2 = BYGOverworldBiomeSelectors.create("plateau_biomes/plateau_biomes_2", "Appearing on elevated flat terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"plateau_biome_variants\", here is the \"plateau_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.FROSTED_CONIFEROUS_FOREST, BYGBiomes.FROSTED_TAIGA, BYGBiomes.CONIFEROUS_FOREST}, {BYGBiomes.COCONINO_MEADOW, BYGBiomes.COCONINO_MEADOW, BYGBiomes.BLACK_FOREST, BYGBiomes.BLACK_FOREST, BYGBiomes.AUTUMNAL_TAIGA}, {BYGBiomes.CHERRY_BLOSSOM_FOREST, BYGBiomes.CHERRY_BLOSSOM_FOREST, BYGBiomes.CHERRY_BLOSSOM_FOREST, BYGBiomes.ROSE_FIELDS, BYGBiomes.WEEPING_WITCH_FOREST}, {BYGBiomes.ARAUCARIA_SAVANNA, BYGBiomes.ARAUCARIA_SAVANNA, BYGBiomes.RED_OAK_FOREST, BYGBiomes.EBONY_WOODS, BYGBiomes.TROPICAL_RAINFOREST}, {BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.SIERRA_BADLANDS}});
    protected static final Wrapped<List<List<class_5321<class_1959>>>> PLATEAU_BIOMES_3 = BYGOverworldBiomeSelectors.create("plateau_biomes/plateau_biomes_3", "Appearing on elevated flat terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"plateau_biome_variants\", here is the \"plateau_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new class_5321[][]{{BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.FROSTED_CONIFEROUS_FOREST, BYGBiomes.FROSTED_TAIGA, BYGBiomes.CONIFEROUS_FOREST}, {BYGBiomes.COCONINO_MEADOW, BYGBiomes.COCONINO_MEADOW, BYGBiomes.CIKA_WOODS, BYGBiomes.CIKA_WOODS, BYGBiomes.AUTUMNAL_TAIGA}, {BYGBiomes.GROVE, BYGBiomes.GROVE, BYGBiomes.GROVE, BYGBiomes.ROSE_FIELDS, BYGBiomes.WEEPING_WITCH_FOREST}, {BYGBiomes.FIRECRACKER_SHRUBLAND, BYGBiomes.FIRECRACKER_SHRUBLAND, BYGBiomes.REDWOOD_THICKET, BYGBiomes.EBONY_WOODS, BYGBiomes.FORGOTTEN_FOREST}, {BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.SIERRA_BADLANDS}});

    private static String invalidKeysOkay(String fallback) {
        return String.format("All keys passed in must be valid in the biome registry!\nIn slots containing \"minecraft:the_void\", biomes at the equivalent temperature/humidity index in \"%s\" will be used instead.\n", fallback);
    }

    protected static Wrapped<List<List<class_5321<class_1959>>>> create(String id, String header, class_5321<class_1959>[][] biomeKeys) {
        return BYGOverworldBiomeSelectors.create(id, biomeKeys, (Map<String, String>)ImmutableMap.of((Object)"", (Object)("/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n" + header + "*/")));
    }

    protected static Wrapped<List<List<class_5321<class_1959>>>> create(String id, class_5321<class_1959>[][] biomeKeys) {
        return BYGOverworldBiomeSelectors.create(id, biomeKeys, new HashMap<String, String>());
    }

    protected static Wrapped<List<List<class_5321<class_1959>>>> create(String id, class_5321<class_1959>[][] biomeKeys, Map<String, String> comments) {
        Wrapped result = new Wrapped(Optional.of(id), BYGUtil.convert2DArray(biomeKeys));
        BIOME_LAYOUTS.put(id, (Pair<Map<String, String>, Wrapped<List<List<class_5321<class_1959>>>>>)Pair.of(comments, (Object)result));
        return result;
    }
}

