/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4657;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.reg.RegistryObject;

public class BYGMushroomConfig
implements class_3037 {
    public static final Codec<BYGMushroomConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)class_4651.field_24937.fieldOf("stem_provider").forGetter(config -> config.stemProvider), (App)class_4651.field_24937.fieldOf("mushroom_provider").forGetter(config -> config.mushroomProvider), (App)class_4651.field_24937.fieldOf("mushroom2_provider").forGetter(config -> config.mushroomProvider), (App)class_4651.field_24937.fieldOf("mushroom3_provider").forGetter(config -> config.mushroomProvider), (App)class_4651.field_24937.fieldOf("pollen_provider").forGetter(config -> config.pollenProvider), (App)Codec.INT.fieldOf("min_height").orElse((Object)15).forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_height").orElse((Object)1).forGetter(config -> config.maxPossibleHeight)).apply((Applicative)codecRecorder, BYGMushroomConfig::new));
    private final class_4651 stemProvider;
    private final class_4651 mushroomProvider;
    private final class_4651 mushroom2Provider;
    private final class_4651 mushroom3Provider;
    private final class_4651 pollenProvider;
    private final int minHeight;
    private final int maxPossibleHeight;
    private boolean forcedPlacement = false;

    BYGMushroomConfig(class_4651 stemProvider, class_4651 mushroomProvider, class_4651 mushroom2Provider, class_4651 mushroom3Provider, class_4651 pollenProvider, int minHeight, int maxPossibleHeight) {
        this.stemProvider = stemProvider;
        this.mushroomProvider = mushroomProvider;
        this.mushroom2Provider = mushroom2Provider;
        this.mushroom3Provider = mushroom3Provider;
        this.pollenProvider = pollenProvider;
        this.minHeight = minHeight;
        this.maxPossibleHeight = maxPossibleHeight;
    }

    public void forcePlacement() {
        this.forcedPlacement = true;
    }

    public class_4651 getStemProvider() {
        return this.stemProvider;
    }

    public class_4651 getMushroomProvider() {
        return this.mushroomProvider;
    }

    public class_4651 getMushroom2Provider() {
        return this.mushroom2Provider;
    }

    public class_4651 getMushroom3Provider() {
        return this.mushroom3Provider;
    }

    public class_4651 getPollenProvider() {
        return this.pollenProvider;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxPossibleHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public boolean isPlacementForced() {
        return this.forcedPlacement;
    }

    public static class Builder {
        private class_4651 stemProvider = class_4656.method_38433((class_2680)class_2246.field_10431.method_9564());
        private class_4651 mushroomProvider;
        private class_4651 mushroom2Provider = this.mushroomProvider = class_4656.method_38433((class_2680)class_2246.field_10503.method_9564());
        private class_4651 mushroom3Provider = this.mushroomProvider;
        private class_4651 pollenProvider = class_4656.method_38433((class_2680)BYGBlocks.POLLEN_BLOCK.defaultBlockState());
        private int minHeight = 15;
        private int maxPossibleHeight = 1;

        public Builder setStemBlock(RegistryObject<? extends class_2248> block) {
            return this.setStemBlock(block.get());
        }

        public Builder setStemBlock(class_2248 block) {
            this.stemProvider = block != null ? class_4656.method_38433((class_2680)block.method_9564()) : class_4656.method_38433((class_2680)class_2246.field_10431.method_9564());
            return this;
        }

        public Builder setStemBlock(class_2680 state) {
            this.stemProvider = state != null ? class_4656.method_38433((class_2680)state) : class_4656.method_38433((class_2680)class_2246.field_10431.method_9564());
            return this;
        }

        public Builder setMushroomBlock(class_2248 block) {
            this.mushroomProvider = block != null ? class_4656.method_38433((class_2680)block.method_9564()) : class_4656.method_38433((class_2680)class_2246.field_10503.method_9564());
            return this;
        }

        public Builder setMushroomBlock(class_2680 state) {
            this.mushroomProvider = state != null ? class_4656.method_38433((class_2680)state) : class_4656.method_38433((class_2680)class_2246.field_10503.method_9564());
            return this;
        }

        public Builder setMushroomBlock(class_4657 statesList) {
            this.mushroomProvider = statesList != null ? statesList : class_4656.method_38433((class_2680)class_2246.field_10503.method_9564());
            return this;
        }

        public Builder setMushroom2Block(class_2248 block) {
            this.mushroom2Provider = block != null ? class_4656.method_38433((class_2680)block.method_9564()) : this.mushroomProvider;
            return this;
        }

        public Builder setMushroom2Block(class_2680 state) {
            this.mushroom2Provider = state != null ? class_4656.method_38433((class_2680)state) : this.mushroomProvider;
            return this;
        }

        public Builder setMushroom3Block(class_2248 block) {
            this.mushroom3Provider = block != null ? class_4656.method_38433((class_2680)block.method_9564()) : this.mushroomProvider;
            return this;
        }

        public Builder setMushroom3Block(class_2680 state) {
            this.mushroom3Provider = state != null ? class_4656.method_38433((class_2680)state) : this.mushroomProvider;
            return this;
        }

        public Builder setPollenBlock(class_2248 block) {
            this.mushroom3Provider = block != null ? class_4656.method_38433((class_2680)block.method_9564()) : this.mushroomProvider;
            return this;
        }

        public Builder setPollenBlock(class_2680 state) {
            this.mushroom3Provider = state != null ? class_4656.method_38433((class_2680)state) : this.mushroomProvider;
            return this;
        }

        public Builder setMinHeight(int minHeight) {
            this.minHeight = minHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxPossibleHeight = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder copy(BYGMushroomConfig config) {
            this.maxPossibleHeight = config.maxPossibleHeight;
            this.minHeight = config.minHeight;
            this.stemProvider = config.stemProvider;
            this.mushroomProvider = config.mushroomProvider;
            this.mushroom2Provider = config.mushroom2Provider;
            this.mushroom3Provider = config.mushroom3Provider;
            this.pollenProvider = config.pollenProvider;
            return this;
        }

        public BYGMushroomConfig build() {
            return new BYGMushroomConfig(this.stemProvider, this.mushroomProvider, this.mushroom2Provider, this.mushroom3Provider, this.pollenProvider, this.minHeight, this.maxPossibleHeight);
        }
    }
}

