/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.bytes.Byte2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5821;
import net.minecraft.class_6568;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;
import potionstudios.byg.mixin.access.ChunkAccessAccess;
import potionstudios.byg.util.DuneCache;

public class DuneFeature
extends class_3031<class_3111> {
    protected static FastNoise fastNoise;
    protected static FastNoise fastNoise1;
    protected static FastNoise dunePeakNoise1;
    protected static FastNoise dunePeakNoise2;
    protected long seed;
    public static final double FREQUENCY = 0.006896551724137931;
    public static final double FREQUENCY_1 = 0.004;

    public DuneFeature(Codec<class_3111> $$0) {
        super($$0);
    }

    public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
        class_2794 chunkGenerator = featurePlaceContext.method_33653();
        class_5281 level = featurePlaceContext.method_33652();
        this.setSeed(level.method_8412(), 0.0068965517f);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_3218 serverLevel = level.method_8410();
        DuneCache duneCache = (DuneCache)serverLevel;
        Long2ObjectOpenHashMap<Byte2ObjectOpenHashMap<class_5321<class_1959>>> biomeAt = duneCache.getBiomeAt();
        if (biomeAt.size() > 4096) {
            biomeAt.clear();
        }
        Long2ObjectOpenHashMap<Byte2DoubleOpenHashMap> densityAt = duneCache.getDensityAt();
        for (int xMove = 0; xMove < 16; ++xMove) {
            for (int zMove = 0; zMove < 16; ++zMove) {
                mutableBlockPos.method_10101((class_2382)featurePlaceContext.method_33655()).method_10100(xMove, 0, zMove);
                class_2791 chunk = level.method_22350((class_2338)mutableBlockPos);
                float duneHeight = this.peakNoise(dunePeakNoise1, mutableBlockPos);
                float duneHeight1 = this.peakNoise(dunePeakNoise2, mutableBlockPos);
                double height = 180.0f + Math.max(duneHeight *= class_3532.method_16439((float)5.0f, (float)15.0f, (float)0.3f), duneHeight1 *= class_3532.method_16439((float)5.0f, (float)15.0f, (float)0.3f));
                class_2338.class_2339 blendingPos = new class_2338.class_2339().method_10101((class_2382)mutableBlockPos);
                double density = this.getBlendDensity(biomeAt, level, chunkGenerator, chunk, mutableBlockPos, height, 10, blendingPos, 4);
                int oceanFloor = level.method_8624(class_2902.class_2903.field_13195, mutableBlockPos.method_10263(), mutableBlockPos.method_10260());
                int blendedDuneHeight = (int)class_3532.method_15390((double)(oceanFloor - 3), (double)height, (double)(1.0 - density));
                mutableBlockPos.method_33098(blendedDuneHeight);
                for (int y = mutableBlockPos.method_10264(); y >= oceanFloor; --y) {
                    class_2680 generatingState = y == oceanFloor ? BYGBlocks.WINDSWEPT_SANDSTONE.defaultBlockState() : BYGBlocks.WINDSWEPT_SAND.defaultBlockState();
                    int localX = mutableBlockPos.method_10263() & 0xF;
                    int localZ = mutableBlockPos.method_10260() & 0xF;
                    chunk.method_12032(class_2902.class_2903.field_13195).method_12597(localX, mutableBlockPos.method_10264(), localZ, generatingState);
                    chunk.method_12032(class_2902.class_2903.field_13194).method_12597(localX, mutableBlockPos.method_10264(), localZ, generatingState);
                    level.method_8652((class_2338)mutableBlockPos, generatingState, 2);
                    mutableBlockPos.method_10098(class_2350.field_11033);
                }
            }
        }
        return true;
    }

    private double getBlendDensity(Long2ObjectOpenHashMap<Byte2ObjectOpenHashMap<class_5321<class_1959>>> biomeAt, class_5281 level, class_2794 generator, class_2791 chunk, class_2338.class_2339 mutableBlockPos, double height, int blendRange, class_2338.class_2339 blendingPos, int precision) {
        double density = 0.0;
        for (int x = -blendRange; x <= blendRange; x += precision) {
            for (int z = -blendRange; z <= blendRange; z += precision) {
                boolean caveCheck;
                blendingPos.method_10101((class_2382)mutableBlockPos).method_10100(x, 0, z);
                int worldSurfaceHeight = level.method_8624(class_2902.class_2903.field_13194, blendingPos.method_10263(), blendingPos.method_10260());
                blendingPos.method_33098(worldSurfaceHeight);
                Byte2ObjectOpenHashMap localResourceKey = (Byte2ObjectOpenHashMap)biomeAt.computeIfAbsent(class_1923.method_37232((class_2338)blendingPos), key -> new Byte2ObjectOpenHashMap());
                class_5321 biomeResourceKey = (class_5321)localResourceKey.computeIfAbsent(DuneCache.getLocalPackedCoord((class_2338)blendingPos), key -> (class_5321)level.method_23753((class_2338)blendingPos).method_40230().orElseThrow());
                boolean outsideBiome = (double)worldSurfaceHeight < height;
                class_6568 noiseChunk = ((ChunkAccessAccess)chunk).byg_getNoiseChunk();
                boolean abovePreliminarySurface = noiseChunk != null && noiseChunk.method_39900(mutableBlockPos.method_10263(), mutableBlockPos.method_10260()) > worldSurfaceHeight;
                boolean bl = caveCheck = worldSurfaceHeight < generator.method_16398() || abovePreliminarySurface;
                if (caveCheck) {
                    density += 1.0 / (double)precision / (double)(blendRange * blendRange) * 4.0;
                }
                if (!outsideBiome) continue;
                density += 1.0 / (double)precision / (double)(blendRange * blendRange) * 2.0;
            }
        }
        return Math.min(density, 1.0);
    }

    private float peakNoise(FastNoise noise, class_2338.class_2339 mutableBlockPos) {
        noise.SetFrequency(0.023f);
        noise.SetNoiseType(FastNoise.NoiseType.Cellular);
        noise.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Euclidean);
        noise.SetCellularReturnType(FastNoise.CellularReturnType.Distance2Mul);
        noise.SetGradientPerturbAmp(1.5f);
        return 1.0f - noise.GetNoise(mutableBlockPos.method_10263(), 0.0f, mutableBlockPos.method_10260());
    }

    public void setSeed(long seed, float noiseFreq) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            fastNoise.SetFractalType(FastNoise.FractalType.RigidMulti);
            fastNoise.SetFractalOctaves(2);
            this.seed = seed;
            fastNoise1 = new FastNoise((int)seed);
            dunePeakNoise1 = new FastNoise((int)seed);
            dunePeakNoise2 = new FastNoise((int)seed + 76457567);
        }
    }
}

