/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.serialization;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.config.serialization.ConfigDataSet;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public final class ConfigDataSetImpl<T>
implements ConfigDataSet<T> {
    private static final Set<Class<?>> SUPPORTED_DATA_TYPES = ImmutableSet.of(Boolean.class, Integer.class, Double.class, String.class);
    private final class_2378<T> activeRegistry;
    private final List<EntryHolder<?, T>> values = Lists.newArrayList();
    private final BiPredicate<Integer, Object> filter;
    private Map<T, Object[]> dissolved;

    ConfigDataSetImpl(class_2378<T> registry, List<String> values, BiPredicate<Integer, Object> filter, Class<?> ... types) {
        this.activeRegistry = registry;
        this.filter = filter;
        for (Class<?> clazz : types) {
            if (SUPPORTED_DATA_TYPES.contains(clazz)) continue;
            throw new IllegalArgumentException("data type of clazz %s is not supported".formatted(clazz));
        }
        for (String value : values) {
            this.deserialize(value, types).ifPresent(this.values::add);
        }
    }

    @Override
    public Map<T, Object[]> toMap() {
        this.dissolve();
        return this.dissolved;
    }

    private void dissolve() {
        if (this.dissolved == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (EntryHolder<?, T> holder : this.values) {
                if (!(holder instanceof TagEntryHolder)) continue;
                this.dissolveHolder(holder, arg_0 -> ((ImmutableMap.Builder)builder).putAll(arg_0));
            }
            for (EntryHolder<?, T> holder : this.values) {
                if (!(holder instanceof RegistryEntryHolder)) continue;
                this.dissolveHolder(holder, arg_0 -> ((ImmutableMap.Builder)builder).putAll(arg_0));
            }
            this.dissolved = builder.build();
        }
    }

    private void dissolveHolder(EntryHolder<?, T> holder, Consumer<Map<T, Object[]>> builder) {
        HashMap entries = Maps.newHashMap();
        holder.dissolve(entries);
        entries.keySet().removeIf(e -> !this.filter.test(0, e));
        builder.accept(entries);
    }

    private Optional<EntryHolder<?, T>> deserialize(String source, Class<?>[] types) {
        String[] sources = source.trim().split(",");
        Object[] data = new Object[types.length];
        try {
            for (int i = 0; i < types.length; ++i) {
                if (sources.length - 1 <= i) {
                    throw new IllegalArgumentException("data index out of bounds, index was %s, but length is %s".formatted(i + 1, sources.length));
                }
                data[i] = ConfigDataSetImpl.deserializeData(types[i], sources[i + 1].trim());
                if (this.filter.test(i + 1, data[i])) continue;
                throw new IllegalStateException("data %s at index %s from source entry %s does not satisfy filter".formatted(data[i], i, source));
            }
            return Optional.of(this.deserialize(sources[0].trim()).withData(data));
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.warn("Unable to parse entry {}", (Object)source, (Object)e);
            return Optional.empty();
        }
    }

    private EntryHolder<?, T> deserialize(String source) throws RuntimeException {
        String[] splitSource = source.split(":");
        return switch (splitSource.length) {
            case 1 -> {
                if (splitSource[0].startsWith("#")) {
                    yield this.makeHolder("#minecraft", splitSource[0].substring(1));
                }
                yield this.makeHolder("minecraft", splitSource[0]);
            }
            case 2 -> this.makeHolder(splitSource[0], splitSource[1]);
            default -> throw new IllegalArgumentException("%s is no valid resource location format".formatted(source));
        };
    }

    private EntryHolder<?, T> makeHolder(String namespace, String path) throws RuntimeException {
        if (namespace.isEmpty() || path.isEmpty()) {
            throw new IllegalArgumentException("%s:%s is no valid resource location format".formatted(namespace, path));
        }
        if (namespace.startsWith("#")) {
            return new TagEntryHolder<T>(this.activeRegistry, namespace.substring(1), path);
        }
        return new RegistryEntryHolder<T>(this.activeRegistry, namespace, path);
    }

    private static Object deserializeData(Class<?> clazz, String source) throws RuntimeException {
        if (clazz == Boolean.class) {
            if (source.equals("true")) {
                return true;
            }
            if (source.equals("false")) {
                return false;
            }
            throw new IllegalArgumentException("%s is not a boolean value".formatted(source));
        }
        if (clazz == Integer.class) {
            return Integer.parseInt(source);
        }
        if (clazz == Double.class) {
            return Double.parseDouble(source);
        }
        if (clazz == String.class) {
            return source;
        }
        throw new IllegalArgumentException("data type of clazz %s is not supported".formatted(clazz));
    }

    private static abstract class EntryHolder<D, E> {
        protected final class_2378<E> activeRegistry;
        private final String namespace;
        private final String path;
        private Object[] data = new Object[0];

        protected EntryHolder(class_2378<E> registry, String namespace, String path) {
            this.activeRegistry = registry;
            this.namespace = namespace;
            this.path = path;
        }

        public EntryHolder<D, E> withData(Object[] data) {
            this.data = data;
            return this;
        }

        public final void dissolve(Map<E, Object[]> entries) {
            this.findRegistryMatches(this.namespace, this.path).stream().flatMap(this::dissolveValue).forEach(value -> entries.put(value, this.data));
        }

        private Collection<D> findRegistryMatches(String namespace, String path) {
            HashSet matches = Sets.newHashSet();
            if (!path.contains("*")) {
                this.toValue(new class_2960(namespace, path)).ifPresent(matches::add);
            } else {
                String regexPath = path.replace("*", "[a-z0-9/._-]*");
                this.allValues().filter(entry -> ((class_2960)entry.getKey()).method_12836().equals(namespace)).filter(entry -> ((class_2960)entry.getKey()).method_12832().matches(regexPath)).map(Map.Entry::getValue).forEach(matches::add);
            }
            if (this.activeRegistry != null && matches.isEmpty()) {
                PuzzlesLib.LOGGER.warn("Unable to parse entry {}:{}: No matches found in registry {}", new Object[]{namespace, path, this.activeRegistry.method_30517().method_29177()});
            }
            return matches;
        }

        protected abstract Stream<E> dissolveValue(D var1);

        protected abstract Optional<D> toValue(class_2960 var1);

        protected abstract Stream<Map.Entry<class_2960, D>> allValues();
    }

    private static class TagEntryHolder<E>
    extends EntryHolder<class_6862<E>, E> {
        TagEntryHolder(class_2378<E> registry, String namespace, String path) {
            super(registry, namespace, path);
        }

        @Override
        public Stream<E> dissolveValue(class_6862<E> entry) {
            return StreamSupport.stream(this.activeRegistry.method_40286(entry).spliterator(), false).map(class_6880::comp_349);
        }

        @Override
        protected Optional<class_6862<E>> toValue(class_2960 identifier) {
            class_6862 tag = class_6862.method_40092((class_5321)this.activeRegistry.method_30517(), (class_2960)identifier);
            if (!this.activeRegistry.method_40252(tag)) {
                return Optional.empty();
            }
            return Optional.of(tag);
        }

        @Override
        protected Stream<Map.Entry<class_2960, class_6862<E>>> allValues() {
            return this.activeRegistry.method_40273().collect(Collectors.toMap(class_6862::comp_327, Function.identity())).entrySet().stream();
        }
    }

    private static class RegistryEntryHolder<E>
    extends EntryHolder<E, E> {
        RegistryEntryHolder(class_2378<E> registry, String namespace, String path) {
            super(registry, namespace, path);
        }

        @Override
        protected Stream<E> dissolveValue(E entry) {
            return Stream.of(entry);
        }

        @Override
        protected Optional<E> toValue(class_2960 identifier) {
            if (!this.activeRegistry.method_10250(identifier)) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.activeRegistry.method_10223(identifier));
        }

        @Override
        protected Stream<Map.Entry<class_2960, E>> allValues() {
            return this.activeRegistry.method_29722().stream().collect(Collectors.toMap(e -> ((class_5321)e.getKey()).method_29177(), Map.Entry::getValue)).entrySet().stream();
        }
    }
}

