/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.init;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fuzs.puzzleslib.core.ModLoader;
import fuzs.puzzleslib.init.FabricRegistryReference;
import fuzs.puzzleslib.init.RegistryManager;
import fuzs.puzzleslib.init.RegistryReference;
import fuzs.puzzleslib.init.builder.ExtendedModMenuSupplier;
import fuzs.puzzleslib.init.builder.ModBlockEntityTypeBuilder;
import fuzs.puzzleslib.init.builder.ModMenuSupplier;
import fuzs.puzzleslib.init.builder.ModPoiTypeBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1703;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class FabricRegistryManager
implements RegistryManager {
    private static final Map<String, FabricRegistryManager> MOD_TO_REGISTRY = Maps.newConcurrentMap();
    private final String namespace;
    private final boolean deferred;
    private final Multimap<class_5321<? extends class_2378<?>>, Runnable> registryToFactory = ArrayListMultimap.create();
    @Nullable
    private Set<ModLoader> allowedModLoaders;

    private FabricRegistryManager(String modId, boolean deferred) {
        this.namespace = modId;
        this.deferred = deferred;
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public RegistryManager whenOn(ModLoader ... allowedModLoaders) {
        if (allowedModLoaders.length == 0) {
            throw new IllegalArgumentException("Must provide at least one mod loader to register on");
        }
        this.allowedModLoaders = ImmutableSet.copyOf((Object[])allowedModLoaders);
        return this;
    }

    @Override
    public void applyRegistration() {
        if (!this.deferred || this.registryToFactory.isEmpty()) {
            throw new IllegalStateException("No registry entries available for deferred registration");
        }
        this.registryToFactory.get((Object)class_2378.field_25105).forEach(Runnable::run);
        this.registryToFactory.get((Object)class_2378.field_25108).forEach(Runnable::run);
        for (Map.Entry entry : this.registryToFactory.asMap().entrySet()) {
            if (entry.getKey() == class_2378.field_25105 || entry.getKey() == class_2378.field_25108) continue;
            ((Collection)entry.getValue()).forEach(Runnable::run);
        }
    }

    @Override
    public <T> RegistryReference<T> register(class_5321<? extends class_2378<? super T>> registryKey, String path, Supplier<T> supplier) {
        Set<ModLoader> modLoaders = this.allowedModLoaders;
        this.allowedModLoaders = null;
        if (!this.deferred) {
            return this.actuallyRegister(registryKey, path, supplier, modLoaders);
        }
        this.registryToFactory.put(registryKey, () -> this.actuallyRegister(registryKey, path, supplier, modLoaders));
        return this.placeholder(registryKey, path);
    }

    private <T> RegistryReference<T> actuallyRegister(class_5321<? extends class_2378<? super T>> registryKey, String path, Supplier<T> supplier, @Nullable Set<ModLoader> modLoaders) {
        if (modLoaders != null && !modLoaders.contains((Object)ModLoader.FABRIC)) {
            return this.placeholder(registryKey, path);
        }
        T value = supplier.get();
        class_2378 registry = (class_2378)class_2378.field_11144.method_10223(registryKey.method_29177());
        Objects.requireNonNull(value, "Can't register null value");
        Objects.requireNonNull(registry, "Registry %s not found".formatted(registryKey));
        class_2960 key = this.makeKey(path);
        class_2378.method_10230((class_2378)registry, (class_2960)key, value);
        return new FabricRegistryReference<T>(value, key, registry);
    }

    @Override
    public <T extends class_2586> RegistryReference<class_2591<T>> registerBlockEntityTypeBuilder(String path, Supplier<ModBlockEntityTypeBuilder<T>> entry) {
        return this.registerBlockEntityType(path, () -> {
            ModBlockEntityTypeBuilder builder = (ModBlockEntityTypeBuilder)entry.get();
            return class_2591.class_2592.method_20528(builder.factory()::create, (class_2248[])builder.blocks()).method_11034(null);
        });
    }

    @Override
    public <T extends class_1703> RegistryReference<class_3917<T>> registerMenuTypeSupplier(String path, Supplier<ModMenuSupplier<T>> entry) {
        return this.registerMenuType(path, () -> new class_3917(((ModMenuSupplier)entry.get())::create));
    }

    @Override
    public <T extends class_1703> RegistryReference<class_3917<T>> registerExtendedMenuTypeSupplier(String path, Supplier<ExtendedModMenuSupplier<T>> entry) {
        return this.registerMenuType(path, () -> new ExtendedScreenHandlerType(((ExtendedModMenuSupplier)entry.get())::create));
    }

    @Override
    public RegistryReference<class_4158> registerPoiTypeBuilder(String path, Supplier<ModPoiTypeBuilder> entry) {
        ModPoiTypeBuilder builder = entry.get();
        class_2960 key = this.makeKey(path);
        class_4158 value = PointOfInterestHelper.register((class_2960)key, (int)builder.ticketCount(), (int)builder.searchDistance(), builder.blocks());
        return new FabricRegistryReference<class_4158>(value, key, class_2378.field_18792);
    }

    public static synchronized RegistryManager of(String modId, boolean deferred) {
        FabricRegistryManager registryManager = MOD_TO_REGISTRY.computeIfAbsent(modId, modId1 -> new FabricRegistryManager((String)modId1, deferred));
        if (deferred != registryManager.deferred) {
            throw new IllegalArgumentException("deferred: %s does not match value set for existing RegistryManager".formatted(deferred));
        }
        return registryManager;
    }
}

