/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.options.preview;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigOptions;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;

public class TooltipPreviewer {
    public static WidgetWithBounds create(ConfigAccess access, int width, @Nullable IntSupplier height) {
        Rectangle bounds = new Rectangle();
        return Widgets.withBounds(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            EntryStack<class_1799> stack = EntryStacks.of((class_1935)class_1802.field_8118);
            boolean appendModNames = access.get(AllREIConfigOptions.APPEND_MOD_NAMES);
            boolean appendFavorites = access.get(AllREIConfigOptions.APPEND_FAVORITES_HINT);
            ArrayList<Tooltip.Entry> entries = new ArrayList<Tooltip.Entry>();
            entries.add(Tooltip.entry((class_2561)ConfigUtils.translatable("block.minecraft.oak_planks")));
            if (appendModNames) {
                entries.add(Tooltip.entry((class_2561)ConfigUtils.literal("Minecraft").method_27695(new class_124[]{class_124.field_1078, class_124.field_1056})));
            }
            if (appendFavorites) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                entries.addAll(Stream.of(class_1074.method_4662((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(ConfigUtils::literal).map(Tooltip::entry).toList());
            }
            List components = entries.stream().flatMap(entry -> class_310.method_1551().field_1772.method_1728((class_5348)entry.getAsText(), width - 12 - 4).stream()).toList();
            int minWidth = components.stream().mapToInt(component -> class_310.method_1551().field_1772.method_30880(component)).max().orElse(0) + 4;
            int minHeight = components.stream().mapToInt(component -> components.get(0) == component && components.size() >= 2 ? 12 : 10).sum() + 4;
            int tX = Math.max(6, (width - minWidth) / 2);
            int tWidth = Math.min(width - 12, minWidth);
            int tY = 28;
            int tHeight = Math.min(minHeight, height == null ? 100000 : height.getAsInt() - tY - 4);
            matrices.method_22903();
            matrices.method_22904(0.0, height == null ? 4.0 : (double)Math.max(0, (height.getAsInt() - (tY + tHeight)) / 2), 400.0);
            bounds.setSize(width, height == null ? tY + tHeight + 12 : height.getAsInt());
            stack.getRenderer().render(stack, matrices, new Rectangle(width / 2 - 12, 0, 24, 24), mouseX, mouseY, delta);
            matrices.method_22904(0.0, 0.0, -400.0);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            RenderSystem.setShader(class_757::method_34540);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            class_1159 matrix4f = matrices.method_23760().method_23761();
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY - 4, tX + tWidth + 3, tY - 3, 400, -267386864, -267386864);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY + tHeight + 3, tX + tWidth + 3, tY + tHeight + 4, 400, -267386864, -267386864);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY - 3, tX + tWidth + 3, tY + tHeight + 3, 400, -267386864, -267386864);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 4, tY - 3, tX - 3, tY + tHeight + 3, 400, -267386864, -267386864);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX + tWidth + 3, tY - 3, tX + tWidth + 4, tY + tHeight + 3, 400, -267386864, -267386864);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY - 3 + 1, tX - 3 + 1, tY + tHeight + 3 - 1, 400, 0x505000FF, 1344798847);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX + tWidth + 2, tY - 3 + 1, tX + tWidth + 3, tY + tHeight + 3 - 1, 400, 0x505000FF, 1344798847);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY - 3, tX + tWidth + 3, tY - 3 + 1, 400, 0x505000FF, 0x505000FF);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY + tHeight + 2, tX + tWidth + 3, tY + tHeight + 3, 400, 1344798847, 1344798847);
            RenderSystem.enableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            RenderSystem.disableBlend();
            RenderSystem.enableTexture();
            matrices.method_22904(0.0, 0.0, 400.0);
            for (int i = 0; i < components.size(); ++i) {
                class_310.method_1551().field_1772.method_27528(matrices, (class_5481)components.get(i), (float)(tX + 2), (float)(tY + 2), -1);
                tY += 10 + (i == 0 ? 2 : 0);
            }
            matrices.method_22909();
        }), bounds);
    }

    private static void fillGradient(class_1159 pose, class_287 builder, int x1, int y1, int x2, int y2, int blitOffset, int color1, int color2) {
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float g = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float h = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float i = (float)(color1 & 0xFF) / 255.0f;
        float j = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float k = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float l = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float m = (float)(color2 & 0xFF) / 255.0f;
        builder.method_22918(pose, (float)x2, (float)y1, (float)blitOffset).method_22915(g, h, i, f).method_1344();
        builder.method_22918(pose, (float)x1, (float)y1, (float)blitOffset).method_22915(g, h, i, f).method_1344();
        builder.method_22918(pose, (float)x1, (float)y2, (float)blitOffset).method_22915(k, l, m, j).method_1344();
        builder.method_22918(pose, (float)x2, (float)y2, (float)blitOffset).method_22915(k, l, m, j).method_1344();
    }
}

