/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CompositeDisplayViewingScreen
extends AbstractDisplayViewingScreen {
    private final List<Widget> widgets = Lists.newArrayList();
    private final List<Button> buttonList = Lists.newArrayList();
    private final List<DisplayRenderer> displayRenderers = Lists.newArrayList();
    public Rectangle scrollListBounds;
    private int selectedRecipeIndex = 0;
    private final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return new Rectangle(CompositeDisplayViewingScreen.this.scrollListBounds.x + 1, CompositeDisplayViewingScreen.this.scrollListBounds.y + 1, CompositeDisplayViewingScreen.this.scrollListBounds.width - 2, CompositeDisplayViewingScreen.this.scrollListBounds.height - 2);
        }

        public int getMaxScrollHeight() {
            int i = 0;
            for (Button button : CompositeDisplayViewingScreen.this.buttonList) {
                i += button.getBounds().height;
            }
            return i;
        }
    };
    private float scrollBarAlpha = 0.0f;
    private float scrollBarAlphaFuture = 0.0f;
    private long scrollBarAlphaFutureTime = -1L;

    public CompositeDisplayViewingScreen(Map<DisplayCategory<?>, List<DisplaySpec>> categoryMap, @Nullable CategoryIdentifier<?> category) {
        super(categoryMap, category);
    }

    @Override
    public void recalculateCategoryPage() {
        super.recalculateCategoryPage();
        this.selectedRecipeIndex = 0;
    }

    public void method_25426() {
        ArrayList<Widget> setupDisplay;
        super.method_25426();
        this.method_25396().clear();
        this.widgets.clear();
        this.buttonList.clear();
        this.displayRenderers.clear();
        int largestWidth = this.field_22789 - 100;
        int largestHeight = this.field_22790 - 40;
        DisplayCategory<Display> category = this.getCurrentCategory();
        DisplaySpec display = (DisplaySpec)((List)this.categoryMap.get(category)).get(this.selectedRecipeIndex);
        int guiWidth = class_3532.method_15340((int)(category.getDisplayWidth(display.provideInternalDisplay()) + 30), (int)0, (int)largestWidth) + 100;
        int guiHeight = class_3532.method_15340((int)(category.getDisplayHeight() + 40), (int)166, (int)largestHeight);
        this.bounds = new Rectangle(this.field_22789 / 2 - guiWidth / 2, this.field_22790 / 2 - guiHeight / 2, guiWidth, guiHeight);
        List<EntryIngredient> workstations = CategoryRegistry.getInstance().get(category.getCategoryIdentifier()).getWorkstations();
        if (!workstations.isEmpty()) {
            int ww = class_3532.method_15375((float)((float)(this.bounds.width - 16) / 18.0f));
            int w = Math.min(ww, workstations.size());
            int h = class_3532.method_15386((float)((float)workstations.size() / (float)ww));
            int xx = this.bounds.x + 16;
            int yy = this.bounds.y + this.bounds.height + 2;
            this.widgets.add(Widgets.createCategoryBase(new Rectangle(xx - 5, this.bounds.y + this.bounds.height - 5, 10 + w * 16, 12 + h * 16)));
            this.widgets.add(Widgets.createSlotBase(new Rectangle(xx - 1, yy - 1, 2 + w * 16, 2 + h * 16)));
            int index = 0;
            for (EntryIngredient workingStation : workstations) {
                this.widgets.add(new DefaultDisplayViewingScreen.WorkstationSlotWidget(xx, yy, workingStation));
                xx += 16;
                if (++index < ww) continue;
                index = 0;
                xx = this.bounds.x + 16;
                yy += 16;
            }
        }
        this.widgets.add(Widgets.createCategoryBase(this.bounds));
        this.scrollListBounds = new Rectangle(this.bounds.x + 4, this.bounds.y + 17, 102, guiHeight - 17 - 7);
        this.widgets.add(Widgets.createSlotBase(this.scrollListBounds));
        Rectangle recipeBounds = new Rectangle(this.bounds.x + 100 + (guiWidth - 100) / 2 - category.getDisplayWidth(display.provideInternalDisplay()) / 2, this.bounds.y + this.bounds.height / 2 - category.getDisplayHeight() / 2, category.getDisplayWidth(display.provideInternalDisplay()), category.getDisplayHeight());
        try {
            setupDisplay = this.getCurrentCategoryView(display.provideInternalDisplay()).setupDisplay(display.provideInternalDisplay(), recipeBounds);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            setupDisplay = new ArrayList();
            setupDisplay.add(Widgets.createRecipeBase(recipeBounds).color(-4521984));
            setupDisplay.add(Widgets.createLabel(new Point(recipeBounds.getCenterX(), recipeBounds.getCenterY() - 8), (class_2561)class_2561.method_43470((String)"Failed to initiate setupDisplay")));
            setupDisplay.add(Widgets.createLabel(new Point(recipeBounds.getCenterX(), recipeBounds.getCenterY() + 1), (class_2561)class_2561.method_43470((String)"Check console for error")));
        }
        this.setupTags(setupDisplay);
        this.transformFiltering(setupDisplay);
        this.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
        this.transformResultNotice(setupDisplay, this.resultStackToNotice);
        this.unifyIngredients(setupDisplay);
        for (EntryWidget widget : Widgets.walk(this.widgets, EntryWidget.class::isInstance)) {
            widget.removeTagMatch = true;
        }
        this.widgets.addAll(setupDisplay);
        Optional<ButtonArea> supplier = CategoryRegistry.getInstance().get(category.getCategoryIdentifier()).getPlusButtonArea();
        if (supplier.isPresent() && supplier.get().get(recipeBounds) != null) {
            this.widgets.add(Widgets.withTranslate(InternalWidgets.createAutoCraftingButtonWidget(recipeBounds, supplier.get().get(recipeBounds), (class_2561)class_2561.method_43470((String)supplier.get().getButtonText()), display::provideInternalDisplay, display::provideInternalDisplayIds, setupDisplay, category), 0.0, 0.0, 100.0));
        }
        this.initTabs(this.bounds.width);
        this.widgets.addAll(this.tabs.widgets());
        int index = 0;
        for (DisplaySpec recipeDisplay : (List)this.categoryMap.get(category)) {
            int finalIndex = index++;
            DisplayRenderer displayRenderer = this.getCurrentCategoryView(recipeDisplay.provideInternalDisplay()).getDisplayRenderer(recipeDisplay.provideInternalDisplay());
            this.displayRenderers.add(displayRenderer);
            this.buttonList.add(Widgets.createButton(new Rectangle(this.bounds.x + 5, 0, displayRenderer.getWidth(), displayRenderer.getHeight()), (class_2561)class_2561.method_43473()).onClick(button -> {
                this.selectedRecipeIndex = finalIndex;
                this.method_25426();
            }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.scrollListBounds.contains(point) || button.isFocused()).onRender((matrices, button) -> button.setEnabled(this.selectedRecipeIndex != finalIndex)));
        }
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.x + 4 + this.scrollListBounds.width / 2, this.bounds.y + 6), ((DisplayCategory)this.categories.get(this.selectedCategoryIndex)).getTitle(), label -> ViewSearchBuilder.builder().addAllCategories().open()).tooltip(new class_2561[]{class_2561.method_43471((String)"text.rei.view_all_categories"), class_2561.method_43469((String)"text.rei.view_all_categories.tooltip", (Object[])new Object[]{CategoryRegistry.getInstance().stream().filter(config -> !DisplayRegistry.getInstance().get(config.getCategoryIdentifier()).isEmpty()).count()}).method_27692(class_124.field_1063)}).noShadow().color(-12566464, -4473925).hoveredColor(-16760321, -17075));
        this.widgets.add(new ButtonListWidget(this.buttonList));
        this.method_25396().addAll(this.widgets);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            this.scrollBarAlpha = 1.0f;
            return true;
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesMouse(button)) {
            ++this.selectedRecipeIndex;
            if (this.selectedRecipeIndex >= ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size()) {
                this.selectedRecipeIndex = 0;
            }
            this.method_25426();
            return true;
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesMouse(button)) {
            --this.selectedRecipeIndex;
            if (this.selectedRecipeIndex < 0) {
                this.selectedRecipeIndex = ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() - 1;
            }
            this.method_25426();
            return true;
        }
        if (ConfigObject.getInstance().getPreviousScreenKeybind().matchesMouse(button)) {
            if (REIRuntimeImpl.getInstance().hasLastDisplayScreen()) {
                this.field_22787.method_1507(REIRuntimeImpl.getInstance().getLastDisplayScreen());
            } else {
                this.field_22787.method_1507(REIRuntime.getInstance().getPreviousScreen());
            }
            return true;
        }
        for (class_364 entry : this.method_25396()) {
            if (!entry.method_25402(mouseX, mouseY, button)) continue;
            this.method_25395(entry);
            if (button == 0) {
                this.method_25398(true);
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25400(char char_1, int int_1) {
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25400(char_1, int_1)) continue;
            return true;
        }
        return super.method_25400(char_1, int_1);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        double height = this.scrolling.getMaxScrollHeight();
        if (this.scrollListBounds.contains(mouseX, mouseY) && height > (double)(this.scrollListBounds.height - 2)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlphaFuture = 1.0f;
            }
            if ((float)(System.currentTimeMillis() - this.scrollBarAlphaFutureTime) > 300.0f) {
                this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            }
            return true;
        }
        REIRuntimeImpl.isWithinRecipeViewingScreen = true;
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25401(mouseX, mouseY, amount)) continue;
            REIRuntimeImpl.isWithinRecipeViewingScreen = false;
            return true;
        }
        REIRuntimeImpl.isWithinRecipeViewingScreen = false;
        if (this.bounds.contains(PointHelper.ofMouse())) {
            if (amount < 0.0 && ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.method_25426();
                return true;
            }
            if (((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() - 1;
                }
                this.method_25426();
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.widgets.sort(Comparator.comparingDouble(Widget::getZRenderingPriority));
        if (ConfigObject.getInstance().isCompositeScrollBarPermanent()) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 0.0f;
            this.scrollBarAlpha = 1.0f;
        } else if (this.scrollBarAlphaFutureTime > 0L) {
            long l = System.currentTimeMillis() - this.scrollBarAlphaFutureTime;
            if ((float)l > 300.0f) {
                if (this.scrollBarAlphaFutureTime == 0L) {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                    this.scrollBarAlphaFutureTime = -1L;
                } else if ((float)l > 2000.0f && this.scrollBarAlphaFuture == 1.0f) {
                    this.scrollBarAlphaFuture = 0.0f;
                    this.scrollBarAlphaFutureTime = System.currentTimeMillis();
                } else {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                }
            } else if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlpha = Math.min(this.scrollBarAlpha, 1.0f - Math.min(1.0f, (float)l / 300.0f));
            } else if (this.scrollBarAlphaFuture == 1.0f) {
                this.scrollBarAlpha = Math.max(Math.min(1.0f, (float)l / 300.0f), this.scrollBarAlpha);
            }
        }
        this.scrolling.updatePosition(delta);
        this.method_25420(matrices);
        CompositeDisplayViewingScreen.getOverlay().method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
        for (Widget widget : this.widgets) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    @Override
    public boolean method_25406(double double_1, double double_2, int int_1) {
        for (class_364 entry : this.method_25396()) {
            if (!entry.method_25406(double_1, double_2, int_1)) continue;
            return true;
        }
        return super.method_25406(double_1, double_2, int_1);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, int_1, double_3, double_4)) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 1.0f;
            return true;
        }
        for (class_364 entry : this.method_25396()) {
            if (!entry.method_25403(mouseX, mouseY, int_1, double_3, double_4)) continue;
            return true;
        }
        return super.method_25403(mouseX, mouseY, int_1, double_3, double_4);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258 && !this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            boolean boolean_1;
            boolean bl = boolean_1 = !CompositeDisplayViewingScreen.method_25442();
            if (!this.method_25407(boolean_1)) {
                this.method_25407(boolean_1);
            }
            return true;
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(keyCode, scanCode)) {
            if (((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.method_25426();
                return true;
            }
            return false;
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(keyCode, scanCode)) {
            if (((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() - 1;
                }
                this.method_25426();
                return true;
            }
            return false;
        }
        for (class_364 element : this.method_25396()) {
            if (!element.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (keyCode == 256) {
            class_310.method_1551().method_1507(REIRuntime.getInstance().getPreviousScreen());
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private class ButtonListWidget
    extends Widget {
        private final List<Button> buttonList;

        public ButtonListWidget(List<Button> buttonList) {
            this.buttonList = buttonList;
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            int yOffset = 0;
            matrices.method_22903();
            ScissorsHandler.INSTANCE.scissor(CompositeDisplayViewingScreen.this.scrolling.getBounds());
            for (Button button : this.buttonList) {
                button.getBounds().y = CompositeDisplayViewingScreen.this.scrollListBounds.y + 1 + yOffset - CompositeDisplayViewingScreen.this.scrolling.scrollAmountInt();
                if (button.getBounds().getMaxY() > CompositeDisplayViewingScreen.this.scrollListBounds.getMinY() && button.getBounds().getMinY() < CompositeDisplayViewingScreen.this.scrollListBounds.getMaxY()) {
                    button.method_25394(matrices, mouseX, mouseY, delta);
                }
                yOffset += button.getBounds().height;
            }
            for (int i = 0; i < this.buttonList.size(); ++i) {
                if (this.buttonList.get(i).getBounds().getMaxY() <= CompositeDisplayViewingScreen.this.scrollListBounds.getMinY() || this.buttonList.get(i).getBounds().getMinY() >= CompositeDisplayViewingScreen.this.scrollListBounds.getMaxY()) continue;
                CompositeDisplayViewingScreen.this.displayRenderers.get(i).setZ(1);
                CompositeDisplayViewingScreen.this.displayRenderers.get(i).render(matrices, this.buttonList.get(i).getBounds(), mouseX, mouseY, delta);
                Optional.ofNullable(CompositeDisplayViewingScreen.this.displayRenderers.get(i).getTooltip(TooltipContext.of(new Point(mouseX, mouseY)))).ifPresent(Tooltip::queue);
            }
            CompositeDisplayViewingScreen.this.scrolling.renderScrollBar(0, CompositeDisplayViewingScreen.this.scrollBarAlpha, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            ScissorsHandler.INSTANCE.removeLastScissor();
            matrices.method_22909();
        }

        public List<? extends class_364> method_25396() {
            return this.buttonList;
        }
    }
}

