/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.gui.config.RecipeBorderType;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class DisplayCompositeWidget
extends DelegateWidgetWithBounds
implements DraggableComponentProviderWidget<Object> {
    private final DisplaySpec display;
    private final List<Widget> widgets;

    public DisplayCompositeWidget(DisplaySpec display, List<Widget> widgets, Rectangle bounds) {
        super(Widgets.concat(widgets), () -> bounds);
        this.display = display;
        this.widgets = widgets;
    }

    @Override
    @Nullable
    public DraggableComponent<Object> getHovered(DraggingContext<class_437> context, double mouseX, double mouseY) {
        return StreamSupport.stream(Widgets.walk(this.widget.method_25396(), widget -> widget instanceof DraggableComponentProviderWidget).spliterator(), false).map(widget -> widget.getHovered(context, mouseX, mouseY)).filter(Objects::nonNull).findFirst().orElseGet(() -> {
            if (this.containsMouse(mouseX, mouseY)) {
                return new DisplayDraggableComponent(Widgets.concat(CollectionUtils.filterToList(this.widgets, w -> !(w instanceof Panel))), this.display.provideInternalDisplay(), this.getBounds(), this.getBounds());
            }
            return null;
        });
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        FavoriteEntry favoriteEntry;
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(DisplayCompositeWidget.mouse()) && ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(keyCode, scanCode) && (favoriteEntry = (FavoriteEntry)FavoriteEntryType.registry().get(FavoriteEntryType.DISPLAY).fromArgs(this.display.provideInternalDisplay()).get().left().orElse(null)) != null) {
            ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        FavoriteEntry favoriteEntry;
        if (super.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(mouseX, mouseY) && ConfigObject.getInstance().getFavoriteKeyCode().matchesMouse(button) && (favoriteEntry = (FavoriteEntry)FavoriteEntryType.registry().get(FavoriteEntryType.DISPLAY).fromArgs(this.display.provideInternalDisplay()).get().left().orElse(null)) != null) {
            ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
            return true;
        }
        return false;
    }

    public static class DisplayDraggableComponent
    implements DraggableComponent<Display> {
        private final Widget widget;
        private final Display display;
        private final Rectangle originBounds;
        private final Rectangle bounds;
        private final Panel panel;
        private final Slot slot;
        public boolean onFavoritesRegion;

        public DisplayDraggableComponent(Widget widget, Display display, Rectangle originBounds, Rectangle bounds) {
            this.widget = widget;
            this.display = display;
            this.originBounds = originBounds;
            this.bounds = bounds;
            this.panel = Widgets.createRecipeBase(bounds.clone());
            this.slot = Widgets.createSlot(new Rectangle()).disableBackground().disableHighlight().disableTooltips();
            for (EntryIngredient ingredient : display.getOutputEntries()) {
                this.slot.entries(ingredient);
            }
        }

        @Override
        public int getWidth() {
            if (this.onFavoritesRegion) {
                return 18;
            }
            return this.bounds.width / 2;
        }

        @Override
        public int getHeight() {
            if (this.onFavoritesRegion) {
                return 18;
            }
            return this.bounds.height / 2;
        }

        @Override
        public Display get() {
            return this.display;
        }

        @Override
        public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (DraggingContext.getInstance().isDraggingComponent()) {
                FavoritesListWidget favorites = ScreenOverlayImpl.getFavoritesListWidget();
                if (favorites != null) {
                    Rectangle favoritesBounds = favorites.getRegion().getBounds();
                    if (!this.onFavoritesRegion && new Rectangle(favoritesBounds.x + 5, favoritesBounds.y + 5, favoritesBounds.width - 10, favoritesBounds.height - 10).contains(DraggingContext.getInstance().getCurrentPosition())) {
                        this.onFavoritesRegion = true;
                    } else if (this.onFavoritesRegion && !favoritesBounds.contains(DraggingContext.getInstance().getCurrentPosition())) {
                        this.onFavoritesRegion = false;
                    }
                } else {
                    this.onFavoritesRegion = false;
                }
            } else {
                this.onFavoritesRegion = false;
            }
            matrices.method_22903();
            if (bounds.width <= Math.max(18, this.bounds.width / 2 - 6) && bounds.height <= Math.max(18, this.bounds.height / 2 - 6) && this.onFavoritesRegion) {
                this.panel.yTextureOffset(RecipeBorderType.LIGHTER.getYOffset());
                this.panel.getBounds().setBounds(bounds);
                this.panel.method_25394(matrices, mouseX, mouseY, delta);
                matrices.method_22903();
                matrices.method_22904(0.0, 0.5, 0.0);
                this.slot.getBounds().setBounds(bounds.getCenterX() - 7, bounds.getCenterY() - 7, 14, 14);
                this.slot.method_25394(matrices, mouseX, mouseY, delta);
                matrices.method_22909();
            } else {
                this.panel.yTextureOffset(ConfigObject.getInstance().getRecipeBorderType().getYOffset());
                matrices.method_22903();
                matrices.method_22904((double)bounds.getX(), (double)bounds.getY(), 1.0);
                matrices.method_22905((float)bounds.width / (float)this.bounds.getWidth(), (float)bounds.height / (float)this.bounds.getHeight(), 1.0f);
                matrices.method_22904((double)(-this.bounds.getX()), (double)(-this.bounds.getY()), 0.0);
                this.panel.getBounds().setBounds(this.bounds);
                this.panel.method_25394(matrices, mouseX, mouseY, delta);
                matrices.method_22909();
                matrices.method_22904((double)bounds.getX(), (double)bounds.getY(), 1.0);
                matrices.method_22905((float)bounds.width / (float)this.bounds.getWidth(), (float)bounds.height / (float)this.bounds.getHeight(), 1.0f);
                matrices.method_22904((double)(-this.bounds.getX()), (double)(-this.bounds.getY()), 0.0);
                this.widget.method_25394(matrices, -1000, -1000, delta);
            }
            matrices.method_22909();
        }

        @Override
        public void release(DraggedAcceptorResult result) {
            if (result == DraggedAcceptorResult.PASS) {
                DraggingContext.getInstance().renderBack(this, DraggingContext.getInstance().getCurrentBounds(), () -> this.originBounds);
            }
        }

        @Override
        public Rectangle getOriginBounds(Point mouse) {
            return this.originBounds.clone();
        }
    }
}

