/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TabWidget
extends WidgetWithBounds
implements DraggableStackProviderWidget {
    public boolean selected = false;
    public Renderer renderer;
    public class_2561 categoryName;
    public Rectangle bounds;
    public DisplayCategory<?> category;
    public int u;
    public int v;
    public float opacity = 1.0f;
    @Nullable
    private Predicate<TabWidget> onClick;
    private final NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    private TabWidget(Rectangle bounds, int u, int v, @Nullable Predicate<TabWidget> onClick) {
        this.bounds = bounds;
        this.u = u;
        this.v = v;
        this.onClick = onClick;
    }

    @ApiStatus.Internal
    public static TabWidget create(int id, int tabSize, int leftX, int bottomY, int u, int v, @Nullable Predicate<TabWidget> onClick) {
        return new TabWidget(new Rectangle(leftX + id * tabSize, bottomY - tabSize, tabSize, tabSize), u, v, onClick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return button == 0 && this.containsMouse(mouseX, mouseY) && this.onClick != null && this.onClick.test(this);
    }

    public void setRenderer(DisplayCategory<?> category, Renderer renderer, class_2561 categoryName, boolean selected) {
        this.renderer = renderer;
        this.category = category;
        this.selected = selected;
        this.categoryName = categoryName;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isShown() {
        return this.renderer != null;
    }

    public List<Widget> method_25396() {
        return Collections.emptyList();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.bounds.getMaxX() < 0 || this.opacity == 0.0f) {
            return;
        }
        if (this.renderer != null) {
            try (CloseableScissors scissors = Widget.scissor(matrices, new Rectangle(this.bounds.x, this.bounds.y + 2, this.bounds.width, this.selected ? this.bounds.height + 2 : this.bounds.height - 2));){
                this.darkBackgroundAlpha.update((double)delta);
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.setShaderTexture((int)0, (class_2960)InternalTextures.CHEST_GUI_TEXTURE);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                this.method_25302(matrices, this.bounds.x, this.bounds.y + 2, this.u + (this.selected ? this.bounds.width : 0), this.v, this.bounds.width, this.selected ? this.bounds.height + 2 : this.bounds.height - 2);
                RenderSystem.setShaderTexture((int)0, (class_2960)InternalTextures.CHEST_GUI_TEXTURE_DARK);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(((Float)this.darkBackgroundAlpha.value()).floatValue() * this.opacity));
                this.method_25302(matrices, this.bounds.x, this.bounds.y + 2, this.u + (this.selected ? this.bounds.width : 0), this.v, this.bounds.width, this.selected ? this.bounds.height + 2 : this.bounds.height - 2);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                this.renderer.setZ(100);
                this.renderer.render(matrices, new Rectangle(this.bounds.getCenterX() - 8, this.bounds.getCenterY() - 5, 16, 16), mouseX, mouseY, delta);
            }
            if (this.containsMouse(mouseX, mouseY) && this.category != null) {
                this.drawTooltip();
            }
        }
    }

    private void drawTooltip() {
        Tooltip tooltip = Tooltip.create(this.categoryName);
        if (this.minecraft.field_1690.field_1827) {
            tooltip.add((class_2561)class_2561.method_43470((String)this.category.getIdentifier().toString()).method_27692(class_124.field_1063));
        }
        if (ConfigObject.getInstance().shouldAppendModNames()) {
            tooltip.add(ClientHelper.getInstance().getFormattedModFromIdentifier(this.category.getIdentifier()));
        }
        tooltip.queue();
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public double getZRenderingPriority() {
        return this.selected ? 10.0 : -10.0;
    }

    @Override
    @Nullable
    public DraggableStack getHoveredStack(final DraggingContext<class_437> context, double mouseX, double mouseY) {
        Renderer renderer;
        if (this.isShown() && (renderer = this.renderer) instanceof EntryStack) {
            final EntryStack entryStack = (EntryStack)renderer;
            if (this.containsMouse(mouseX, mouseY)) {
                return new DraggableStack(){
                    EntryStack<?> stack;
                    {
                        this.stack = entryStack.copy();
                    }

                    @Override
                    public EntryStack<?> getStack() {
                        return this.stack;
                    }

                    @Override
                    public void drag() {
                    }

                    @Override
                    public void release(DraggedAcceptorResult result) {
                        if (result == DraggedAcceptorResult.PASS) {
                            context.renderBackToPosition((DraggableStack)this, DraggingContext.getInstance().getCurrentPosition(), () -> new Point(TabWidget.this.getBounds().getCenterX() - 8, TabWidget.this.getBounds().getCenterY() - 8));
                        }
                    }
                };
            }
        }
        return null;
    }
}

