/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.display;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.registry.display.DisplayCache;
import me.shedaniel.rei.impl.common.InternalLogger;

public class DisplayCacheImpl
implements DisplayCache {
    private final boolean cache;
    private Set<Display> displaysCached = new ReferenceOpenHashSet();
    private Set<Display> displaysNotCached = Collections.synchronizedSet(new ReferenceOpenHashSet());
    private SetMultimap<EntryStack<?>, Display> displaysByInput;
    private SetMultimap<EntryStack<?>, Display> displaysByOutput;
    private boolean preprocessed = false;

    public DisplayCacheImpl(boolean init) {
        this.cache = init && ConfigObject.getInstance().doesCacheDisplayLookup();
        this.displaysByInput = DisplayCacheImpl.createSetMultimap();
        this.displaysByOutput = DisplayCacheImpl.createSetMultimap();
    }

    @Override
    public boolean doesCache() {
        return this.cache;
    }

    @Override
    public boolean isCached(Display display) {
        return this.cache && this.displaysCached.contains(display);
    }

    @Override
    public void add(Display display) {
        if (this.cache) {
            if (!this.preprocessed) {
                this.displaysNotCached.add(display);
            } else {
                this.process(display);
                this.displaysCached.add(display);
            }
        } else {
            this.displaysNotCached.add(display);
        }
    }

    @Override
    public boolean remove(Display display) {
        if (this.cache) {
            if (!this.preprocessed) {
                return this.displaysNotCached.remove(display);
            }
            boolean removed = this.displaysCached.remove(display);
            if (removed) {
                for (EntryIngredient input : display.getInputEntries()) {
                    for (EntryStack stack : input) {
                        this.displaysByInput.remove((Object)stack, (Object)display);
                    }
                }
                for (EntryIngredient output : display.getOutputEntries()) {
                    for (EntryStack stack : output) {
                        this.displaysByOutput.remove((Object)stack, (Object)display);
                    }
                }
            }
            return removed;
        }
        return this.displaysNotCached.remove(display);
    }

    @Override
    public void endReload() {
        if (this.cache) {
            if (this.preprocessed) {
                InternalLogger.getInstance().error("DisplayCache#endReload called after preprocessed!");
            }
            InternalLogger.getInstance().debug("Processing %d displays for optimal lookup performance...", this.displaysNotCached.size());
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.displaysCached = new ReferenceOpenHashSet(this.displaysNotCached.size());
            this.displaysByInput = DisplayCacheImpl.createSetMultimap();
            this.displaysByOutput = DisplayCacheImpl.createSetMultimap();
            for (Display display : this.displaysNotCached) {
                this.process(display);
            }
            this.displaysCached.addAll(this.displaysNotCached);
            this.displaysNotCached = Set.of();
            this.preprocessed = true;
            InternalLogger.getInstance().debug("Processed displays for optimal lookup performance in %s.", stopwatch.stop());
        }
    }

    @Override
    public Set<Display> getDisplaysNotCached() {
        return this.displaysNotCached;
    }

    @Override
    public Set<Display> getDisplaysByInput(EntryStack<?> stack) {
        return this.displaysByInput.get(stack);
    }

    @Override
    public Set<Display> getDisplaysByOutput(EntryStack<?> stack) {
        return this.displaysByOutput.get(stack);
    }

    private void process(Display display) {
        for (EntryIngredient input : display.getInputEntries()) {
            for (EntryStack stack : input) {
                this.displaysByInput.put((Object)stack, (Object)display);
            }
        }
        for (EntryIngredient output : display.getOutputEntries()) {
            for (EntryStack stack : output) {
                this.displaysByOutput.put((Object)stack, (Object)display);
            }
        }
    }

    private static SetMultimap<EntryStack<?>, Display> createSetMultimap() {
        return Multimaps.newSetMultimap((Map)new Object2ObjectOpenCustomHashMap(5000, new Hash.Strategy<EntryStack<?>>(){

            public int hashCode(EntryStack<?> stack) {
                return Long.hashCode(EntryStacks.hashFuzzy(stack));
            }

            public boolean equals(EntryStack<?> o1, EntryStack<?> o2) {
                return EntryStacks.equalsFuzzy(o1, o2);
            }
        }), ReferenceOpenHashSet::new);
    }
}

